/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.ellipticcurves;

import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.common.exceptions.DifferentCurvesException;
import de.flexiprovider.common.exceptions.InvalidFormatException;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurve;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.finitefields.GFElement;
import de.flexiprovider.ec.parameters.CurveParams;

public abstract class Point {
    protected EllipticCurve mE;
    protected FlexiBigInt mP;
    public static final int ENCODING_TYPE_UNCOMPRESSED = 0;
    public static final int ENCODING_TYPE_COMPRESSED = 1;
    public static final int ENCODING_TYPE_HYBRID = 2;

    public abstract Object clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public final EllipticCurve getE() {
        return this.mE;
    }

    public abstract GFElement getX();

    public abstract GFElement getY();

    public abstract GFElement getZ();

    public abstract GFElement getXAffin();

    public abstract GFElement getYAffin();

    public abstract Point getAffin();

    public abstract boolean onCurve();

    public abstract boolean isZero();

    public final boolean isNegativeOf(Point other) {
        return this.equals(other.negate());
    }

    public abstract Point add(Point var1) throws DifferentCurvesException;

    public abstract void addToThis(Point var1) throws DifferentCurvesException;

    public abstract Point addAffine(Point var1) throws DifferentCurvesException;

    public abstract Point subtract(Point var1) throws DifferentCurvesException;

    public abstract void subtractFromThis(Point var1) throws DifferentCurvesException;

    public abstract Point multiplyBy2();

    public abstract void multiplyThisBy2();

    public abstract Point multiplyBy2Affine();

    public abstract Point negate();

    public abstract void negateThis();

    public final byte[] EC2OSP(int type) {
        switch (type) {
            case 1: {
                return this.encodeCompressed();
            }
            case 0: {
                return this.encodeUncompressed();
            }
            case 2: {
                return this.encodeHybrid();
            }
        }
        return null;
    }

    public static Point OS2ECP(byte[] encoded, CurveParams params) throws InvalidPointException, InvalidFormatException, InvalidParameterSpecException {
        Point mW;
        EllipticCurve mE = params.getE();
        if (mE instanceof EllipticCurveGF2n) {
            mW = new PointGF2n(encoded, (EllipticCurveGF2n)mE);
        } else if (mE instanceof EllipticCurveGFP) {
            mW = new PointGFP(encoded, (EllipticCurveGFP)mE);
        } else {
            throw new InvalidParameterSpecException("the parameters are defined neither over GF(p) nor over GF(2^n)");
        }
        return mW;
    }

    abstract byte[] encodeUncompressed();

    abstract byte[] encodeCompressed();

    abstract byte[] encodeHybrid();
}

