/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.exceptions.DigestException;
import java.security.MessageDigestSpi;

public abstract class MessageDigest
extends MessageDigestSpi {
    protected final int engineGetDigestLength() {
        return this.getDigestLength();
    }

    protected final void engineUpdate(byte input) {
        this.update(input);
    }

    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.update(input, offset, len);
    }

    protected final byte[] engineDigest() {
        return this.digest();
    }

    protected final void engineReset() {
        this.reset();
    }

    public abstract int getDigestLength();

    public abstract void update(byte var1);

    public final void update(byte[] input) {
        if (input == null) {
            return;
        }
        this.update(input, 0, input.length);
    }

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] digest();

    public final byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    public final int digest(byte[] buf, int offset, int len) throws DigestException {
        byte[] digest = this.digest();
        if (len < digest.length) {
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - offset < digest.length) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(digest, 0, buf, offset, digest.length);
        return digest.length;
    }

    public abstract void reset();
}

