/*
 * Decompiled with CFR 0.152.
 */
package codec.x501;

import codec.x501.BadNameException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class RFC1779Parser {
    public static final String SPECIALS = ",+=\"<>\n#;\\";
    public static final String SEPARATORS = ",;";
    public static final String ESCAPE = "\\";
    public static final String QUOTE = "\"";
    protected LinkedList klist_ = new LinkedList();
    protected LinkedList vlist_ = new LinkedList();

    public static void main(String[] argv) {
        RFC1779Parser parser = new RFC1779Parser();
        int n = 0;
        while (n < argv.length) {
            System.out.println("Arg is: '" + argv[n] + "'");
            try {
                Iterator i = parser.parse(argv[n]);
                while (i.hasNext()) {
                    Entry entry = (Entry)i.next();
                    System.out.println("'" + (String)entry.getKey() + "=" + (String)entry.getValue() + "'");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n;
        }
    }

    public Iterator parse(String rfc1779name) throws BadNameException {
        int state = 0;
        String key = new String();
        StringBuffer value = new StringBuffer();
        StringTokenizer st = new StringTokenizer(rfc1779name, SPECIALS, true);
        this.klist_.clear();
        this.vlist_.clear();
        block10: while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            switch (state) {
                case 0: {
                    if (SPECIALS.indexOf(tok.charAt(0)) < 0) {
                        key = tok.trim();
                        this.klist_.addFirst(key);
                        state = 1;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Key starts with SPECIAL '" + tok + "'!");
                }
                case 1: {
                    if (tok.equals("=")) {
                        state = 2;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "'=' expected after '" + key + "'!");
                }
                case 2: {
                    if (tok.equals(ESCAPE)) {
                        state = 3;
                        break;
                    }
                    if (tok.equals(QUOTE)) {
                        state = 4;
                        break;
                    }
                    if (SEPARATORS.indexOf(tok.charAt(0)) >= 0) {
                        this.vlist_.addFirst(new String());
                        state = 0;
                        break;
                    }
                    if (SPECIALS.indexOf(tok.charAt(0)) < 0) {
                        if (tok.trim().length() <= 0) break;
                        value.append(tok);
                        state = 5;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Unescaped or quoted SPECIAL '" + tok + "' after '" + key + "'!");
                }
                case 3: {
                    if (SPECIALS.indexOf(tok.charAt(0)) >= 0) {
                        value.append(tok);
                        state = 5;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Can't ESCAPE non-special character!");
                }
                case 4: {
                    if (tok.equals(QUOTE)) {
                        this.vlist_.addFirst(value.toString().trim());
                        value.setLength(0);
                        state = 7;
                        break;
                    }
                    if (tok.equals(ESCAPE)) {
                        state = 6;
                        break;
                    }
                    if (SPECIALS.indexOf(tok.charAt(0)) < 0) {
                        value.append(tok);
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Unescaped SPECIAL '" + tok + "' in value of '" + key + "'!");
                }
                case 5: {
                    if (tok.equals(ESCAPE)) {
                        state = 3;
                        break;
                    }
                    if (SPECIALS.indexOf(tok.charAt(0)) < 0) {
                        value.append(tok);
                        break;
                    }
                    if (SEPARATORS.indexOf(tok.charAt(0)) >= 0) {
                        this.vlist_.addFirst(value.toString().trim());
                        value.setLength(0);
                        state = 0;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Unescaped SPECIAL '" + tok + "' in value of '" + key + "'!");
                }
                case 6: {
                    if (SPECIALS.indexOf(tok.charAt(0)) >= 0) {
                        value.append(tok);
                        state = 4;
                        break;
                    }
                    throw new BadNameException("(" + state + ") " + "Can't ESCAPE non-special character!");
                }
                case 7: {
                    if (SEPARATORS.indexOf(tok.charAt(0)) >= 0) {
                        state = 0;
                        break;
                    }
                    if (tok.trim().length() == 0) continue block10;
                    throw new BadNameException("(" + state + ") " + "SEPARATOR expected!");
                }
            }
        }
        if (state != 7 && state != 2 && state != 5) {
            throw new BadNameException("(" + state + ") " + "Not in a final state!");
        }
        if (state == 2 || state == 5) {
            this.vlist_.addFirst(value.toString().trim());
        }
        return new Entry(this.klist_, this.vlist_);
    }

    public class Entry
    implements Iterator {
        private Iterator kl_;
        private Iterator vl_;
        private Object k_;
        private Object v_;

        Entry(List k, List v) {
            this.kl_ = k.iterator();
            this.vl_ = v.iterator();
        }

        public boolean hasNext() {
            return this.kl_.hasNext() && this.vl_.hasNext();
        }

        public Object next() {
            this.k_ = this.kl_.next();
            this.v_ = this.vl_.next();
            return this;
        }

        public Object getKey() {
            return this.k_;
        }

        public Object getValue() {
            return this.v_;
        }

        public void remove() {
            throw new UnsupportedOperationException("I don't remove!");
        }
    }
}

