/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1BMPString;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1SequenceOf;
import codec.pkcs12.SafeBag;
import codec.x501.Attribute;
import java.io.Serializable;

public class SafeContents
extends ASN1SequenceOf
implements Serializable {
    protected static final int[] OID_ = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 6};
    protected static final int[] FN_OID_ = new int[]{1, 2, 840, 113549, 1, 9, 20};
    protected static final int[] LK_OID_ = new int[]{1, 2, 840, 113549, 1, 9, 21};
    static /* synthetic */ Class class$codec$pkcs12$SafeBag;

    public SafeContents() {
        super(class$codec$pkcs12$SafeBag == null ? (class$codec$pkcs12$SafeBag = SafeContents.class$("codec.pkcs12.SafeBag")) : class$codec$pkcs12$SafeBag);
    }

    public SafeContents(ASN1RegisteredType bag) {
        super(class$codec$pkcs12$SafeBag == null ? (class$codec$pkcs12$SafeBag = SafeContents.class$("codec.pkcs12.SafeBag")) : class$codec$pkcs12$SafeBag);
        this.addSafeBag(bag);
    }

    public SafeContents(ASN1RegisteredType bag, Attribute[] attr) {
        super(class$codec$pkcs12$SafeBag == null ? (class$codec$pkcs12$SafeBag = SafeContents.class$("codec.pkcs12.SafeBag")) : class$codec$pkcs12$SafeBag);
        this.addSafeBag(bag, attr);
    }

    public SafeContents(ASN1RegisteredType bag, String user_fn, byte[] lk_id) {
        super(class$codec$pkcs12$SafeBag == null ? (class$codec$pkcs12$SafeBag = SafeContents.class$("codec.pkcs12.SafeBag")) : class$codec$pkcs12$SafeBag);
        Attribute[] attr;
        Attribute attrUserFn = null;
        Attribute attrUserKeyId = null;
        if (user_fn != null && !user_fn.equals("")) {
            ASN1ObjectIdentifier fnOID = new ASN1ObjectIdentifier(FN_OID_);
            attrUserFn = new Attribute(fnOID, new ASN1BMPString(user_fn));
        }
        if (lk_id != null && lk_id.length > 0) {
            ASN1ObjectIdentifier lkOID = new ASN1ObjectIdentifier(LK_OID_);
            attrUserKeyId = new Attribute(lkOID, new ASN1OctetString(lk_id));
        }
        if (user_fn != null && lk_id != null) {
            attr = new Attribute[]{attrUserFn, attrUserKeyId};
            this.addSafeBag(bag, attr);
        } else if (user_fn == null && lk_id != null) {
            attr = new Attribute[]{attrUserKeyId};
            this.addSafeBag(bag, attr);
        } else if (user_fn != null && lk_id == null) {
            attr = new Attribute[]{attrUserFn};
            this.addSafeBag(bag, attr);
        } else {
            this.addSafeBag(bag);
        }
    }

    public void addSafeBag(ASN1RegisteredType bag) {
        SafeBag safeBag = new SafeBag();
        safeBag.setBagContents(bag);
        this.add(safeBag);
    }

    public void addSafeBag(ASN1RegisteredType bag, Attribute[] attr) {
        SafeBag safeBag = new SafeBag();
        safeBag.setBagContents(bag);
        safeBag.setAttributes(attr);
        this.add(safeBag);
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(OID_);
    }

    public SafeBag getSafeBag(int i) {
        return (SafeBag)this.get(i);
    }

    public SafeBag[] getSafeBags() {
        SafeBag[] safeArray = new SafeBag[this.size()];
        int i = 0;
        while (i < this.size()) {
            safeArray[i] = (SafeBag)this.get(i);
            ++i;
        }
        return safeArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

