/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.BERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.pkcs1.DigestInfo;
import codec.pkcs12.AuthenticatedSafe;
import codec.pkcs12.CertBag;
import codec.pkcs12.MacData;
import codec.pkcs12.PKCS8ShroudedKeyBag;
import codec.pkcs12.SafeContents;
import codec.pkcs7.ContentInfo;
import codec.pkcs7.Data;
import codec.pkcs7.SignedData;
import codec.pkcs7.Signer;
import codec.pkcs7.SignerInfo;
import codec.pkcs7.Verifier;
import codec.x501.BadNameException;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PFX
extends ASN1Sequence
implements Serializable {
    protected static ASN1Integer version_;
    protected ContentInfo authSafe_;
    protected MacData macData_;
    private AuthenticatedSafe authentSafe_;
    private int[] SHA_OID = new int[]{1, 3, 14, 3, 2, 26};
    public static final int INTEGRITY_MODE_NONE = 0;
    public static final int INTEGRITY_MODE_PASSWORD = 1;
    public static final int INTEGRITY_MODE_PUBLIC_KEY = 2;
    protected int INTEGRITY_MODE_;

    public PFX() {
        version_ = new ASN1Integer();
        this.add(version_);
        this.authSafe_ = new ContentInfo();
        this.add(this.authSafe_);
        this.macData_ = new MacData();
        this.macData_.setOptional(true);
        this.add(this.macData_);
    }

    public PFX(AuthenticatedSafe authSafe) throws ASN1Exception {
        version_ = new ASN1Integer(3);
        this.add(version_);
        this.setAuthenticatedSafe(authSafe);
        this.INTEGRITY_MODE_ = 0;
    }

    public PFX(AuthenticatedSafe authSafe, char[] pwd) throws ASN1Exception, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        version_ = new ASN1Integer(3);
        this.add(version_);
        this.setAuthenticatedSafe(authSafe);
        this.addMacData(pwd);
        this.INTEGRITY_MODE_ = 1;
    }

    public PFX(AuthenticatedSafe authSafe, PrivateKey pk, X509Certificate cert, String sigAlgName, AlgorithmParameters params) throws SignatureException, GeneralSecurityException, ASN1Exception {
        byte[] data = null;
        version_ = new ASN1Integer(3);
        this.add(version_);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEREncoder encoder = new DEREncoder(baos);
            authSafe.encode(encoder);
            data = baos.toByteArray();
            baos.close();
            SignedData signedData = new SignedData();
            signedData.setData(data);
            SignerInfo signerInfo = new SignerInfo(cert, sigAlgName, params);
            Signer sig = new Signer(signedData, signerInfo, pk);
            sig.update();
            sig.sign();
            this.authSafe_ = new ContentInfo(signedData);
            this.add(this.authSafe_);
            this.INTEGRITY_MODE_ = 2;
        }
        catch (IOException io) {
            System.out.println("Internal Error. Shouldn't occur:");
            io.printStackTrace();
            throw new GeneralSecurityException("Caught IOException: " + io.getMessage());
        }
        catch (BadNameException io) {
            System.out.println("Internal Error. Shouldn't occur:");
            io.printStackTrace();
            throw new GeneralSecurityException("Caught BadNameException: " + io.getMessage());
        }
    }

    public PFX(PrivateKey pr_key, X509Certificate cert, X509Certificate[] chain, char[] pin, String user_fn, byte[] lk_id) throws GeneralSecurityException, CertificateEncodingException, ASN1Exception {
        try {
            SafeContents sc_cert = new SafeContents(new CertBag(cert), user_fn, lk_id);
            if (chain != null) {
                int i = 0;
                while (i < chain.length) {
                    sc_cert.addSafeBag(new CertBag(chain[i]));
                    ++i;
                }
            }
            PKCS8ShroudedKeyBag kb = new PKCS8ShroudedKeyBag();
            kb.setPrivateKey(pr_key, pin, "PbeWithSHAAnd3_KeyTripleDES_CBC");
            SafeContents sc = new SafeContents(kb, user_fn, lk_id);
            AuthenticatedSafe authSafe = new AuthenticatedSafe(sc);
            authSafe.addSafeContents(sc_cert, pin, "PbeWithSHAAnd40BitRC2_CBC");
            version_ = new ASN1Integer(3);
            this.add(version_);
            this.setAuthenticatedSafe(authSafe);
            this.addMacData(pin);
        }
        catch (IOException e) {
            System.out.println("Internal Error. Shouldn't occur:");
            e.printStackTrace();
            throw new GeneralSecurityException("Caught IOException: " + e.getMessage());
        }
    }

    private void setAuthenticatedSafe(AuthenticatedSafe authSafe) throws ASN1Exception {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEREncoder encoder = new DEREncoder(baos);
            this.authentSafe_ = authSafe;
            this.authentSafe_.encode(encoder);
            byte[] rawdata = baos.toByteArray();
            baos.close();
            Data data = new Data(rawdata);
            this.authSafe_ = new ContentInfo(data);
            this.add(this.authSafe_);
        }
        catch (IOException e) {
            System.out.println("Internal Error. Should not occur:");
            e.printStackTrace();
        }
    }

    private byte[] generateKeyBytes(SecretKey pbeKey, byte[] salt, int iterationCount) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] passwd = pbeKey.getEncoded();
        byte[] mD = new byte[64];
        int i = 0;
        while (i < mD.length) {
            mD[i] = 3;
            ++i;
        }
        byte[] mP = this.augment(passwd, 64);
        byte[] mS = this.augment(salt, 64);
        byte[] mI = new byte[mP.length + mS.length];
        System.arraycopy(mS, 0, mI, 0, mS.length);
        System.arraycopy(mP, 0, mI, mS.length, mP.length);
        md.update(mD);
        md.update(mI);
        byte[] mA = md.digest();
        int i2 = 1;
        while (i2 < iterationCount) {
            md.update(mA);
            mA = md.digest();
            ++i2;
        }
        return mA;
    }

    private byte[] augment(byte[] in, int v) {
        int n = in.length;
        int tmp = (n + v - 1) / v;
        int amount = v * tmp;
        byte[] out = new byte[amount];
        int iter = amount / n;
        int i = 0;
        while (i < iter) {
            System.arraycopy(in, 0, out, i * n, n);
            ++i;
        }
        if (amount % n != 0) {
            System.arraycopy(in, 0, out, iter * n, amount % n);
        }
        return out;
    }

    private void addMacData(char[] pwd) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, ASN1Exception {
        try {
            int iter = 1024;
            byte[] salt = new byte[64];
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(salt);
            PBEKeySpec pbeSpec = new PBEKeySpec(pwd);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC");
            SecretKey pbeKey = skf.generateSecret(pbeSpec);
            byte[] keyBytes = this.generateKeyBytes(pbeKey, salt, iter);
            Mac hmac = Mac.getInstance("HmacSHA1");
            hmac.init(new SecretKeySpec(keyBytes, "HmacSHA1"), null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEREncoder encoder = new DEREncoder(baos);
            this.authentSafe_.encode(encoder);
            byte[] rawdata = baos.toByteArray();
            baos.close();
            byte[] macData = hmac.doFinal(rawdata);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.SHA_OID), new ASN1Null());
            DigestInfo digest = new DigestInfo(algId, macData);
            this.macData_ = new MacData(digest, salt, iter);
            this.add(this.macData_);
            this.INTEGRITY_MODE_ = 1;
        }
        catch (IOException e) {
            System.out.println("Internal Error. Should not occur:");
            e.printStackTrace();
        }
    }

    public boolean checkIntegrity(char[] pwd) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidKeySpecException {
        if (this.INTEGRITY_MODE_ != 1) {
            throw new IllegalStateException("bad integrity mode (not password integrity)!");
        }
        byte[] dataToVerify = this.macData_.getMacData().getDigest();
        PBEKeySpec keySpec = new PBEKeySpec(pwd);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC");
        SecretKey key = skf.generateSecret(keySpec);
        Mac hmac = Mac.getInstance("HmacSHA1");
        PBEParameterSpec params = new PBEParameterSpec(this.macData_.getSalt(), this.macData_.getIterationCount());
        hmac.init(key, params);
        byte[] data = ((Data)this.authSafe_.getContent()).getByteArray();
        byte[] macData = hmac.doFinal(data);
        boolean value = true;
        int i = 0;
        while (i < macData.length) {
            value = macData[i] == dataToVerify[i] && value;
            ++i;
        }
        return value;
    }

    public X509Certificate checkIntegrity(X509Certificate cert) throws GeneralSecurityException {
        if (this.INTEGRITY_MODE_ != 2) {
            throw new IllegalStateException("bad integrity mode (not password integrity)!");
        }
        SignedData sigDat = (SignedData)this.authSafe_.getContent();
        Verifier ver = new Verifier(sigDat, null, cert);
        ver.update();
        return ver.verify();
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        this.INTEGRITY_MODE_ = this.macData_ != null ? 1 : (this.authSafe_.getContent() instanceof SignedData ? 2 : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthenticatedSafe getAuthSafe() throws ASN1Exception, IllegalStateException {
        byte[] encodedData;
        if (this.authSafe_.getContent() instanceof Data) {
            encodedData = ((Data)this.authSafe_.getContent()).getByteArray();
        } else {
            if (!(this.authSafe_.getContent() instanceof SignedData)) throw new IllegalStateException("The contents of the PFX is not a valid type.");
            ASN1Type content = ((SignedData)this.authSafe_.getContent()).getContent();
            if (!(content instanceof Data)) throw new IllegalStateException("unable to extract authSafe encoded data!");
            encodedData = ((Data)content).getByteArray();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedData);
        this.authentSafe_ = new AuthenticatedSafe();
        try {
            BERDecoder decoder = new BERDecoder(bais);
            this.authentSafe_.decode(decoder);
            bais.close();
            return this.authentSafe_;
        }
        catch (IOException e) {
            System.out.println("Internal Error. Should not occur:");
            e.printStackTrace();
        }
        return this.authentSafe_;
    }

    public int getIntegrityMode() {
        return this.INTEGRITY_MODE_;
    }

    public ASN1Integer getVersion() {
        return version_;
    }

    public String toString() {
        String res = "PFX {\n";
        res = res + " Version: " + version_.getBigInteger().toString() + "\n";
        try {
            res = res + " " + this.getAuthSafe().toString() + "\n";
        }
        catch (Exception e) {
            res = res + " <AuthenticatedSafe not printable. Caught " + e.getClass().getName() + ">\n";
        }
        if (this.macData_ == null) {
            res = res + " No MacData\n";
        } else {
            try {
                res = res + " MacData: " + this.macData_.toString() + "\n";
            }
            catch (Exception e) {
                res = res + " <MacData not printable. Caught " + e.getClass().getName() + ">\n";
            }
        }
        if (this.INTEGRITY_MODE_ == 0) {
            res = res + "NO INTEGRITY PROTECTION\n";
        } else if (this.INTEGRITY_MODE_ == 1) {
            res = res + "Integrity is guaranteed by password integrity mode\n";
        } else if (this.INTEGRITY_MODE_ == 2) {
            res = res + "Integrity is guaranteed by public-key integrity mode\n";
        }
        res = res + "}";
        return res;
    }
}

