/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractString;
import codec.asn1.ASN1Exception;
import codec.asn1.ConstraintException;

public class ASN1UniversalString
extends ASN1AbstractString {
    public ASN1UniversalString() {
    }

    public ASN1UniversalString(String s) {
        super(s);
    }

    public int getTag() {
        return 28;
    }

    public String convert(byte[] b) throws ASN1Exception {
        if (b == null) {
            throw new NullPointerException("Cannot convert null array!");
        }
        if (b.length % 4 != 0) {
            throw new ConstraintException("Truncated character encoding!");
        }
        char[] c = new char[b.length / 4];
        int j = 0;
        int i = 0;
        while (i < c.length) {
            c[i] = (char)(b[j] << 24 & 0xFF000000 | b[j + 1] << 16 & 0xFF0000 | b[j + 2] << 8 & 0xFF00 | b[j + 3] & 0xFF);
            ++i;
            j += 4;
        }
        return String.valueOf(c);
    }

    public byte[] convert(String s) {
        if (s == null) {
            throw new NullPointerException("Cannot convert null string!");
        }
        char[] c = s.toCharArray();
        byte[] b = new byte[c.length * 4];
        int i = 0;
        int j = 0;
        while (i < c.length) {
            b[j++] = (byte)(c[i] >>> 24 & 0xFF);
            b[j++] = (byte)(c[i] >>> 16 & 0xFF);
            b[j++] = (byte)(c[i] >>> 8 & 0xFF);
            b[j++] = (byte)(c[i] & 0xFF);
            ++i;
        }
        return b;
    }

    public int convertedLength(String s) {
        return s.length() * 4;
    }
}

