/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1Collection;
import codec.asn1.ASN1CollectionOf;
import codec.asn1.ASN1Exception;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ASN1AbstractCollection
extends ArrayList
implements ASN1Collection,
Cloneable,
Externalizable {
    private boolean optional_ = false;
    private boolean explicit_ = true;
    private Constraint constraint_;

    public abstract int getTag();

    public ASN1AbstractCollection() {
    }

    public ASN1AbstractCollection(int capacity) {
        super(capacity);
    }

    public Object getValue() {
        return this;
    }

    public Collection getCollection() {
        return this;
    }

    public void setOptional(boolean optional) {
        this.optional_ = optional;
    }

    public boolean isOptional() {
        return this.optional_;
    }

    public int getTagClass() {
        return 0;
    }

    public void setExplicit(boolean explicit) {
        this.explicit_ = explicit;
    }

    public boolean isExplicit() {
        return this.explicit_;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint_ = constraint;
    }

    public Constraint getConstraint() {
        return this.constraint_;
    }

    public void checkConstraints() throws ConstraintException {
        if (this.constraint_ != null) {
            this.constraint_.constrain(this);
        }
    }

    public boolean isType(int tag, int tagclass) {
        return this.getTag() == tag && this.getTagClass() == tagclass;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        this.checkConstraints();
        enc.writeCollection(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readCollection(this);
        this.checkConstraints();
    }

    public String toString() {
        String s = this.removePackageName(this.getClass());
        StringBuffer buf = new StringBuffer();
        buf.append(s);
        if (this.isOptional()) {
            buf.append(" OPTIONAL");
        }
        if (this instanceof ASN1CollectionOf) {
            buf.append(" SEQUENCE OF " + this.removePackageName(((ASN1CollectionOf)((Object)this)).getElementType()));
        } else {
            buf.append(" SEQUENCE ");
        }
        buf.append(" {\n");
        Iterator i = ((AbstractList)this).iterator();
        while (i.hasNext()) {
            buf.append(i.next().toString());
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private String removePackageName(Class clazz) {
        String s = clazz.getName();
        int n = s.lastIndexOf(46);
        if (n < 0) {
            n = -1;
        }
        if ((s = s.substring(n + 1)).startsWith("ASN1")) {
            s = s.substring(4);
        }
        return s;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
            out.write(res);
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.decode(new DERDecoder((ObjectInputStream)in));
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

