/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.worker;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanJobResult;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanJobServerSession;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketImpl;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;
import org.gearman.common.GearmanSessionEvent;
import org.gearman.common.GearmanSessionEventHandler;
import org.gearman.common.GearmanTask;
import org.gearman.util.ByteUtils;
import org.gearman.worker.DefaultGearmanFunctionFactory;
import org.gearman.worker.GearmanFunction;
import org.gearman.worker.GearmanFunctionFactory;
import org.gearman.worker.GearmanWorker;

public class GearmanWorkerImpl
implements GearmanWorker,
GearmanSessionEventHandler {
    private static final String DESCRIPION_PREFIX = "GearmanWorker";
    private Queue<GearmanFunction> functionList = new LinkedList<GearmanFunction>();
    private Selector ioAvailable = null;
    private static final Logger LOG = Logger.getLogger("org.gearman.worker.logger");
    private String id = "GearmanWorker:" + Thread.currentThread().getId();
    private Map<String, FunctionDefinition> functionMap = new HashMap<String, FunctionDefinition>();
    private State state = State.IDLE;
    private ExecutorService executorService;
    private Map<GearmanJobServerSession, GearmanTask> taskMap = null;
    private Map<SelectionKey, GearmanJobServerSession> sessionMap = null;

    public GearmanWorkerImpl() {
        this(null);
    }

    private GearmanWorkerImpl(ExecutorService executorService) {
        this.executorService = executorService;
        this.taskMap = new HashMap<GearmanJobServerSession, GearmanTask>();
        this.sessionMap = new HashMap<SelectionKey, GearmanJobServerSession>();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void work() {
        if (!this.state.equals((Object)State.IDLE)) {
            throw new IllegalStateException("Can not call work while worker is running or shutting down");
        }
        this.state = State.RUNNING;
        while (this.isRunning()) {
            for (GearmanJobServerSession sess : this.sessionMap.values()) {
                int interestOps = 1;
                if (sess.sessionHasDataToWrite()) {
                    interestOps |= 4;
                }
                sess.getSelectionKey().interestOps(interestOps);
            }
            try {
                this.ioAvailable.select(1L);
            }
            catch (IOException io) {
                LOG.log(Level.WARNING, "Receieved IOException while selecting for IO", io);
            }
            for (SelectionKey key : this.ioAvailable.selectedKeys()) {
                GearmanJobServerSession sess = this.sessionMap.get(key);
                if (sess == null) {
                    LOG.log(Level.WARNING, "Worker does not have session for key " + key);
                    continue;
                }
                if (!sess.isInitialized()) continue;
                try {
                    GearmanTask sessTask = this.taskMap.get(sess);
                    if (sessTask == null) {
                        sessTask = new GearmanTask(new GrabJobEventHandler(sess), new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.GRAB_JOB, new byte[0]));
                        this.taskMap.put(sess, sessTask);
                        sess.submitTask(sessTask);
                        LOG.log(Level.FINER, "Worker: " + this + " submitted a " + (Object)((Object)sessTask.getRequestPacket().getPacketType()) + " to session: " + sess);
                    }
                    sess.driveSessionIO();
                    if (this.functionList.isEmpty()) continue;
                    GearmanFunction fun = this.functionList.remove();
                    this.submitFunction(fun);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Received IOException while driving IO on session " + sess, ioe);
                    sess.closeSession();
                }
            }
        }
        this.shutDownWorker(true);
    }

    @Override
    public void handleSessionEvent(GearmanSessionEvent event) throws IllegalArgumentException, IllegalStateException {
        GearmanPacket p = event.getPacket();
        GearmanJobServerSession s = event.getSession();
        GearmanPacketType t = p.getPacketType();
        LOG.log(Level.FINER, "Worker " + this + " handling session event" + " ( Session = " + s + " Event = " + (Object)((Object)t) + " )");
        switch (t) {
            case JOB_ASSIGN: {
                this.taskMap.remove(s);
                this.addNewJob(event);
                break;
            }
            case JOB_ASSIGN_UNIQ: {
                this.taskMap.remove(s);
                this.addNewJob(event);
                break;
            }
            case NOOP: {
                this.taskMap.remove(s);
                break;
            }
            case NO_JOB: {
                GearmanTask preSleepTask = new GearmanTask(new GrabJobEventHandler(s), new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.PRE_SLEEP, new byte[0]));
                this.taskMap.put(s, preSleepTask);
                s.submitTask(preSleepTask);
                break;
            }
            case ECHO_RES: {
                break;
            }
            case OPTION_RES: {
                break;
            }
            case ERROR: {
                s.closeSession();
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Received unknown packet type " + (Object)((Object)t) + " from session " + s + ". Closing connection.");
                s.closeSession();
            }
        }
    }

    @Override
    public boolean addServer(GearmanJobServerConnection conn) throws IllegalArgumentException, IllegalStateException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection can not be null");
        }
        for (GearmanJobServerSession sess : this.sessionMap.values()) {
            if (!sess.getConnection().equals(conn)) continue;
            return true;
        }
        GearmanJobServerSession session = new GearmanJobServerSession(conn);
        if (this.ioAvailable == null) {
            try {
                this.ioAvailable = Selector.open();
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Failed to connect to job server " + conn + ".", ioe);
                return false;
            }
        }
        try {
            session.initSession(this.ioAvailable, this);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Failed to initialize session with job server " + conn + ".", ioe);
            return false;
        }
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            String msg = "Session " + session + " has a null " + "selection key. Server will not be added to worker.";
            LOG.log(Level.WARNING, msg);
            throw new IllegalStateException(msg);
        }
        this.sessionMap.put(key, session);
        GearmanPacket p = new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.SET_CLIENT_ID, ByteUtils.toUTF8Bytes(this.id));
        session.submitTask(new GearmanTask(p));
        for (FunctionDefinition def : this.functionMap.values()) {
            p = this.generateCanDoPacket(def);
            session.submitTask(new GearmanTask(p));
        }
        p = new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.GRAB_JOB, new byte[0]);
        GearmanTask gsr = new GearmanTask(new GrabJobEventHandler(session), p);
        this.taskMap.put(session, gsr);
        session.submitTask(gsr);
        LOG.log(Level.FINE, "Added server " + conn + " to worker " + this);
        return true;
    }

    @Override
    public boolean hasServer(GearmanJobServerConnection conn) {
        boolean foundIt = false;
        for (GearmanJobServerSession sess : this.sessionMap.values()) {
            if (!sess.getConnection().equals(conn)) continue;
            foundIt = true;
        }
        return foundIt;
    }

    @Override
    public String echo(String text, GearmanJobServerConnection conn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerFunction(String function, long timeout) {
        this.registerFunctionFactory(new DefaultGearmanFunctionFactory(function), timeout);
    }

    public void registerFunction(String function) {
        this.registerFunction(function, 0L);
    }

    @Override
    public void registerFunction(Class<? extends GearmanFunction> function) {
        this.registerFunction(function, 0L);
    }

    @Override
    public void registerFunction(Class<? extends GearmanFunction> function, long timeout) {
        this.registerFunctionFactory(new DefaultGearmanFunctionFactory(function.getName()), timeout);
    }

    @Override
    public void registerFunctionFactory(GearmanFunctionFactory factory) {
        this.registerFunctionFactory(factory, 0L);
    }

    @Override
    public void registerFunctionFactory(GearmanFunctionFactory factory, long timeout) {
        if (this.functionMap.containsKey(factory.getFunctionName())) {
            return;
        }
        FunctionDefinition def = new FunctionDefinition(timeout, factory);
        this.functionMap.put(factory.getFunctionName(), def);
        this.sendToAll(this.generateCanDoPacket(def));
        LOG.log(Level.FINE, "Worker " + this + " has registered function " + factory.getFunctionName());
    }

    @Override
    public Set<String> getRegisteredFunctions() {
        HashSet<String> functions = new HashSet<String>();
        for (FunctionDefinition def : this.functionMap.values()) {
            functions.add(def.factory.getFunctionName());
        }
        return functions;
    }

    @Override
    public void setWorkerID(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Worker ID may not be null");
        }
        this.id = id;
        this.sendToAll(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.SET_CLIENT_ID, ByteUtils.toUTF8Bytes(id)));
    }

    @Override
    public void setWorkerID(String id, GearmanJobServerConnection conn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getWorkerID() {
        return this.id;
    }

    @Override
    public String getWorkerID(GearmanJobServerConnection conn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unregisterFunction(String functionName) {
        this.functionMap.remove(functionName);
        this.sendToAll(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.CANT_DO, ByteUtils.toUTF8Bytes(functionName)));
        LOG.log(Level.FINE, "Worker " + this + " has unregistered function " + functionName);
    }

    @Override
    public void unregisterAll() {
        this.functionMap.clear();
        this.sendToAll(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.RESET_ABILITIES, new byte[0]));
    }

    @Override
    public void stop() {
        this.state = State.SHUTTINGDOWN;
    }

    @Override
    public List<Exception> shutdown() {
        return this.shutDownWorker(false);
    }

    @Override
    public boolean isRunning() {
        return this.state.equals((Object)State.RUNNING);
    }

    private GearmanPacket generateCanDoPacket(FunctionDefinition def) {
        GearmanPacketType pt = GearmanPacketType.CAN_DO;
        byte[] data = null;
        byte[] name = ByteUtils.toUTF8Bytes(def.getFactory().getFunctionName());
        long timeout = def.getTimeout();
        if (timeout > 0L) {
            pt = GearmanPacketType.CAN_DO_TIMEOUT;
            byte[] to = ByteUtils.toUTF8Bytes(String.valueOf(timeout));
            data = new byte[name.length + to.length + 1];
            System.arraycopy(name, 0, data, 0, name.length);
            data[name.length] = 0;
            System.arraycopy(to, 0, data, name.length + 1, to.length);
        } else {
            data = name;
        }
        return new GearmanPacketImpl(GearmanPacketMagic.REQ, pt, data);
    }

    private void sendToAll(GearmanPacket p) {
        this.sendToAll(null, p);
    }

    private void sendToAll(GearmanServerResponseHandler handler, GearmanPacket p) {
        GearmanTask gsr = null;
        gsr = handler == null ? new GearmanTask(p) : new GearmanTask(handler, p);
        for (GearmanJobServerSession sess : this.sessionMap.values()) {
            sess.submitTask(gsr);
        }
    }

    private List<Exception> shutDownWorker(boolean completeTasks) {
        LOG.log(Level.INFO, "Commencing shutdowm of worker " + this);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.executorService != null) {
            if (completeTasks) {
                this.executorService.shutdown();
            } else {
                this.executorService.shutdownNow();
            }
        }
        for (GearmanJobServerSession sess : this.sessionMap.values()) {
            sess.closeSession();
        }
        try {
            this.ioAvailable.close();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Encountered IOException while closing selector for worker: ", ioe);
        }
        this.state = State.IDLE;
        LOG.log(Level.INFO, "Completed shutdowm of worker " + this);
        return exceptions;
    }

    private void addNewJob(GearmanSessionEvent event) {
        GearmanPacket p = event.getPacket();
        GearmanJobServerSession sess = event.getSession();
        byte[] handle = p.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE);
        byte[] functionNameBytes = p.getDataComponentValue(GearmanPacket.DataComponentName.FUNCTION_NAME);
        byte[] data = p.getDataComponentValue(GearmanPacket.DataComponentName.DATA);
        String functionName = ByteUtils.fromUTF8Bytes(functionNameBytes);
        FunctionDefinition def = this.functionMap.get(functionName);
        if (def == null) {
            GearmanTask gsr = new GearmanTask(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_FAIL, handle));
            sess.submitTask(gsr);
        } else {
            GearmanFunction function = def.getFactory().getFunction();
            function.setData(data);
            function.setJobHandle(handle);
            function.registerEventListener(sess);
            this.functionList.add(function);
        }
    }

    private void submitFunction(GearmanFunction fun) {
        try {
            if (this.executorService == null) {
                fun.call();
            } else {
                Future<GearmanJobResult> gp = this.executorService.submit(fun);
                FunctionDefinition def = this.functionMap.get(fun.getName());
                if (def == null) {
                    LOG.log(Level.WARNING, "Unable to find function execution attributes for function " + fun.getName());
                }
                if (def != null && def.getTimeout() > 0L) {
                    LOG.log(Level.FINER, "Worker:  " + this + " awaiting" + " results of job " + gp + " with timout of " + def.getTimeout() + " milliseconds");
                    gp.get(def.getTimeout(), TimeUnit.MILLISECONDS);
                } else {
                    LOG.log(Level.FINER, "Worker:  " + this + " awaiting" + " results of job " + gp);
                    gp.get();
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while getting function results", e);
            fun.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_EXCEPTION, GearmanPacketImpl.generatePacketData(fun.getJobHandle(), e.getMessage().getBytes())));
            fun.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_FAIL, fun.getJobHandle()));
        }
    }

    static class FunctionDefinition {
        private final long timeout;
        private final GearmanFunctionFactory factory;

        FunctionDefinition(long timeout, GearmanFunctionFactory factory) {
            this.timeout = timeout;
            this.factory = factory;
        }

        long getTimeout() {
            return this.timeout;
        }

        GearmanFunctionFactory getFactory() {
            return this.factory;
        }
    }

    class GrabJobEventHandler
    implements GearmanServerResponseHandler {
        private final GearmanJobServerSession session;
        private boolean isDone = false;

        GrabJobEventHandler(GearmanJobServerSession session) {
            this.session = session;
        }

        @Override
        public void handleEvent(GearmanPacket event) throws GearmanException {
            GearmanWorkerImpl.this.handleSessionEvent(new GearmanSessionEvent(event, this.session));
            this.isDone = true;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        SHUTTINGDOWN;

    }
}

