/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.worker;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.worker.GearmanFunction;
import org.gearman.worker.GearmanFunctionFactory;

public class DefaultGearmanFunctionFactory
implements GearmanFunctionFactory {
    private final String className;
    private final String functionName;
    private static final Logger LOG = Logger.getLogger("org.gearman.worker.logger");

    public DefaultGearmanFunctionFactory(String className) {
        GearmanFunction f = DefaultGearmanFunctionFactory.createFunctionInstance(className);
        if (f == null) {
            throw new IllegalStateException("Unable to create instance of function " + className);
        }
        this.className = className;
        String fname = f.getName();
        if (fname == null) {
            fname = className;
        } else if ("".equals(fname = fname.trim())) {
            fname = className;
        }
        this.functionName = fname;
    }

    public DefaultGearmanFunctionFactory(String functionName, String className) {
        this.className = className;
        this.functionName = functionName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public GearmanFunction getFunction() {
        return DefaultGearmanFunctionFactory.createFunctionInstance(this.className);
    }

    private static GearmanFunction createFunctionInstance(String className) {
        GearmanFunction f = null;
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof GearmanFunction) {
                f = (GearmanFunction)o;
            } else {
                LOG.log(Level.WARNING, "Specified class " + className + " is not a Gearman Function ");
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to create instance of Function: " + className, e);
        }
        return f;
    }
}

