/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import org.gearman.util.ByteUtils;

public enum GearmanPacketMagic {
    REQ("REQ"),
    RES("RES");

    private byte[] name;

    private GearmanPacketMagic(String kind) {
        this.name = new byte[1 + kind.length()];
        this.name[0] = 0;
        byte[] bytes = ByteUtils.toUTF8Bytes(kind);
        System.arraycopy(bytes, 0, this.name, 1, kind.length());
    }

    public byte[] toBytes() {
        byte[] retBytes = new byte[this.name.length];
        System.arraycopy(this.name, 0, retBytes, 0, this.name.length);
        return retBytes;
    }

    public static GearmanPacketMagic fromBytes(byte[] bytes) {
        if (bytes != null && bytes.length == 4) {
            int magic = ByteUtils.fromBigEndian(bytes);
            if (magic == ByteUtils.fromBigEndian(REQ.toBytes())) {
                return REQ;
            }
            if (magic == ByteUtils.fromBigEndian(RES.toBytes())) {
                return RES;
            }
        }
        throw new BadMagicException(ByteUtils.toHex(bytes));
    }

    public static class BadMagicException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private BadMagicException(String hex) {
            super(hex);
        }
    }
}

