/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketHeader;
import org.gearman.common.GearmanPacketImpl;

public class GearmanNIOJobServerConnection
implements GearmanJobServerConnection {
    static final String DESCRIPTION_PREFIX = "GearmanNIOJobServerConnection";
    private final String DESCRIPTION;
    private InetSocketAddress remote;
    private SocketChannel serverConnection = null;
    private Selector selector = null;
    private SelectionKey selectorKey = null;
    private static final Logger LOG = Logger.getLogger("org.gearman.client.logger");
    private ByteBuffer bytesReceived;
    private ByteBuffer bytesToSend;

    public GearmanNIOJobServerConnection(String hostname) throws IllegalArgumentException {
        this(hostname, 4730);
    }

    public GearmanNIOJobServerConnection(String hostname, int port) throws IllegalArgumentException {
        this(new InetSocketAddress(hostname, port));
    }

    public GearmanNIOJobServerConnection(InetSocketAddress remote) throws IllegalArgumentException {
        if (remote == null) {
            throw new IllegalArgumentException("Remote can not be null");
        }
        this.remote = remote;
        this.bytesReceived = ByteBuffer.allocate(32768);
        this.bytesToSend = ByteBuffer.allocate(32768);
        this.DESCRIPTION = "GearmanNIOJobServerConnection:" + remote.toString();
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    @Override
    public void open() throws IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("A session can not be initialized twice");
        }
        try {
            this.serverConnection = SocketChannel.open(this.remote);
            this.serverConnection.socket().setTcpNoDelay(true);
            this.serverConnection.socket().setSoLinger(true, 10);
            this.serverConnection.socket().setSoTimeout(10000);
            this.serverConnection.socket().setReceiveBufferSize(32768);
            this.serverConnection.socket().setSendBufferSize(32768);
            this.serverConnection.configureBlocking(false);
            this.serverConnection.finishConnect();
            this.selector = Selector.open();
            this.selectorKey = this.serverConnection.register(this.selector, 5);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Received IOException while attempting to initialize session " + this + ". Shuting down session", ioe);
            if (this.serverConnection != null && this.serverConnection.isOpen()) {
                if (this.selector != null && this.selector.isOpen()) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException selioe) {
                        LOG.log(Level.WARNING, "Received IOException while attempting to close selector.", selioe);
                    }
                }
                try {
                    this.serverConnection.close();
                }
                catch (IOException closeioe) {
                    LOG.log(Level.WARNING, "Received IOException while attempting to close connection to server. Giving up!", closeioe);
                }
            }
            throw ioe;
        }
        LOG.log(Level.FINE, "Connection " + this + " has been opened");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Can not close a session that has not been initialized");
        }
        LOG.log(Level.FINE, "Session " + this + " is being closed.");
        this.selectorKey.cancel();
        try {
            this.selector.close();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Received IOException while attempting to close selector attached to session " + this, ioe);
        }
        finally {
            try {
                this.serverConnection.close();
            }
            catch (IOException cioe) {
                LOG.log(Level.WARNING, "Received IOException while attempting to close connection for session " + this, cioe);
            }
            this.serverConnection = null;
        }
        LOG.log(Level.FINE, "Connection " + this + " has successfully closed.");
    }

    @Override
    public void write(GearmanPacket request) throws IOException {
        if (request == null && this.bytesToSend.position() == 0) {
            return;
        }
        if (request != null) {
            int ps = request.getData().length + 12;
            if (this.bytesToSend.remaining() < ps) {
                int newCapacity;
                for (newCapacity = this.bytesToSend.capacity() * 2; newCapacity < ps && newCapacity > 0; newCapacity *= 2) {
                }
                this.bytesToSend = this.growBuffer(this.bytesToSend, newCapacity);
            }
            byte[] bytes = request.toBytes();
            ByteBuffer bb = ByteBuffer.allocate(bytes.length);
            bb.put(bytes);
            bb.rewind();
            this.bytesToSend.put(bb);
        }
        this.selector.selectNow();
        if (this.selectorKey.isWritable()) {
            int newLimit;
            int oldLimit = newLimit = this.bytesToSend.position();
            if (newLimit > 32768) {
                newLimit = 32768;
            }
            this.bytesToSend.limit(newLimit);
            this.bytesToSend.rewind();
            int bytesSent = this.serverConnection.write(this.bytesToSend);
            this.bytesToSend.limit(oldLimit);
            this.bytesToSend.compact();
            LOG.log(Level.FINER, "Write command wrote " + bytesSent + " to " + this + ". " + this.bytesToSend.position() + " bytes left in " + "send buffer");
        } else {
            LOG.log(Level.FINER, "Write command can not write request: Selector for " + this + " is not available for write. " + "Will buffer request and send it later.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GearmanPacket read() throws IOException {
        GearmanPacketImpl returnPacket = null;
        this.selector.selectNow();
        if (this.selectorKey.isReadable()) {
            int bytesRead;
            if (!this.bytesReceived.hasRemaining()) {
                this.bytesReceived = this.growBuffer(this.bytesReceived);
            }
            if ((bytesRead = this.serverConnection.read(this.bytesReceived)) < 0) throw new IOException("Connection to job server severed");
            LOG.log(Level.FINER, "Session " + this + " has read " + bytesRead + " bytes from its job server. Buffer has " + this.bytesReceived.remaining());
        } else {
            LOG.log(Level.FINER, "Read command can not read request fromsession: Selector for " + this + " is not available " + "for read. ");
        }
        if (!this.bufferContainsCompletePacket(this.bytesReceived)) return returnPacket;
        byte[] pb = new byte[this.getSizeOfPacket(this.bytesReceived)];
        this.bytesReceived.limit(this.bytesReceived.position());
        this.bytesReceived.rewind();
        this.bytesReceived.get(pb);
        this.bytesReceived.compact();
        return new GearmanPacketImpl(new BufferedInputStream(new ByteArrayInputStream(pb)));
    }

    public SelectionKey registerSelector(Selector s, int mask) throws IOException {
        return this.serverConnection.register(s, mask);
    }

    @Override
    public boolean canRead() {
        if (!this.selector.isOpen()) {
            return false;
        }
        try {
            this.selector.selectNow();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Failed to select on connection " + this, ioe);
        }
        return this.selectorKey.isReadable() || this.bufferContainsCompletePacket(this.bytesReceived);
    }

    @Override
    public boolean canWrite() {
        if (!this.selector.isOpen()) {
            return false;
        }
        try {
            this.selector.selectNow();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Connection Failed to select on socket " + this, ioe);
        }
        return this.selectorKey.isWritable();
    }

    public boolean hasBufferedWriteData() {
        return this.bytesToSend.position() > 0;
    }

    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public boolean isOpen() {
        return this.serverConnection != null && this.serverConnection.isConnected();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof GearmanNIOJobServerConnection)) {
            return false;
        }
        InetSocketAddress thatRemote = ((GearmanNIOJobServerConnection)that).remote;
        return this.remote.equals(thatRemote);
    }

    public int hashCode() {
        return this.remote == null ? 0 : this.remote.hashCode();
    }

    private boolean bufferContainsCompletePacket(ByteBuffer b) {
        if (b.position() < 12) {
            return false;
        }
        return b.position() >= this.getSizeOfPacket(b);
    }

    private int getSizeOfPacket(ByteBuffer buffer) {
        int originalPosition = buffer.position();
        byte[] header = new byte[12];
        buffer.rewind();
        buffer.get(header);
        buffer.position(originalPosition);
        GearmanPacketHeader ph = new GearmanPacketHeader(header);
        return ph.getDataLength() + 12;
    }

    private ByteBuffer growBuffer(ByteBuffer originalBuffer) throws IllegalArgumentException {
        return this.growBuffer(originalBuffer, originalBuffer.capacity() * 2);
    }

    private ByteBuffer growBuffer(ByteBuffer orginalBuffer, int newCapacity) throws IllegalArgumentException {
        if (newCapacity < orginalBuffer.capacity()) {
            throw new IllegalArgumentException("The new capacity of the buffer (" + newCapacity + ") may not be less than the" + " orginal capacity (" + orginalBuffer.capacity() + ")");
        }
        orginalBuffer.flip();
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        newBuffer.put(orginalBuffer);
        return newBuffer;
    }
}

