/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketImpl;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanSessionEvent;
import org.gearman.common.GearmanSessionEventHandler;
import org.gearman.common.GearmanTask;

public class GearmanJobServerSession
implements GearmanSessionEventHandler,
GearmanIOEventListener {
    static final String DESCRIPTION_PREFIX = "GearmanJobServerSession";
    private final String DESCRIPTION;
    private final GearmanNIOJobServerConnection connection;
    private Queue<GearmanPacket> packetsToWrite = null;
    private static final Logger LOG = Logger.getLogger("org.gearman.session.logger");
    private SelectionKey sessionSelectionKey = null;
    private GearmanSessionEventHandler responseHandler = null;
    private Queue<GearmanTask> newTaskList = null;
    private Queue<GearmanTask> tasksAwaitingAckList = null;

    public GearmanJobServerSession(GearmanJobServerConnection conn) throws IllegalArgumentException {
        if (!(conn instanceof GearmanNIOJobServerConnection)) {
            throw new IllegalArgumentException("Session currently only supports instances of " + GearmanNIOJobServerConnection.class.getName());
        }
        this.connection = (GearmanNIOJobServerConnection)conn;
        this.DESCRIPTION = "GearmanJobServerSession:" + Thread.currentThread().getId() + ":" + conn.toString();
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public void initSession(Selector sel, GearmanSessionEventHandler handler) throws IllegalStateException, IOException {
        if (this.isInitialized()) {
            throw new IllegalStateException("A session can not be initialized twice");
        }
        this.connection.open();
        this.packetsToWrite = new LinkedList<GearmanPacket>();
        this.sessionSelectionKey = this.connection.registerSelector(sel, 1);
        this.responseHandler = handler;
        this.newTaskList = new LinkedList<GearmanTask>();
        this.tasksAwaitingAckList = new LinkedList<GearmanTask>();
        LOG.log(Level.FINE, "Session " + this + " has been initialized.");
    }

    public GearmanJobServerConnection getConnection() {
        return this.connection;
    }

    public SelectionKey getSelectionKey() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Session " + this + " has not been initialized");
        }
        return this.sessionSelectionKey;
    }

    public boolean isInitialized() {
        return this.connection != null && this.connection.isOpen();
    }

    public void waitForTasksToComplete() throws IllegalStateException, InterruptedException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Session " + this + " has not been initialized");
        }
        try {
            this.waitForTasksToComplete(-1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ignore) {
            LOG.log(Level.WARNING, "Unexpected timeout exception received while waiting for current session task to complete. Timeout value was set to -1, which means do not timeout, yet it did. Go figure.", ignore);
        }
    }

    public void waitForTasksToComplete(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, IllegalStateException {
        long timeOutInMills;
        if (!this.isInitialized()) {
            throw new IllegalStateException("Session " + this + " has not been initialized");
        }
        long l = timeOutInMills = timeout < 0L ? -1L : TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        while (!(this.newTaskList.size() <= 0 && this.tasksAwaitingAckList.size() <= 0 || timeOutInMills >= 0L && System.currentTimeMillis() > timeOutInMills)) {
            try {
                this.driveSessionIO();
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Receieved an IO Exception while driving io for session " + this, ioe);
            }
            Thread.sleep(100L);
        }
        if (this.newTaskList.size() > 0 || this.tasksAwaitingAckList.size() > 0) {
            throw new TimeoutException("Session " + this + " timed out " + "waiting for all requests to complete");
        }
    }

    public void closeSession() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Can not close a session that has not been initialized");
        }
        LOG.log(Level.FINE, "Session " + this + " is being closed.");
        this.sessionSelectionKey.cancel();
        this.connection.close();
        this.packetsToWrite.clear();
        this.packetsToWrite = null;
        this.tasksAwaitingAckList.clear();
        this.newTaskList.clear();
        LOG.log(Level.FINE, "Session " + this + " has successfully closed.");
    }

    public void submitTask(GearmanTask task) throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Session hasnt been initialized. Request may not be submitted at this time");
        }
        if (task == null) {
            throw new IllegalStateException("A null request can not be submitted to a server");
        }
        if (!task.getState().equals((Object)GearmanTask.State.NEW)) {
            throw new IllegalStateException("Invalid task state: " + (Object)((Object)task.getState()));
        }
        this.newTaskList.add(task);
        this.packetsToWrite.add(task.getRequestPacket());
        this.sessionSelectionKey.interestOps(this.sessionSelectionKey.interestOps() | 4);
        LOG.log(Level.FINER, "Session " + this + " is now handling " + "the task " + task);
    }

    @Override
    public void handleGearmanIOEvent(GearmanPacket event) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException("Can not handle a null event");
        }
        if (event.getMagic().equals((Object)GearmanPacketMagic.RES)) {
            throw new IllegalArgumentException("Can not handle a Result event");
        }
        GearmanTask t = new GearmanTask(event);
        this.submitTask(t);
    }

    public void driveSessionIO() throws IOException, GearmanException, IllegalStateException {
        GearmanPacket p = null;
        if (!this.isInitialized()) {
            throw new IllegalStateException("you can not driveSessionIO on an un-initialized session");
        }
        while (this.sessionHasDataToWrite() && this.canWrite()) {
            if (this.packetsToWrite.isEmpty()) {
                this.connection.write(null);
                continue;
            }
            p = this.packetsToWrite.remove();
            this.connection.write(p);
            this.handleSessionEvent(new GearmanSessionEvent(p, this));
        }
        if (!this.sessionHasDataToWrite()) {
            this.sessionSelectionKey.interestOps(1);
        }
        while (this.canRead()) {
            p = this.connection.read();
            if (p == null) continue;
            this.handleSessionEvent(new GearmanSessionEvent(p, this));
        }
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!(that instanceof GearmanJobServerSession)) {
            return false;
        }
        GearmanJobServerSession thatSession = (GearmanJobServerSession)that;
        return this.connection.equals(thatSession.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    @Override
    public void handleSessionEvent(GearmanSessionEvent event) throws IllegalArgumentException, IllegalStateException {
        if (event == null) {
            throw new IllegalArgumentException("Event can not be null");
        }
        GearmanPacket p = event.getPacket();
        if (p == null) {
            throw new IllegalArgumentException("Event does not have a packet");
        }
        GearmanPacketMagic m = p.getMagic();
        if (m.equals((Object)GearmanPacketMagic.REQ)) {
            this.handleReqSessionEvent(event);
        } else if (m.equals((Object)GearmanPacketMagic.RES)) {
            this.handleResSessionEvent(event);
        } else {
            throw new IllegalStateException("Event has bad magic type " + (Object)((Object)m));
        }
    }

    public int getNumberOfActiveTasks() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Session hasnt been initialized.");
        }
        return this.tasksAwaitingAckList.size() + this.newTaskList.size();
    }

    public boolean sessionHasDataToWrite() {
        if (this.connection == null) {
            return false;
        }
        return this.packetsToWrite.isEmpty() ? this.connection.hasBufferedWriteData() : true;
    }

    private void handleReqSessionEvent(GearmanSessionEvent event) throws IllegalStateException {
        GearmanPacket p = event.getPacket();
        GearmanTask t = this.newTaskList.remove();
        if (t == null) {
            String msg = "Session has received  request event " + event.packet + " but has no task in new task queue.";
            LOG.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
        t.handleGearmanIOEvent(p);
        GearmanTask.State state2 = t.getState();
        LOG.log(Level.FINER, "Session " + this + " handling a " + (Object)((Object)GearmanPacketMagic.REQ) + "/" + (Object)((Object)p.getPacketType()) + " event");
        switch (state2) {
            case SUBMITTED: {
                this.tasksAwaitingAckList.add(t);
                LOG.log(Level.FINE, "Added task " + (Object)((Object)t.getRequestPacket().getPacketType()) + " to taskAwaiting list. List size = " + this.tasksAwaitingAckList.size() + "( Event was " + (Object)((Object)p.getPacketType()) + ")");
                break;
            }
            case FINISHED: {
                break;
            }
            default: {
                String code = "000";
                String msg = "Task in invalid state (State = " + (Object)((Object)state2) + ") after submission to server";
                LOG.log(Level.WARNING, msg);
                this.responseHandler.handleSessionEvent(new GearmanSessionEvent(new GearmanPacketImpl(GearmanPacketMagic.RES, GearmanPacketType.ERROR, GearmanPacketImpl.generatePacketData(code.getBytes(), msg.getBytes())), this));
            }
        }
    }

    private void handleResSessionEvent(GearmanSessionEvent event) {
        GearmanPacket p = event.getPacket();
        GearmanPacketType t = p.getPacketType();
        GearmanTask task = this.tasksAwaitingAckList.peek();
        GearmanPacketType taskType = null;
        LOG.log(Level.FINER, "Session " + this + " handling a " + (Object)((Object)GearmanPacketMagic.RES) + "/" + (Object)((Object)p.getPacketType()) + " event");
        switch (t) {
            case JOB_CREATED: {
                taskType = task.getRequestPacket().getPacketType();
                if (GearmanPacketType.isJobSubmission(taskType)) {
                    task.handleGearmanIOEvent(p);
                    this.responseHandler.handleSessionEvent(event);
                    break;
                }
                this.handleTypeMismatch("Job Submission", taskType.toString());
                break;
            }
            case NO_JOB: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.GRAB_JOB) || taskType.equals((Object)GearmanPacketType.GRAB_JOB_UNIQ)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch((Object)((Object)GearmanPacketType.GRAB_JOB) + " or " + (Object)((Object)GearmanPacketType.GRAB_JOB_UNIQ), taskType.toString());
                break;
            }
            case NOOP: {
                if (task == null) break;
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.PRE_SLEEP)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                return;
            }
            case JOB_ASSIGN: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.GRAB_JOB)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch(GearmanPacketType.GRAB_JOB.toString(), taskType.toString());
                break;
            }
            case JOB_ASSIGN_UNIQ: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.GRAB_JOB_UNIQ)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch(GearmanPacketType.GRAB_JOB_UNIQ.toString(), taskType.toString());
                break;
            }
            case STATUS_RES: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.GET_STATUS)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch(GearmanPacketType.GET_STATUS.toString(), taskType.toString());
                break;
            }
            case ECHO_RES: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.ECHO_REQ)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch(GearmanPacketType.ECHO_REQ.toString(), taskType.toString());
                break;
            }
            case OPTION_RES: {
                taskType = task.getRequestPacket().getPacketType();
                if (taskType.equals((Object)GearmanPacketType.OPTION_REQ)) {
                    task.handleGearmanIOEvent(p);
                    break;
                }
                this.handleTypeMismatch(GearmanPacketType.OPTION_REQ.toString(), taskType.toString());
                break;
            }
            default: {
                this.responseHandler.handleSessionEvent(event);
                return;
            }
        }
        if (task != null) {
            if (task.getState().compareTo(GearmanTask.State.SUBMITTED) > 0) {
                this.tasksAwaitingAckList.remove();
                LOG.log(Level.FINE, "Removed task " + (Object)((Object)task.getRequestPacket().getPacketType()) + " from taskAwaiting list. List size = " + this.tasksAwaitingAckList.size() + "( Event was " + (Object)((Object)event.packet.getPacketType()) + ")");
            } else {
                LOG.log(Level.WARNING, "Task " + task + " still in submitted " + "state after receiving acknowlegement from server. " + "Ack = " + p);
            }
        }
    }

    private void handleTypeMismatch(String expected, String got) {
        String code = "000";
        String msg = "Received " + got + " response from server," + " but last request was not " + expected;
        LOG.log(Level.WARNING, msg);
        this.responseHandler.handleSessionEvent(new GearmanSessionEvent(new GearmanPacketImpl(GearmanPacketMagic.RES, GearmanPacketType.ERROR, GearmanPacketImpl.generatePacketData(code.getBytes(), msg.getBytes())), this));
    }

    private boolean canWrite() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.canWrite();
    }

    private boolean canRead() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.canRead();
    }
}

