/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import java.util.Arrays;
import org.gearman.client.GearmanJobResult;

public class GearmanJobResultImpl
implements GearmanJobResult {
    private long denominator;
    private long numerator;
    private byte[] results;
    private byte[] warnings;
    private byte[] exceptions;
    private byte[] handle;
    boolean succeeded = false;

    private GearmanJobResultImpl() {
    }

    public GearmanJobResultImpl(byte[] handle) {
        this(handle, false, null, null, null, -1L, -1L);
    }

    public GearmanJobResultImpl(byte[] handle, boolean succeeded, byte[] results, byte[] warnings, byte[] exceptions, long numerator, long denominator) {
        this.handle = this.copyArray(handle);
        this.succeeded = succeeded;
        this.numerator = numerator;
        this.denominator = denominator;
        this.results = this.copyArray(results);
        this.warnings = this.copyArray(warnings);
        this.exceptions = this.copyArray(exceptions);
    }

    public GearmanJobResultImpl addJobResult(GearmanJobResultImpl that) {
        if (!Arrays.equals(this.handle, that.handle)) {
            throw new IllegalArgumentException("Only results for the same job can be merged");
        }
        byte[] mergedResults = new byte[this.results.length + that.results.length];
        System.arraycopy(this.results, 0, mergedResults, 0, this.results.length);
        System.arraycopy(that.results, 0, mergedResults, this.results.length, that.results.length);
        byte[] mergedWarnings = new byte[this.warnings.length + that.warnings.length];
        System.arraycopy(this.warnings, 0, mergedWarnings, 0, this.warnings.length);
        System.arraycopy(that.warnings, 0, mergedWarnings, this.warnings.length, that.warnings.length);
        byte[] mergedExceptions = new byte[this.exceptions.length + that.exceptions.length];
        System.arraycopy(this.exceptions, 0, mergedExceptions, 0, this.exceptions.length);
        System.arraycopy(that.exceptions, 0, mergedExceptions, this.exceptions.length, that.exceptions.length);
        long newNum = that.numerator == -1L ? this.numerator : that.numerator;
        long newDen = that.denominator == -1L ? this.denominator : that.denominator;
        return new GearmanJobResultImpl(this.handle, that.succeeded, mergedResults, mergedWarnings, mergedExceptions, newNum, newDen);
    }

    @Override
    public byte[] getResults() {
        return this.copyArray(this.results);
    }

    @Override
    public byte[] getWarnings() {
        return this.copyArray(this.warnings);
    }

    @Override
    public byte[] getExceptions() {
        return this.copyArray(this.exceptions);
    }

    @Override
    public long getDenominator() {
        return this.denominator;
    }

    @Override
    public long getNumerator() {
        return this.numerator;
    }

    @Override
    public byte[] getJobHandle() {
        return this.copyArray(this.handle);
    }

    @Override
    public boolean jobSucceeded() {
        return this.succeeded;
    }

    public GearmanJobResult copy() {
        GearmanJobResultImpl res = new GearmanJobResultImpl(this.handle, this.succeeded, this.copyArray(this.results), this.copyArray(this.warnings), this.copyArray(this.exceptions), this.numerator, this.denominator);
        return res;
    }

    GearmanJobResultImpl addResults(byte[] newResults) {
        byte[] mergedResults = new byte[this.results.length + newResults.length];
        System.arraycopy(this.results, 0, mergedResults, 0, this.results.length);
        System.arraycopy(newResults, 0, mergedResults, this.results.length, newResults.length);
        return new GearmanJobResultImpl(this.handle, this.succeeded, mergedResults, this.warnings, this.exceptions, this.numerator, this.denominator);
    }

    GearmanJobResultImpl addWarnings(byte[] newWarnings) {
        byte[] mergedWarnings = new byte[this.warnings.length + newWarnings.length];
        System.arraycopy(this.warnings, 0, mergedWarnings, 0, this.warnings.length);
        System.arraycopy(newWarnings, 0, mergedWarnings, this.warnings.length, newWarnings.length);
        return new GearmanJobResultImpl(this.handle, this.succeeded, this.results, mergedWarnings, this.exceptions, this.numerator, this.denominator);
    }

    GearmanJobResultImpl addExceptions(byte[] newExceptions) {
        byte[] mergedExceptions = new byte[this.exceptions.length + newExceptions.length];
        System.arraycopy(this.exceptions, 0, mergedExceptions, 0, this.exceptions.length);
        System.arraycopy(newExceptions, 0, mergedExceptions, this.exceptions.length, newExceptions.length);
        return new GearmanJobResultImpl(this.handle, this.succeeded, this.results, this.warnings, mergedExceptions, this.numerator, this.denominator);
    }

    private byte[] copyArray(byte[] src) {
        if (src == null) {
            return new byte[0];
        }
        byte[] copy = new byte[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }
}

