/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.client.GearmanJob;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanJobServerSession;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;
import org.gearman.util.ByteUtils;
import org.gearman.worker.GearmanFunction;

public final class GearmanJobImpl
implements GearmanJob,
GearmanServerResponseHandler {
    static final String DESCRIPTION_PREFIX = "GearmanJob";
    private final String DESCRIPTION;
    private final String functionName;
    private final boolean backgroundJob;
    private final GearmanJob.JobPriority priority;
    private final Collection<GearmanIOEventListener> eventListners;
    private byte[] handle = null;
    private byte[] data = new byte[0];
    private String uuid = null;
    private GearmanJobResultImpl jobResult = null;
    private GearmanJobServerSession session = null;
    private static final Logger LOG = Logger.getLogger("org.gearman.session.logger");
    private boolean isComplete = false;

    private GearmanJobImpl(String functionName, byte[] data, boolean isBackground, GearmanJob.JobPriority priority, String uuid) throws IllegalArgumentException {
        if (functionName == null || functionName.trim().equals("")) {
            throw new IllegalArgumentException("Function name can not be null or empty");
        }
        if (data != null) {
            this.data = new byte[data.length];
            System.arraycopy(data, 0, this.data, 0, this.data.length);
        }
        this.functionName = functionName;
        this.backgroundJob = isBackground;
        this.priority = priority;
        this.eventListners = new HashSet<GearmanIOEventListener>();
        this.uuid = uuid == null ? UUID.randomUUID().toString() : uuid;
        this.DESCRIPTION = "GearmanJob:" + uuid + ":" + functionName;
    }

    public static GearmanJob createJob(String functionName, byte[] data, GearmanJob.JobPriority priority, String id) throws IllegalArgumentException {
        GearmanJobImpl job = new GearmanJobImpl(functionName, data, false, priority, id);
        return job;
    }

    public static GearmanJob createJob(String functionName, byte[] data, String id) throws IllegalArgumentException {
        GearmanJobImpl job = new GearmanJobImpl(functionName, data, false, GearmanJob.JobPriority.NORMAL, id);
        return job;
    }

    public static GearmanJob createBackgroundJob(String functionName, byte[] data, GearmanJob.JobPriority priority, String id) throws IllegalArgumentException {
        GearmanJobImpl job = new GearmanJobImpl(functionName, data, true, priority, id);
        return job;
    }

    public static GearmanJob createBackgroundJob(String functionName, byte[] data, String id) throws IllegalArgumentException {
        GearmanJobImpl job = new GearmanJobImpl(functionName, data, true, GearmanJob.JobPriority.NORMAL, id);
        return job;
    }

    @Override
    public byte[] getHandle() {
        byte[] retHandle = new byte[this.handle.length];
        System.arraycopy(this.handle, 0, retHandle, 0, retHandle.length);
        return retHandle;
    }

    @Override
    public byte[] getID() {
        return this.uuid.getBytes();
    }

    @Override
    public byte[] getData() {
        byte[] rt = null;
        if (this.data == null) {
            rt = new byte[]{};
        } else {
            rt = new byte[this.data.length];
            System.arraycopy(this.data, 0, rt, 0, rt.length);
        }
        return rt;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean isBackgroundJob() {
        return this.backgroundJob;
    }

    @Override
    public GearmanJob.JobPriority getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isComplete;
    }

    public void setJobServerSession(GearmanJobServerSession sess) {
        if (sess == null) {
            throw new IllegalArgumentException("Job Server connection can not be null");
        }
        LOG.log(Level.FINE, "Connection for job " + this + " has been set to " + sess);
        this.session = sess;
    }

    @Override
    public void registerFunction(Callable<GearmanJobResult> function) {
        if (function instanceof GearmanFunction) {
            GearmanFunction gf = (GearmanFunction)function;
            gf.setData(this.data);
        }
    }

    @Override
    public void registerEventListener(GearmanIOEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.eventListners.add(listener);
    }

    @Override
    public boolean removeEventListener(GearmanIOEventListener listener) {
        return this.eventListners.remove(listener);
    }

    @Override
    public GearmanJobResult call() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public GearmanJobResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new ExecutionException(te);
        }
    }

    @Override
    public GearmanJobResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeOutInMills;
        if (this.isComplete) {
            return this.jobResult.copy();
        }
        int retries = 10;
        long l = timeOutInMills = timeout < 0L ? -1L : TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        while (!this.isComplete && !this.hasTimedOut(timeOutInMills)) {
            block5: {
                try {
                    this.session.driveSessionIO();
                }
                catch (IOException ioe) {
                    LOG.finer("Encountered exception while driving client IO , " + --retries + " retries left. [ job = " + this + " exception = " + ioe + "]");
                    if (retries != 0) break block5;
                    this.isComplete = true;
                    LOG.warning("Failed to drive client IO while getting results for job. [ job = " + this + " exception = " + ioe + "]");
                    throw new ExecutionException(ioe);
                }
            }
            Thread.sleep(100L);
        }
        if (!this.isComplete) {
            throw new TimeoutException("Failed to retrieve job result in alloted time (" + timeout + " " + unit.toString() + ").");
        }
        return this.jobResult.copy();
    }

    @Override
    public void handleEvent(GearmanPacket event) throws GearmanException {
        GearmanPacketType pt = event.getPacketType();
        switch (pt) {
            case JOB_CREATED: {
                LOG.log(Level.FINER, "job " + this + " has received a job created event");
                if (this.handle != null) {
                    throw new GearmanException("While handling job_create for job with handle" + ByteUtils.fromUTF8Bytes(this.handle) + " noticed that " + "job object already has a handle " + ByteUtils.fromUTF8Bytes(this.handle) + ". Duplicate create?");
                }
                this.handle = event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE);
                if (this.isBackgroundJob()) {
                    this.isComplete = true;
                    this.jobResult = new GearmanJobResultImpl(this.handle, true, null, null, null, -1L, -1L);
                    break;
                }
                this.jobResult = new GearmanJobResultImpl(this.handle);
                break;
            }
            case WORK_STATUS: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "status event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                long num = 0L;
                long den = 0L;
                try {
                    num = Long.parseLong(ByteUtils.fromAsciiBytes(event.getDataComponentValue(GearmanPacket.DataComponentName.NUMERATOR)));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.FINER, "numerator for job " + this + " has non-numeric value ");
                }
                try {
                    den = Long.parseLong(ByteUtils.fromAsciiBytes(event.getDataComponentValue(GearmanPacket.DataComponentName.DENOMINATOR)));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.FINER, "denominator for job " + this + " has non-numeric value ");
                }
                this.jobResult = this.jobResult.addJobResult(new GearmanJobResultImpl(this.handle, false, null, null, null, num, den));
                break;
            }
            case WORK_DATA: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "data event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                this.jobResult = this.jobResult.addResults(event.getDataComponentValue(GearmanPacket.DataComponentName.DATA));
                break;
            }
            case WORK_WARNING: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "warning event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                this.jobResult = this.jobResult.addWarnings(event.getDataComponentValue(GearmanPacket.DataComponentName.DATA));
                break;
            }
            case WORK_COMPLETE: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "complete event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                this.jobResult = this.jobResult.addJobResult(new GearmanJobResultImpl(this.handle, true, event.getDataComponentValue(GearmanPacket.DataComponentName.DATA), null, null, -1L, -1L));
                this.isComplete = true;
                break;
            }
            case WORK_FAIL: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "fail event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                this.jobResult = this.jobResult.addJobResult(new GearmanJobResultImpl(this.handle, false, null, null, null, -1L, -1L));
                this.isComplete = true;
                break;
            }
            case WORK_EXCEPTION: {
                LOG.log(Level.FINER, "job " + this + " has received a work " + "exception event");
                this.validateJobHandle(event.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                this.jobResult = this.jobResult.addExceptions(event.getDataComponentValue(GearmanPacket.DataComponentName.DATA));
                break;
            }
            default: {
                LOG.log(Level.WARNING, "job " + this + " has received an " + "unknown event: " + (Object)((Object)pt));
                throw new GearmanException("Unknown packet type " + (Object)((Object)pt));
            }
        }
        for (GearmanIOEventListener listener : this.eventListners) {
            listener.handleGearmanIOEvent(event);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Cancel operation not supported for GearmanJobs");
    }

    GearmanJobServerSession getSession() {
        return this.session;
    }

    private void validateJobHandle(byte[] rcvdHandle) throws GearmanException {
        if (!Arrays.equals(this.handle, rcvdHandle)) {
            throw new GearmanException("Job handle mis-match");
        }
    }

    private boolean hasTimedOut(long millis) {
        return millis < 0L ? false : System.currentTimeMillis() > millis;
    }
}

