/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.runners;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteBuilder
extends Runner {
    private final TestClass fTestClass;
    private final Object fInstance;
    private final List<Runner> fRunners;

    public SuiteBuilder(Class<?> testClass) throws InitializationError {
        this.fTestClass = new TestClass(testClass);
        this.fInstance = this.createInstance();
        this.fRunners = this.computeRunners();
    }

    private Object createInstance() throws InitializationError {
        try {
            return this.fTestClass.getOnlyConstructor().newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InitializationError(e);
        }
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.fTestClass.getJavaClass());
        for (Runner each : this.fRunners) {
            description.addChild(each.getDescription());
        }
        return description;
    }

    @Override
    public void run(RunNotifier notifier) {
        for (Runner each : this.fRunners) {
            each.run(notifier);
        }
    }

    private List<Runner> computeRunners() throws InitializationError {
        List<Class<?>> allPossibleClasses = this.gatherClasses();
        List<Runner> allPossibleRunners = this.runnersForClasses(allPossibleClasses);
        return this.filterRunners(allPossibleRunners);
    }

    private List<Runner> filterRunners(List<Runner> allPossibleRunners) {
        List<Runner> result = allPossibleRunners;
        for (RunnerFilter.Value each : this.getFilters()) {
            result = each.matchingRunners(result);
        }
        return result;
    }

    private List<RunnerFilter.Value> getFilters() {
        return this.fTestClass.getAnnotatedFieldValues(this.fInstance, RunnerFilter.class, RunnerFilter.Value.class);
    }

    private List<Runner> runnersForClasses(List<Class<?>> allPossibleClasses) throws InitializationError {
        return new AllDefaultPossibilitiesBuilder(true).runners(this.fTestClass.getJavaClass(), allPossibleClasses);
    }

    public List<Class<?>> gatherClasses() {
        ArrayList result = new ArrayList();
        List<Classes.Value> classeses = this.fTestClass.getAnnotatedFieldValues(this.fInstance, Classes.class, Classes.Value.class);
        for (Classes.Value each : classeses) {
            result.addAll(each.get());
        }
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Classes {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Value {
            public Collection<? extends Class<?>> get();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RunnerFilter {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Value {
            public List<Runner> matchingRunners(List<Runner> var1);
        }
    }
}

