/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Enumerated;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.x509.X509Exception;
import codec.x509.X509Extension;
import java.io.IOException;

public class ReasonCodeExtension
extends X509Extension {
    protected static final String ID_CE_CRL_REASON = new String("2.5.29.21");
    protected ASN1Enumerated theReason;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGE = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_REMOVE_FROM_CRL = 8;

    public ReasonCodeExtension() throws Exception {
        this(0);
    }

    public ReasonCodeExtension(int aReason) throws Exception {
        super.setOID(new ASN1ObjectIdentifier(ID_CE_CRL_REASON));
        this.setReasonCode(aReason);
    }

    public ReasonCodeExtension(byte[] ext) throws ASN1Exception, IOException {
        super(ext);
    }

    public void setReasonCode(int aReason) throws Exception {
        if (aReason < 0 || aReason == 7 || aReason > 8) {
            throw new X509Exception("Reasoncode unknown");
        }
        this.theReason = new ASN1Enumerated(aReason);
        super.setValue(this.theReason);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        ASN1Type inner = (ASN1Type)super.getValue();
        if (!(inner instanceof ASN1Enumerated)) {
            throw new ASN1Exception("unexpected extension value " + inner.toString());
        }
        this.theReason = (ASN1Enumerated)inner;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "ReasonCodeExtension [" + ID_CE_CRL_REASON + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        buf.append(offset + "reason: ");
        switch (((ASN1Enumerated)this.getValue()).getBigInteger().intValue()) {
            case 0: {
                buf.append("unspecified");
                break;
            }
            case 1: {
                buf.append("key compromise");
                break;
            }
            case 3: {
                buf.append("affiliation change");
                break;
            }
            case 4: {
                buf.append("superseded");
                break;
            }
            case 5: {
                buf.append("cessation of operation");
                break;
            }
            case 6: {
                buf.append("certificate hold");
                break;
            }
            case 8: {
                buf.append("remove from crl");
                break;
            }
            default: {
                buf.append("unknown reason code");
            }
        }
        buf.append("\n" + offset + "}\n");
        return buf.toString();
    }
}

