/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.Decoder;
import codec.x509.X509Extension;
import codec.x509.extensions.DistributionPoint;
import java.io.IOException;

public class CRLDistributionPointsExtension
extends X509Extension {
    public static final String ID_CE_CRL_DISTRIBUTION_POINTS = "2.5.29.31";
    private ASN1Sequence cRLDistributionPointSyntax = new ASN1SequenceOf(class$codec$x509$extensions$DistributionPoint == null ? (class$codec$x509$extensions$DistributionPoint = CRLDistributionPointsExtension.class$("codec.x509.extensions.DistributionPoint")) : class$codec$x509$extensions$DistributionPoint);
    static /* synthetic */ Class class$codec$x509$extensions$DistributionPoint;

    public CRLDistributionPointsExtension() throws Exception {
        this.setOID(new ASN1ObjectIdentifier(ID_CE_CRL_DISTRIBUTION_POINTS));
        this.setCritical(false);
        this.setValue(this.cRLDistributionPointSyntax);
    }

    public CRLDistributionPointsExtension(byte[] ext) throws ASN1Exception, IOException {
        super(ext);
    }

    public void addCRLDistributionPoint(DistributionPoint newDP) throws Exception {
        this.cRLDistributionPointSyntax.add(newDP);
        this.setValue(this.cRLDistributionPointSyntax);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.cRLDistributionPointSyntax);
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "CRLDistributionPoints [" + this.getOID() + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        buf.append(this.cRLDistributionPointSyntax.toString());
        buf.append(offset + "}\n");
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

