/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1GeneralizedTime;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1UTCTime;
import codec.asn1.Decoder;
import codec.x509.X509Extension;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;

public class ArchiveCutoffExtension
extends X509Extension {
    public static final String EXTENSION_OID = "1.3.6.1.5.5.7.48.1.6";
    private ASN1GeneralizedTime time_;

    public ArchiveCutoffExtension() throws ASN1Exception, CertificateEncodingException {
        this(new ASN1GeneralizedTime(System.currentTimeMillis()));
    }

    public ArchiveCutoffExtension(ASN1GeneralizedTime time) throws ASN1Exception, CertificateEncodingException {
        if (time == null) {
            throw new NullPointerException("time");
        }
        this.time_ = time;
        this.setCritical(false);
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.setValue(this.time_);
    }

    public ArchiveCutoffExtension(ASN1UTCTime time) throws ASN1Exception, CertificateEncodingException {
        if (time == null) {
            throw new NullPointerException("time");
        }
        this.setCritical(false);
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.setValue(this.time_);
    }

    public ASN1GeneralizedTime getTime() {
        return this.time_;
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.time_);
    }
}

