/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import homemonitor.GDErrorCode;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.VivotekCameraDiscovery;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class VivotekCameraDiscoveryTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDiscoverOneCamera() {
        String deviceId = "11:22:33:44:55:66";
        long sessionId = 1234L;
        byte[] discoverDatagram = new byte[]{1, 94, 1, 28, 1};
        byte[] responseDatagram = new byte[]{2, 94, 1, 28, 1, 2, 6, -95, -78, -61, -44, -27, -10, 3, 4, -64, -88, 1, 2, 1, 4, 84, 101, 115, 116};
        IMocksControl ctrl = EasyMock.createStrictControl();
        ctrl.checkOrder(true);
        UDPProxyInterface udpProxy = ctrl.createMock(UDPProxyInterface.class);
        LANDeviceDiscoveryNotification notification = ctrl.createMock(LANDeviceDiscoveryNotification.class);
        VivotekCameraDiscovery discovery = new VivotekCameraDiscovery(udpProxy, notification, true);
        EasyMock.expect(udpProxy.createSession(deviceId, discovery)).andReturn(sessionId);
        EasyMock.expect(udpProxy.send(EasyMock.eq(sessionId), EasyMock.eq(-1L), EasyMock.eq(10000), EasyMock.aryEq(discoverDatagram))).andReturn(GDErrorCode.NoError);
        DiscoveredLanDevice lanDevice = new DiscoveredLanDevice("A1:B2:C3:D4:E5:F6", "192.168.1.2", "Test", 80);
        lanDevice.setDeviceDriver("CameraVivotekGeneric");
        notification.foundNewLANDevice(EasyMock.cmpEq(lanDevice));
        EasyMock.expectLastCall().times(1);
        EasyMock.expect(udpProxy.send(EasyMock.eq(sessionId), EasyMock.eq(-1L), EasyMock.eq(10000), EasyMock.aryEq(discoverDatagram))).andReturn(GDErrorCode.NoError).times(2);
        EasyMock.expect(udpProxy.close(sessionId)).andReturn(GDErrorCode.NoError);
        notification.discoveryFinished();
        EasyMock.expectLastCall().times(1);
        ctrl.replay();
        discovery.discover(deviceId);
        discovery.sendBroadcast();
        discovery.received(-1062731519, 1234, responseDatagram);
        discovery.sendBroadcast();
        discovery.received(-1062731519, 1234, responseDatagram);
        discovery.sendBroadcast();
        discovery.received(-1062731519, 1234, responseDatagram);
        discovery.stopWaiting();
        ctrl.verify();
    }
}

