/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.execcmd.ExecCmdApp;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ExecCmdApp.class})
public class ExecCmdAppTests {
    private GatewayDeviceConnection gdc = null;
    private ExecCmdApp.Callback callback = null;
    private String mac = "00:00:00:00:00:01";
    private String command = "ps ax | grep GDClient";
    private ExecCmdApp execCmd = null;

    @Before
    public void before() {
        this.gdc = PowerMock.createMock(GatewayDeviceConnection.class);
        this.callback = PowerMock.createMock(ExecCmdApp.Callback.class);
        this.execCmd = new ExecCmdApp(this.gdc);
    }

    @After
    public void after() {
        this.gdc = null;
        this.callback = null;
        PowerMock.resetAll(new Object[0]);
    }

    @Test
    public void testExecuteCommandFailed() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(0L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertFalse(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCommandSendException() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.Error);
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertFalse(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCommand() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataNoSession() {
        PowerMock.replayAll(new Object[0]);
        byte[] rdata = new byte[]{};
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataStatusError() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        byte[] rdata = new byte[]{1};
        this.callback.execCmdError(EasyMock.eq(this.mac));
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 0, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataExecStatusTag() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        byte[] rdata = ByteBuffer.allocate(4).putInt(1).array();
        this.callback.execCmdEffect(EasyMock.eq(this.mac), EasyMock.eq(""), EasyMock.eq(1));
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 82, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataOutputTag() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataDoubleOutputTag() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedData2OutputTag1StatusTag() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.execCmd))).andReturn(1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect(this.gdc.send(EasyMock.eq(80), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        this.callback.execCmdEffect(EasyMock.eq(this.mac), EasyMock.eq("some outputsome output"), EasyMock.eq(0));
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        rdata = ByteBuffer.allocate(4).putInt(0).array();
        this.execCmd.receivedData(this.mac, 82, 1L, rdata);
        PowerMock.verifyAll();
    }
}

