/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns;

import com.vestiacom.gdserver.service.DomainNameService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.CachedPrimaryZone;
import se.unlogic.eagledns.CachedSecondaryZone;
import se.unlogic.eagledns.EagleLogin;
import se.unlogic.eagledns.EagleManager;
import se.unlogic.eagledns.LoginHandler;
import se.unlogic.eagledns.SecondaryZone;
import se.unlogic.eagledns.TCPSocketMonitor;
import se.unlogic.eagledns.UDPSocketMonitor;
import se.unlogic.eagledns.ZoneChangeCallback;
import se.unlogic.eagledns.ZoneProvider;
import se.unlogic.eagledns.ZoneProviderUpdatable;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.settings.SettingNode;
import se.unlogic.standardutils.settings.XMLSettingNode;
import se.unlogic.standardutils.string.StringUtils;

public class EagleDNS
implements EagleManager {
    public static final String VERSION = "Eagle DNS 1.0";
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    private final Logger log = Logger.getLogger(this.getClass());
    private final ConcurrentHashMap<Name, CachedPrimaryZone> primaryZoneMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Name, CachedSecondaryZone> secondaryZoneMap = new ConcurrentHashMap();
    private final HashMap<Name, TSIG> TSIGs = new HashMap();
    private final HashMap<String, ZoneProvider> zoneProviders = new HashMap();
    private int tcpThreadPoolSize = 20;
    private int udpThreadPoolSize = 20;
    private int tcpThreadPoolShutdownTimeout = 60;
    private int udpThreadPoolShutdownTimeout = 60;
    private ArrayList<TCPSocketMonitor> tcpMonitorThreads = new ArrayList();
    private ArrayList<UDPSocketMonitor> udpMonitorThreads = new ArrayList();
    private ThreadPoolExecutor tcpThreadPool;
    private ThreadPoolExecutor udpThreadPool;
    private int axfrTimeout = 60;
    private String remotePassword;
    private Integer remotePort;
    private LoginHandler loginHandler;
    private boolean shutdown = false;
    private String configFilePath;
    private DomainNameService domainNameService;
    private long ttl;

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public void setConfigClassPath(String path) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        this.configFilePath = url.getPath();
    }

    public void setDomainNameService(DomainNameService domainNameService) {
        this.domainNameService = domainNameService;
    }

    public void start() throws UnknownHostException {
        Integer udpThreadPoolShutdownTimeout;
        Integer udpThreadPoolSize;
        Integer tcpThreadPoolShutdownTimeout;
        XMLSettingNode configFile;
        System.out.println("Eagle DNS 1.0 starting...");
        this.log.fatal("Eagle DNS 1.0 starting...");
        try {
            this.log.debug("Parsing config file...");
            configFile = new XMLSettingNode(this.configFilePath);
        }
        catch (Exception e) {
            this.log.fatal("Unable to open config file " + this.configFilePath + ", aborting startup!");
            System.out.println("Unable to open config file " + this.configFilePath + ", aborting startup!");
            return;
        }
        this.ttl = configFile.getLong("/Config/Ttl");
        List<Integer> ports = configFile.getIntegers("/Config/System/Port");
        if (ports.isEmpty()) {
            this.log.debug("No ports found in config file " + this.configFilePath + ", using default port 53");
            ports.add(new Integer(53));
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        List<String> addressStrings = configFile.getStrings("/Config/System/Address");
        if (addressStrings == null || addressStrings.isEmpty()) {
            this.log.debug("No addresses found in config, listening on all addresses (0.0.0.0)");
            addresses.add(Address.getByAddress("0.0.0.0"));
        } else {
            for (String addressString : addressStrings) {
                try {
                    addresses.add(Address.getByAddress(addressString));
                }
                catch (UnknownHostException e) {
                    this.log.error("Invalid address " + addressString + " specified in config file, skipping address " + e);
                }
            }
            if (addresses.isEmpty()) {
                this.log.fatal("None of the " + addressStrings.size() + " addresses specified in the config file are valid, aborting startup!\n" + "Correct the addresses or remove them from the config file if you want to listen on all interfaces.");
                System.out.println("None of the " + addressStrings.size() + " addresses specified in the config file are valid, aborting startup!\n" + "Correct the addresses or remove them from the config file if you want to listen on all interfaces.");
            }
        }
        Integer tcpThreadPoolSize = configFile.getInteger("/Config/System/TCPThreadPoolSize");
        if (tcpThreadPoolSize != null) {
            this.log.debug("Setting TCP thread pool size to " + tcpThreadPoolSize);
            this.tcpThreadPoolSize = tcpThreadPoolSize;
        }
        if ((tcpThreadPoolShutdownTimeout = configFile.getInteger("/Config/System/TCPThreadPoolShutdownTimeout")) != null) {
            this.log.debug("Setting TCP thread pool shutdown timeout to " + tcpThreadPoolSize + " seconds");
            this.tcpThreadPoolShutdownTimeout = tcpThreadPoolShutdownTimeout;
        }
        if ((udpThreadPoolSize = configFile.getInteger("/Config/System/UDPThreadPoolSize")) != null) {
            this.log.debug("Setting UDP thread pool size to " + udpThreadPoolSize);
            this.udpThreadPoolSize = udpThreadPoolSize;
        }
        if ((udpThreadPoolShutdownTimeout = configFile.getInteger("/Config/System/UDPThreadPoolShutdownTimeout")) != null) {
            this.log.debug("Setting UDP thread pool shutdown timeout to " + udpThreadPoolSize + " seconds");
            this.udpThreadPoolShutdownTimeout = udpThreadPoolShutdownTimeout;
        }
        this.remotePassword = configFile.getString("/Config/System/RemoteManagementPassword");
        this.log.debug("Remote management password set to " + this.remotePassword);
        this.remotePort = configFile.getInteger("/Config/System/RemoteManagementPort");
        this.log.debug("Remote management port set to " + this.remotePort);
        Integer axfrTimeout = configFile.getInteger("/Config/System/AXFRTimeout");
        if (axfrTimeout != null) {
            this.log.debug("Setting AXFR timeout to " + axfrTimeout);
            this.axfrTimeout = axfrTimeout;
        }
        List<XMLSettingNode> zoneProviderElements = configFile.getSettings("/Config/ZoneProviders/ZoneProvider");
        for (XMLSettingNode settingNode : zoneProviderElements) {
            String name = settingNode.getString("Name");
            if (StringUtils.isEmpty(name)) {
                this.log.error("ZoneProvider element with no name set found in config, ignoring element.");
                continue;
            }
            String className = settingNode.getString("Class");
            if (StringUtils.isEmpty(className)) {
                this.log.error("ZoneProvider element with no class set found in config, ignoring element.");
                continue;
            }
            try {
                this.log.debug("Instantiating zone provider " + name + " (" + className + ")");
                ZoneProvider zoneProvider = (ZoneProvider)Class.forName(className).newInstance();
                this.log.debug("Zone provider " + name + " successfully instantiated");
                List<XMLSettingNode> propertyElements = settingNode.getSettings("Properties/Property");
                for (SettingNode settingNode2 : propertyElements) {
                    String propertyName = settingNode2.getString("@name");
                    if (StringUtils.isEmpty(propertyName)) {
                        this.log.error("Property element with no name set found in config, ignoring element");
                        continue;
                    }
                    String value = settingNode2.getString(".");
                    this.log.debug("Found value " + value + " for property " + propertyName);
                    try {
                        Method method = zoneProvider.getClass().getMethod("set" + StringUtils.toFirstLetterUppercase(propertyName), String.class);
                        ReflectionUtils.fixMethodAccess(method);
                        this.log.debug("Setting property " + propertyName);
                        try {
                            method.invoke((Object)zoneProvider, value);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.error("Unable to set property " + propertyName + " on zone provider " + name + " (" + className + ")", e);
                        }
                        catch (InvocationTargetException e) {
                            this.log.error("Unable to set property " + propertyName + " on zone provider " + name + " (" + className + ")", e);
                        }
                    }
                    catch (SecurityException e) {
                        this.log.error("Unable to find matching setter method for property " + propertyName + " in zone provider " + name + " (" + className + ")", e);
                    }
                    catch (NoSuchMethodException e) {
                        this.log.error("Unable to find matching setter method for property " + propertyName + " in zone provider " + name + " (" + className + ")", e);
                    }
                }
                try {
                    if (zoneProvider instanceof ZoneProviderUpdatable) {
                        ((ZoneProviderUpdatable)((Object)zoneProvider)).setChangeListener(new ZoneChangeCallback(){

                            @Override
                            public void zoneDataChanged() {
                                EagleDNS.this.reloadZones();
                            }
                        });
                    }
                    zoneProvider.init(name);
                    this.log.info("Zone provider " + name + " (" + className + ") successfully initialized!");
                    this.zoneProviders.put(name, zoneProvider);
                }
                catch (Throwable throwable) {
                    this.log.error("Error initializing zone provider " + name + " (" + className + ")", throwable);
                }
            }
            catch (InstantiationException e) {
                this.log.error("Unable to create instance of class " + className + " for zone provider " + name, e);
            }
            catch (IllegalAccessException e) {
                this.log.error("Unable to create instance of class " + className + " for zone provider " + name, e);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Unable to create instance of class " + className + " for zone provider " + name, e);
            }
        }
        if (this.zoneProviders.isEmpty()) {
            this.log.fatal("No zone providers found or started, aborting startup!");
            System.out.println("No zone providers found or started, aborting startup!");
            return;
        }
        this.reloadZones();
        if (this.remotePassword == null || this.remotePort == null) {
            this.log.info("Remote managed port and/or password not set, remote managent will not be available.");
        } else {
            this.log.info("Starting remote interface on port " + this.remotePort);
            this.loginHandler = new LoginHandler(this, this.remotePassword);
            try {
                EagleLogin eagleLogin = (EagleLogin)UnicastRemoteObject.exportObject((Remote)this.loginHandler, this.remotePort);
                UnicastRemoteObject.exportObject((Remote)this, this.remotePort);
                Registry registry = LocateRegistry.createRegistry(this.remotePort);
                registry.bind("eagleLogin", eagleLogin);
            }
            catch (AccessException e) {
                this.log.fatal("Unable to start remote manangement interface, aborting startup!", e);
                System.out.println("Unable to start remote manangement interface, aborting startup!");
                return;
            }
            catch (RemoteException e) {
                this.log.fatal("Unable to start remote manangement interface, aborting startup!", e);
                System.out.println("Unable to start remote manangement interface, aborting startup!");
                return;
            }
            catch (AlreadyBoundException e) {
                this.log.fatal("Unable to start remote manangement interface, aborting startup!", e);
                System.out.println("Unable to start remote manangement interface, aborting startup!");
                return;
            }
        }
        this.log.info("Initializing TCP thread pool...");
        this.tcpThreadPool = new ThreadPoolExecutor(this.tcpThreadPoolSize, this.tcpThreadPoolSize, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.log.info("Initializing UDP thread pool...");
        this.udpThreadPool = new ThreadPoolExecutor(this.udpThreadPoolSize, this.udpThreadPoolSize, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        for (InetAddress addr : addresses) {
            for (int port : ports) {
                try {
                    this.udpMonitorThreads.add(new UDPSocketMonitor(this, addr, port));
                }
                catch (SocketException e) {
                    this.log.error("Unable to open UDP server socket on address " + addr + ":" + port + ", " + e);
                }
                try {
                    this.tcpMonitorThreads.add(new TCPSocketMonitor(this, addr, port));
                }
                catch (IOException e) {
                    this.log.error("Unable to open TCP server socket on address " + addr + ":" + port + ", " + e);
                }
            }
        }
        if (this.tcpMonitorThreads.isEmpty() && this.udpMonitorThreads.isEmpty()) {
            this.log.fatal("Not bound on any sockets, aborting startup!");
            System.out.println("Not bound on any sockets, aborting startup!");
            return;
        }
        this.log.fatal("Eagle DNS 1.0 started with " + this.primaryZoneMap.size() + " primary zones and " + this.secondaryZoneMap.size() + " secondary zones");
        System.out.println("Eagle DNS 1.0 started with " + this.primaryZoneMap.size() + " primary zones and " + this.secondaryZoneMap.size() + " secondary zones");
    }

    @Override
    public synchronized void shutdown() {
        new Thread(){

            @Override
            public void run() {
                EagleDNS.this.actualShutdown();
            }
        }.start();
    }

    synchronized void actualShutdown() {
        if (!this.shutdown) {
            this.log.fatal("Shutting down Eagle DNS 1.0...");
            System.out.println("Shutting down Eagle DNS 1.0...");
            this.shutdown = true;
            this.log.info("Stopping TCP thread pool...");
            this.tcpThreadPool.shutdown();
            try {
                this.tcpThreadPool.awaitTermination(this.tcpThreadPoolShutdownTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                this.log.error("Timeout waiting " + this.tcpThreadPoolShutdownTimeout + " seconds for TCP thread pool to shutdown, forcing thread pool shutdown...");
                this.tcpThreadPool.shutdownNow();
            }
            this.log.info("Stopping UDP thread pool...");
            this.udpThreadPool.shutdown();
            try {
                this.udpThreadPool.awaitTermination(this.udpThreadPoolShutdownTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                this.log.error("Timeout waiting " + this.udpThreadPoolShutdownTimeout + " seconds for UDP thread pool to shutdown, forcing thread pool shutdown...");
                this.udpThreadPool.shutdownNow();
            }
            this.log.fatal("Eagle DNS 1.0 stopped");
            System.out.println("Eagle DNS 1.0 stopped");
        }
    }

    @Override
    public synchronized void reloadZones() {
        this.primaryZoneMap.clear();
        this.secondaryZoneMap.clear();
        for (Map.Entry<String, ZoneProvider> zoneProviderEntry : this.zoneProviders.entrySet()) {
            Collection<SecondaryZone> secondaryZones;
            Collection<Zone> primaryZones;
            this.log.info("Getting primary zones from zone provider " + zoneProviderEntry.getKey());
            try {
                primaryZones = zoneProviderEntry.getValue().getPrimaryZones();
            }
            catch (Throwable e) {
                this.log.error("Error getting primary zones from zone provider " + zoneProviderEntry.getKey(), e);
                continue;
            }
            if (primaryZones != null) {
                for (Zone zone : primaryZones) {
                    this.log.info("Got zone " + zone.getOrigin());
                    this.primaryZoneMap.put(zone.getOrigin(), new CachedPrimaryZone(zone, zoneProviderEntry.getValue()));
                }
            }
            this.log.info("Getting secondary zones from zone provider " + zoneProviderEntry.getKey());
            try {
                secondaryZones = zoneProviderEntry.getValue().getSecondaryZones();
            }
            catch (Throwable e) {
                this.log.error("Error getting secondary zones from zone provider " + zoneProviderEntry.getKey(), e);
                continue;
            }
            if (secondaryZones == null) continue;
            for (SecondaryZone zone : secondaryZones) {
                this.log.info("Got zone " + zone.getZoneName() + " (" + zone.getRemoteServerAddress() + ")");
                CachedSecondaryZone cachedSecondaryZone = new CachedSecondaryZone(zoneProviderEntry.getValue(), zone);
                this.secondaryZoneMap.put(cachedSecondaryZone.getSecondaryZone().getZoneName(), cachedSecondaryZone);
            }
        }
    }

    private void addTSIG(String algstr, String namestr, String key) throws IOException {
        Name name = Name.fromString(namestr, Name.root);
        this.TSIGs.put(name, new TSIG(algstr, namestr, key));
    }

    private Zone findBestZone(Name name) {
        Zone foundzone = this.getZone(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        int i = 1;
        while (i < labels) {
            Name tname = new Name(name, i);
            foundzone = this.getZone(tname);
            if (foundzone != null) {
                return foundzone;
            }
            ++i;
        }
        return null;
    }

    private Zone getZone(Name name) {
        CachedPrimaryZone cachedPrimaryZone = this.primaryZoneMap.get(name);
        if (cachedPrimaryZone != null) {
            return cachedPrimaryZone.getZone();
        }
        CachedSecondaryZone cachedSecondaryZone = this.secondaryZoneMap.get(name);
        if (cachedSecondaryZone != null && cachedSecondaryZone.getSecondaryZone().getZoneCopy() != null) {
            return cachedSecondaryZone.getSecondaryZone().getZoneCopy();
        }
        return null;
    }

    private RRset findExactMatch(Name name, int type, int dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        return null;
    }

    private void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        int s = 1;
        while (s <= section) {
            if (response.findRRset(name, rrset.getType(), s)) {
                return;
            }
            ++s;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private final void addSOA(Message response, Zone zone) {
        response.addRecord(zone.getSOA(), 2);
    }

    private final void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, 1, 1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records;
        Record[] recordArray = records = response.getSectionArray(section);
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record r = recordArray[n2];
            Name glueName = r.getAdditionalName();
            if (glueName != null) {
                this.addGlue(response, glueName, flags);
            }
            ++n2;
        }
    }

    private final void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    private byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        Zone zone;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        if ((zone = this.findBestZone(name)) != null) {
            SetResponse sr = zone.findRecords(name, type);
            if (sr.isNXDOMAIN()) {
                String foundAddress = this.domainNameService.resolve(name.toString().toLowerCase());
                if (foundAddress == null) {
                    response.getHeader().setRcode(3);
                    if (zone != null) {
                        this.addSOA(response, zone);
                        if (iterations == 0) {
                            response.getHeader().setFlag(5);
                        }
                    }
                    rcode = 3;
                } else if (type != 255 && type != 1) {
                    this.addSOA(response, zone);
                    if (iterations == 0) {
                        response.getHeader().setFlag(5);
                    }
                } else {
                    RRset rrset = this.createRRset(name, foundAddress);
                    if (rrset == null) {
                        return 2;
                    }
                    this.addRRset(name, response, rrset, 1, flags);
                    if (zone != null) {
                        this.addNS(response, zone, flags);
                        if (iterations == 0) {
                            response.getHeader().setFlag(5);
                        }
                    }
                }
            } else if (sr.isNXRRSET()) {
                if (zone != null) {
                    this.addSOA(response, zone);
                    if (iterations == 0) {
                        response.getHeader().setFlag(5);
                    }
                }
            } else if (sr.isDelegation()) {
                RRset nsRecords = sr.getNS();
                this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
            } else if (sr.isCNAME()) {
                CNAMERecord cname = sr.getCNAME();
                RRset rrset = new RRset(cname);
                this.addRRset(name, response, rrset, 1, flags);
                if (zone != null && iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
            } else if (sr.isDNAME()) {
                Name newname;
                DNAMERecord dname = sr.getDNAME();
                RRset rrset = new RRset(dname);
                this.addRRset(name, response, rrset, 1, flags);
                try {
                    newname = name.fromDNAME(dname);
                }
                catch (NameTooLongException e) {
                    return 6;
                }
                rrset = new RRset(new CNAMERecord(name, dclass, 0L, newname));
                this.addRRset(name, response, rrset, 1, flags);
                if (zone != null && iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
            } else if (sr.isSuccessful()) {
                RRset[] rrsets;
                RRset[] rRsetArray = rrsets = sr.answers();
                int n = rrsets.length;
                int n2 = 0;
                while (n2 < n) {
                    RRset rrset = rRsetArray[n2];
                    this.addRRset(name, response, rrset, 1, flags);
                    ++n2;
                }
                if (zone != null) {
                    this.addNS(response, zone, flags);
                    if (iterations == 0) {
                        response.getHeader().setFlag(5);
                    }
                }
            }
        }
        return (byte)rcode;
    }

    private byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        boolean first = true;
        Zone zone = this.findBestZone(name);
        if (zone == null) {
            return this.errorMessage(query, 5);
        }
        boolean axfrAllowed = false;
        Iterator nsIterator = zone.getNS().rrs();
        while (nsIterator.hasNext()) {
            NSRecord record = (NSRecord)nsIterator.next();
            try {
                String nsIP = InetAddress.getByName(record.getTarget().toString()).getHostAddress();
                if (!s.getInetAddress().getHostAddress().equals(nsIP)) continue;
                axfrAllowed = true;
                break;
            }
            catch (UnknownHostException e) {
                this.log.warn("Unable to resolve hostname of nameserver " + record.getTarget() + " in zone " + zone.getOrigin() + " while processing AXFR request from " + s.getRemoteSocketAddress());
            }
        }
        if (!axfrAllowed) {
            this.log.warn("AXFR request of zone " + zone.getOrigin() + " from " + s.getRemoteSocketAddress() + " refused!");
            return this.errorMessage(query, 5);
        }
        Iterator it = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (it.hasNext()) {
                RRset rrset = (RRset)it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, 1, 1);
                if (tsig != null) {
                    tsig.applyStream(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ex) {
            this.log.warn("AXFR failed", ex);
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private ARecord createARecord(Name name, String address) throws IOException {
        return new ARecord(name, 1, this.ttl, InetAddress.getByName(address));
    }

    private RRset createRRset(Name name, String address) {
        try {
            return new RRset(this.createARecord(name, address));
        }
        catch (IOException e) {
            this.log.warn("Failed to create RRset for name=" + name + " and address=" + address + ": " + e.getMessage());
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    byte[] generateReply(Message query, byte[] in, int length, Socket socket) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this.TSIGs.get(queryTSIG.getName())) == null || tsig.verify(query, in, length, null) != 0)) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT != null) {
            queryOPT.getVersion();
        }
        int maxLength = socket != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        if (type == 252 && socket != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, socket);
        }
        if (!Type.isRR(type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
            response.addRecord(opt, 3);
        }
        response.setTSIG(tsig, 0, queryTSIG);
        return response.toWire(maxLength);
    }

    private byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        int i = 0;
        while (i < 4) {
            response.removeAllRecords(i);
            ++i;
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    private byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    protected void UDPClient(DatagramSocket socket, DatagramPacket inDataPacket) {
    }

    public static String toString(Record record) {
        if (record == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(record.getName());
        stringBuilder.append(" ");
        stringBuilder.append(record.getTTL());
        stringBuilder.append(" ");
        stringBuilder.append(DClass.string(record.getDClass()));
        stringBuilder.append(" ");
        stringBuilder.append(Type.string(record.getType()));
        String rdata = record.rdataToString();
        if (!rdata.equals("")) {
            stringBuilder.append(" ");
            stringBuilder.append(rdata);
        }
        return stringBuilder.toString();
    }

    protected ThreadPoolExecutor getTcpThreadPool() {
        return this.tcpThreadPool;
    }

    protected ThreadPoolExecutor getUdpThreadPool() {
        return this.udpThreadPool;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

