/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.wififinder;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.Utility;
import homemonitor.wififinder.WifiFinderInterface;
import homemonitor.wififinder.WifiReceiverInterface;
import java.util.HashMap;
import org.apache.log4j.Logger;

@Deprecated
public class WifiFinder
extends Application
implements WifiFinderInterface {
    private static final int FINDWIFI_TAG = 18;
    private static final int FOUNDWIFI_TAG = 19;
    private static Logger log = Logger.getLogger(WifiFinder.class);
    private GatewayDeviceConnectionInterface connection;
    private HashMap<Long, WifiReceiverInterface> sessionHandlers = new HashMap();

    public WifiFinder(GatewayDeviceConnectionInterface connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        HashMap<Long, WifiReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            WifiReceiverInterface receiver = this.sessionHandlers.remove(sessionId);
            if (receiver != null) {
                receiver.deviceDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        WifiReceiverInterface response;
        HashMap<Long, WifiReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            response = this.sessionHandlers.get(sessionId);
        }
        if (tag == 0) {
            if (data[0] != 0) {
                log.warn("WifiFinder got Status Error (" + data[0] + ") from GD.");
                response.received(null);
            }
            return;
        }
        if (response == null) {
            log.warn("WifiFinder received response when session " + sessionId + " closed already.");
            return;
        }
        switch (tag) {
            case 19: {
                log.debug("Received FOUNDWIFI tag.");
                String foundWlanAccessPoints = null;
                if (data != null) {
                    foundWlanAccessPoints = Utility.byteArrayASCIIToString(data);
                }
                log.debug("Received found wlan acess points: " + foundWlanAccessPoints + ".");
                response.received(foundWlanAccessPoints);
                break;
            }
            default: {
                log.warn("Received unknown identifier: " + tag + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceID, WifiReceiverInterface receiver) {
        long sessionID = this.connection.createSession(deviceID, this);
        if (sessionID != 0L) {
            HashMap<Long, WifiReceiverInterface> hashMap = this.sessionHandlers;
            synchronized (hashMap) {
                this.sessionHandlers.put(sessionID, receiver);
            }
        }
        this.sessionAdd(deviceID, sessionID);
        return sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionID, String cameraIpAddress) {
        log.debug("start send(sessionID=" + sessionID + ", cameraIpAddress=" + cameraIpAddress + ")");
        HashMap<Long, WifiReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            if (!this.sessionHandlers.containsKey(sessionID) || sessionID == 0L) {
                log.warn("No device connected.");
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] payload = this.preparePayload(cameraIpAddress);
        GDErrorCode status = this.connection.send(18, sessionID, payload);
        log.debug("exit send(sessionID=" + sessionID + ", cameraIpAddress=" + cameraIpAddress + "): " + (Object)((Object)status));
        return status;
    }

    private byte[] preparePayload(String ipAddress) {
        return Utility.ipAddressToByteArray(ipAddress);
    }
}

