/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.tcpclient;

import homemonitor.GDErrorCode;
import homemonitor.TCPProxy.TCPProxyInterface;
import homemonitor.TCPProxy.TCPProxyResponseInterface;
import homemonitor.tcpclient.SessionNoGen;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TCPClient
implements TCPProxyInterface {
    private static Logger log = Logger.getLogger(TCPClient.class);
    private List<ChangeRequest> changeRequests = new LinkedList<ChangeRequest>();
    private Map<Long, TcpClientSession> sessions = Collections.synchronizedMap(new HashMap());
    private SessionNoGen sessionNoGen;
    private Selector selector;
    boolean running = true;
    final int BufferSize = 2048;
    private Thread networkThread = new Thread(){

        @Override
        public void run() {
            super.setName("GDServerBackendCommThread");
            log.debug("TCPClient.networkThread started");
            try {
                while (TCPClient.this.running) {
                    TCPClient.this.runLoop();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            log.debug("TCPClient.networkThread stopped");
        }
    };

    public TCPClient(SessionNoGen sessionNoGen) {
        this.sessionNoGen = sessionNoGen;
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.networkThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long connect(String deviceId, String dstAddress, int dstPort, TCPProxyResponseInterface responseHandler) {
        TcpClientSession session;
        block5: {
            log.trace("start connect deviceId=" + deviceId + ", dstAddress=" + dstAddress + ", dstPort=" + dstPort + ", responseHandler=" + responseHandler);
            session = new TcpClientSession();
            session.sessionId = this.sessionNoGen.generateSessionNo();
            session.responseInterface = responseHandler;
            try {
                session.socket = SocketChannel.open();
                session.socket.configureBlocking(false);
                session.socket.connect(new InetSocketAddress(dstAddress, dstPort));
                List<ChangeRequest> list = this.changeRequests;
                synchronized (list) {
                    this.changeRequests.add(new ChangeRequest(session.socket, 1, 8, session));
                }
            }
            catch (IOException e) {
                log.error("Error conecting to server: address=" + dstAddress + ", port=" + dstPort + ": " + e.getMessage());
                if (!log.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
        this.sessions.put(session.sessionId, session);
        return session.sessionId;
    }

    public void beanDestroyed() {
        this.running = false;
        this.selector.wakeup();
        this.networkThread.interrupt();
        try {
            this.networkThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() throws Exception {
        List<ChangeRequest> list = this.changeRequests;
        synchronized (list) {
            for (ChangeRequest change : this.changeRequests) {
                switch (change.type) {
                    case 1: {
                        change.session.key = change.socket.register(this.selector, change.ops);
                        change.session.key.attach(change.session);
                        break;
                    }
                    case 2: {
                        SelectionKey key = change.socket.keyFor(this.selector);
                        key.interestOps(change.ops);
                    }
                }
            }
            this.changeRequests.clear();
        }
        this.selector.select(1000L);
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = keys.iterator();
        while (i.hasNext()) {
            int numRead;
            ByteBuffer buffer;
            TcpClientSession session;
            block14: {
                SelectionKey key = i.next();
                i.remove();
                if (key.isConnectable()) {
                    TcpClientSession session2 = (TcpClientSession)key.attachment();
                    if (session2.socket.isConnectionPending()) {
                        session2.socket.finishConnect();
                    }
                    log.trace("socket connected");
                    session2.responseInterface.accepted(session2.sessionId);
                    session2.key = session2.socket.register(this.selector, 1);
                    session2.key.attach(session2);
                }
                if (!key.isReadable()) continue;
                SocketChannel client = (SocketChannel)key.channel();
                session = (TcpClientSession)key.attachment();
                buffer = ByteBuffer.allocate(2048);
                try {
                    numRead = client.read(buffer);
                    if (numRead == -1) break block14;
                    buffer.limit(numRead);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.disconect(session);
                    continue;
                }
            }
            if (numRead == -1) {
                this.disconect(session);
                continue;
            }
            byte[] ret = new byte[numRead];
            buffer.rewind();
            buffer.get(ret, 0, numRead);
            session.responseInterface.received(session.sessionId, ret);
        }
    }

    @Override
    public GDErrorCode send(long sessionId, byte[] data) {
        log.trace("start send: sessionId=" + sessionId + ", data=" + new String(data));
        TcpClientSession session = this.sessions.get(sessionId);
        if (session == null) {
            return GDErrorCode.WrongSessionID;
        }
        try {
            session.socket.write(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return GDErrorCode.NoError;
    }

    private void disconect(TcpClientSession session) {
        if (session.responseInterface != null) {
            session.responseInterface.closed(session.sessionId);
        }
        this.sessions.remove(session.sessionId);
        session.key.cancel();
        try {
            session.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public GDErrorCode disconnect(long sessionId) {
        log.trace("start disconnect: sessionId=" + sessionId);
        TcpClientSession session = this.sessions.get(sessionId);
        if (session == null) {
            return GDErrorCode.WrongSessionID;
        }
        this.disconect(session);
        return GDErrorCode.NoError;
    }

    public class ChangeRequest {
        public static final int REGISTER = 1;
        public static final int CHANGEOPS = 2;
        public SocketChannel socket;
        public int type;
        public int ops;
        public TcpClientSession session;

        public ChangeRequest(SocketChannel socket, int type, int ops, TcpClientSession session) {
            this.socket = socket;
            this.type = type;
            this.ops = ops;
            this.session = session;
        }
    }

    public class TcpClientSession {
        public long sessionId;
        public TCPProxyResponseInterface responseInterface;
        public SelectionKey key;
        public SocketChannel socket;
    }
}

