/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.Message;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.GatewayDeviceConnectionListener;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ConnectionCallbacks
implements GatewayDeviceConnectionListener {
    private static Logger log = Logger.getLogger(ConnectionCallbacks.class);
    private static Logger connectionsLog = Logger.getLogger("connectionsLog");
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private GatewayDeviceConnection connection;
    private AppServerConnector appServerConnector;
    private ThreadPoolTaskExecutor taskExecutor;

    @Autowired
    @Required
    public void setDaoFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Autowired
    @Required
    public void setConnection(GatewayDeviceConnection connection) {
        this.connection = connection;
    }

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @Autowired
    @Required
    public void setTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void initialize() {
        this.sessionDao = this.daoFactory.getSessionDao();
        this.connection.addListener(this);
    }

    @Override
    public void connected(final String mac, final String publicIpAddress, final String localIpAddress, final String restUrl) {
        log.debug("start connected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", localIpAddress=" + localIpAddress + ", restUrl=" + restUrl + ")");
        connectionsLog.info("Device " + mac + "/" + publicIpAddress + " connected.");
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionCallbacks.this.handleConnected(mac, publicIpAddress, localIpAddress, restUrl);
            }
        });
    }

    void handleConnected(String mac, String publicIpAddress, String localIpAddress, String restUrl) {
        log.debug("start handleConnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", localIpAddress=" + localIpAddress + ", restUrl=" + restUrl + ")");
        GatewayDevice device = this.connection.findById(mac);
        if (device == null) {
            return;
        }
        SessionEntity session = this.sessionDao.get(mac);
        log.trace("session: " + session);
        if (session == null) {
            this.storeSession(device, restUrl, true, null);
            this.appServerConnector.addMessage(this.getConnectedMsg(mac, publicIpAddress, localIpAddress, restUrl, null));
        } else {
            this.storeSession(device, restUrl, true, session.getRegistered());
            if (session.getRegistered() == null || session.isRegistered()) {
                log.debug("Device " + mac + " is registered. Sending connected message...");
                this.appServerConnector.addMessage(this.getConnectedMsg(mac, publicIpAddress, localIpAddress, restUrl, session.getRegistered()));
            } else {
                log.debug("Device " + mac + " is not registered. Connected message will not be send...");
            }
        }
    }

    private Message getConnectedMsg(String mac, String publicIpAddress, String localIpAddress, String restUrl, Boolean registerd) {
        Message msg = new Message(Message.Type.CONNECTED, mac);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.LOCAL_IP_ADDRESS, localIpAddress);
        msg.setParam(Message.Param.REST_URL, restUrl);
        if (registerd != null) {
            msg.setParam(Message.Param.REGISTERED, registerd.toString());
        }
        return msg;
    }

    private void storeSession(GatewayDevice device, String restUrl, boolean connected, Boolean registered) {
        SessionEntity session = new SessionEntity();
        session.setPublicIp(device.getPublicIpAddress());
        session.setLocalIp(device.getLocalIpAddress());
        session.setServerUrl(restUrl);
        session.setRegistered(registered);
        this.sessionDao.store(device.getMac(), session);
    }

    @Override
    public void disconnected(final String mac, final String publicIpAddress, final String reason, final String restUrl) {
        connectionsLog.info("Device " + mac + "/" + publicIpAddress + " disconnected (" + reason + ")");
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionCallbacks.this.handleDisconnected(mac, publicIpAddress, reason, restUrl);
            }
        });
    }

    void handleDisconnected(String mac, String publicIpAddress, String reason, String restUrl) {
        log.trace("start handleDisconnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", reason=" + reason + ", restUrl=" + restUrl + ")");
        SessionEntity session = this.sessionDao.get(mac);
        if (session != null && session.isRegistered()) {
            this.appServerConnector.addMessage(this.getDisconnectedMsg(mac, publicIpAddress, reason, restUrl));
        }
        this.sessionDao.disconnected(mac, restUrl);
    }

    private Message getDisconnectedMsg(String mac, String publicIpAddress, String reason, String restUrl) {
        Message msg = new Message(Message.Type.DISCONNECTED, mac);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.REASON, reason);
        msg.setParam(Message.Param.REST_URL, restUrl);
        return msg;
    }

    @Override
    public void receivedLogs(final String mac, final String logs) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionCallbacks.this.handleReceivedLogs(mac, logs);
            }
        });
    }

    void handleReceivedLogs(String mac, String logs) {
        this.appServerConnector.addMessage(this.getLogMsg(mac, logs));
    }

    private Message getLogMsg(String mac, String logs) {
        Message msg = new Message(Message.Type.LOGS, mac);
        msg.setParam(Message.Param.VALUE, logs);
        return msg;
    }

    @Override
    public void keepAliveReceived(String mac) {
    }
}

