/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.VivotekCameraDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jws.WebParam;
import javax.jws.WebResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class VivotekCameraDiscoveryService
implements CameraDiscoveryService,
LANDeviceDiscoveryNotification {
    private UDPProxyInterface udpProxy;
    private CountDownLatch latch;
    private ArrayList<DiscoveredLanDevice> devices = new ArrayList();

    @Autowired
    public VivotekCameraDiscoveryService(UDPProxyInterface udpProxy) {
        this.udpProxy = udpProxy;
    }

    @Override
    @WebResult(name="devices")
    public List<DiscoveredLanDevice> discover(@WebParam(name="id") String deviceId) {
        this.devices.clear();
        VivotekCameraDiscovery discoverer = new VivotekCameraDiscovery(this.udpProxy, this);
        this.latch = new CountDownLatch(1);
        discoverer.discover(deviceId);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.devices;
    }

    @Override
    public void foundNewLANDevice(DiscoveredLanDevice dev) {
        this.devices.add(dev);
    }

    @Override
    public void discoveryFinished() {
        this.latch.countDown();
    }

    @Override
    public void discoveryError() {
        this.latch.countDown();
    }
}

