/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import com.vestiacom.gdserver.service.HTTPClientServiceFactory;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GDErrorCode;
import homemonitor.HTTPClient.HTTPClientService;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jws.WebResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.w3c.dom.Document;

public abstract class SsdpCameraDiscoveryService
implements CameraDiscoveryService {
    private long ssdpAddress;
    private int ssdpSrcPort;
    private int ssdpDestPort;
    private static final int TIMEOUT = 5000;
    private UDPProxyInterface udpProxy;
    private long udpProxySessionId;
    private HTTPClientServiceFactory httpClientServiceFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private DocumentBuilder documentBuilder;
    private Pattern pattern;
    public final String UPNP_SCHEMA_DEVICE_TYPE_BASIC = "urn:schemas-upnp-org:service:BasicService:1";
    protected Logger log = Logger.getLogger(SsdpCameraDiscoveryService.class);

    @Value(value="${ssdp.address:EFFFFFFA}")
    public void setSsdpAddress(String ssdpAddress) {
        this.ssdpAddress = new BigInteger(ssdpAddress, 16).longValue();
    }

    @Value(value="${ssdp.srcPort:1901}")
    public void setSsdpSrcPort(int ssdpSrcPort) {
        this.ssdpSrcPort = ssdpSrcPort;
    }

    @Value(value="${ssdp.destPort:1900}")
    public void setSsdpDestPort(int ssdpDestPort) {
        this.ssdpDestPort = ssdpDestPort;
    }

    public SsdpCameraDiscoveryService(UDPProxyInterface udpProxy) {
        this.udpProxy = udpProxy;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.pattern = Pattern.compile("Location:.+?$", 10);
    }

    protected abstract String getXmlTagNameWithMacAddress();

    protected abstract String getManufacturer();

    @Autowired
    @Required
    public void setHttpClientServiceFactory(HTTPClientServiceFactory httpClientServiceFactory) {
        this.httpClientServiceFactory = httpClientServiceFactory;
    }

    @Override
    @WebResult(name="devices")
    public List<DiscoveredLanDevice> discover(String gatewayClientMac) {
        SsdpCameraDiscoverer discoverer = new SsdpCameraDiscoverer(gatewayClientMac);
        this.udpProxySessionId = this.udpProxy.createSession(gatewayClientMac, discoverer);
        if (this.udpProxySessionId == 0L) {
            this.log.debug("cannot start UDP proxy session");
            return new LinkedList<DiscoveredLanDevice>();
        }
        this.udpProxy.bind(this.udpProxySessionId, this.ssdpSrcPort);
        String datagram = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:" + this.ssdpDestPort + "\r\n" + "ST: " + this.getUpnpDeviceTypeSchema() + "\r\n" + "MAN: \"ssdp:discover\"\r\n" + "MX: 3\r\n\r\n\r\n";
        GDErrorCode errorCode = this.udpProxy.send(this.udpProxySessionId, this.ssdpAddress, this.ssdpDestPort, datagram.getBytes());
        if (errorCode != GDErrorCode.NoError) {
            this.log.debug("cannot sent datagram through UDP proxy");
            return new LinkedList<DiscoveredLanDevice>();
        }
        return discoverer.getDevices();
    }

    protected abstract String getUpnpDeviceTypeSchema();

    private class SsdpCameraDiscoverer
    implements UDPProxyResponseInterface {
        String gatewayClientMac;
        List<DiscoveredLanDevice> devices = new LinkedList<DiscoveredLanDevice>();
        long lastActivityTs;

        SsdpCameraDiscoverer(String gatewayClientMac) {
            this.gatewayClientMac = gatewayClientMac;
            this.lastActivityTs = System.currentTimeMillis();
        }

        List<DiscoveredLanDevice> getDevices() {
            do {
                SsdpCameraDiscoveryService.this.log.debug("waiting for discoveries to finish");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return this.devices;
                }
            } while (System.currentTimeMillis() - this.lastActivityTs < 5000L);
            SsdpCameraDiscoveryService.this.log.debug("returning results: " + this.devices.size());
            SsdpCameraDiscoveryService.this.udpProxy.close(SsdpCameraDiscoveryService.this.udpProxySessionId);
            return this.devices;
        }

        @Override
        public void received(int srcAddress, int srcPort, byte[] data) {
            String response = new String(data);
            SsdpCameraDiscoveryService.this.log.debug("Received SSDP response: " + response);
            if (!"HTTP".equals(response.substring(0, 4))) {
                SsdpCameraDiscoveryService.this.log.debug("Invalid packet, probably SSDP NOTIFY");
            } else {
                this.lastActivityTs = System.currentTimeMillis();
                this.startHTTPWorkerThread(response);
            }
        }

        private void startHTTPWorkerThread(final String response) {
            Thread workerThread = new Thread(){

                @Override
                public void run() {
                    Matcher matcher = SsdpCameraDiscoveryService.this.pattern.matcher(response);
                    if (matcher.find()) {
                        String location = response.substring(matcher.start() + 9, matcher.end());
                        ((SsdpCameraDiscoverer)SsdpCameraDiscoverer.this).SsdpCameraDiscoveryService.this.log.debug("LOCATION is: " + location);
                        try {
                            HTTPClientService httpClientService = SsdpCameraDiscoveryService.this.httpClientServiceFactory.getInstance(HttpCommand.ConnectionType.TCP_PROXY);
                            HTTPClientServiceResult httpResponse = httpClientService.get(SsdpCameraDiscoverer.this.gatewayClientMac, new URL(location));
                            ((SsdpCameraDiscoverer)SsdpCameraDiscoverer.this).SsdpCameraDiscoveryService.this.log.debug("HTTP response code: " + httpResponse.getStatusCode());
                            String xmlResponse = httpResponse.getBodyAsText();
                            Document document = SsdpCameraDiscoveryService.this.documentBuilder.parse(new ByteArrayInputStream(xmlResponse.getBytes()));
                            SsdpCameraDiscoverer.this.devices.add(SsdpCameraDiscoverer.this.createDiscoveredLanDevice(document));
                        }
                        catch (Exception exception) {}
                    } else {
                        ((SsdpCameraDiscoverer)SsdpCameraDiscoverer.this).SsdpCameraDiscoveryService.this.log.warn("LOCATION not found in SSDP response");
                    }
                    SsdpCameraDiscoverer.this.lastActivityTs = System.currentTimeMillis();
                }
            };
            workerThread.start();
        }

        private DiscoveredLanDevice createDiscoveredLanDevice(Document document) throws Exception {
            DiscoveredLanDevice device2;
            String manufacturer = document.getElementsByTagName("manufacturer").item(0).getTextContent();
            String expectedManufacturer = SsdpCameraDiscoveryService.this.getManufacturer();
            if (!expectedManufacturer.equals(manufacturer)) {
                throw new RuntimeException("camera manufacturer doesn't match, got " + manufacturer + ", expecting " + expectedManufacturer);
            }
            String rawMacAddress = document.getElementsByTagName(SsdpCameraDiscoveryService.this.getXmlTagNameWithMacAddress()).item(0).getTextContent();
            String macAddress = Utils.formatMacAddress(rawMacAddress);
            URL url = new URL(document.getElementsByTagName("presentationURL").item(0).getTextContent());
            for (DiscoveredLanDevice device2 : this.devices) {
                if (!device2.getMac().equals(macAddress)) continue;
                throw new RuntimeException("duplicate device");
            }
            SsdpCameraDiscoveryService.this.log.debug("Found device with MAC " + macAddress + " at IP address " + url.getHost());
            device2 = new DiscoveredLanDevice(macAddress, url.getHost(), "");
            device2.setPort(80);
            return device2;
        }

        @Override
        public void deviceDisconnected(long sessionId) {
        }
    }
}

