/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service;

import com.vestiacom.gdserver.rest.model.Make;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import com.vestiacom.gdserver.service.HttpProxyVerificationService;
import com.vestiacom.gdserver.service.RestProxyService;
import com.vestiacom.gdserver.service.TrendNetCameraDiscoveryService;
import com.vestiacom.gdserver.service.VivotekCameraDiscoveryService;
import com.vestiacom.gdserver.service.VivotekCameraIpAddressDiscoveryService;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import homemonitor.ICETransport.IceTransportService;
import homemonitor.execcmd.ExecCmdService;
import homemonitor.logs.LoggerConfiguratorService;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ServiceFactory
implements ApplicationContextAware {
    private static Logger log = Logger.getLogger(ServiceFactory.class);
    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public IceTransportService getIceTransportService() {
        return (IceTransportService)this.applicationContext.getBean("iceTransportService");
    }

    public LoggerConfiguratorService getLoggerConfiguratorService() {
        return (LoggerConfiguratorService)this.applicationContext.getBean("loggerConfiguratorService");
    }

    public ExecCmdService getExecCmdService(Long timeout) {
        ExecCmdService service = (ExecCmdService)this.applicationContext.getBean("execCmdService");
        if (timeout != null) {
            service.setTimeout(timeout);
        }
        return service;
    }

    public VivotekCameraIpAddressDiscoveryService getVivotekCameraIpAddressDiscoveryService() {
        return (VivotekCameraIpAddressDiscoveryService)this.applicationContext.getBean("vivotekCameraIpAddressDiscoveryService");
    }

    public VivotekCameraDiscoveryService getVivotekCameraDiscoveryService() {
        return (VivotekCameraDiscoveryService)this.applicationContext.getBean("vivotekCameraDiscoveryService");
    }

    public TrendNetCameraDiscoveryService getTrendNetCameraDiscoveryService() {
        return (TrendNetCameraDiscoveryService)this.applicationContext.getBean("trendnetCameraDiscoveryService");
    }

    public CameraDiscoveryService getComproCameraDiscoveryService() {
        return (CameraDiscoveryService)this.applicationContext.getBean("comproCameraDiscoveryService");
    }

    public CameraDiscoveryService getEdimaxCameraDiscoveryService() {
        return (CameraDiscoveryService)this.applicationContext.getBean("edimaxCameraDiscoveryService");
    }

    public CameraDiscoveryService getCameraDiscoveryService(Make make) {
        if (make == null) {
            return null;
        }
        switch (make) {
            case COMPRO: {
                return this.getComproCameraDiscoveryService();
            }
            case EDIMAX: {
                return this.getEdimaxCameraDiscoveryService();
            }
            case TRENDNET: {
                return this.getTrendNetCameraDiscoveryService();
            }
            case VIVOTEK: {
                return this.getVivotekCameraDiscoveryService();
            }
        }
        log.error("Unsupported camera's make: " + (Object)((Object)make) + ".");
        return null;
    }

    public UpnpPortForwardingServiceImpl getUpnpPortForwardingServiceImpl() {
        return (UpnpPortForwardingServiceImpl)this.applicationContext.getBean("upnpPortForwardingServiceImpl");
    }

    public RestProxyService getRestProxyService() {
        return (RestProxyService)this.applicationContext.getBean("restProxyService");
    }

    public HttpProxyVerificationService getHttpVerificationService() {
        return (HttpProxyVerificationService)this.applicationContext.getBean("httpProxyVerificationService");
    }
}

