/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.RestFilter;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RestFilter.class, Utils.class, Response.class, Gson.class})
public class RestFilterTests {
    private RestFilter restFilter;
    private GatewayDeviceConnection deviceConnection;

    @Before
    public void setUp() {
        this.restFilter = new RestFilter();
        this.deviceConnection = PowerMock.createMock(GatewayDeviceConnection.class);
        this.restFilter.setDeviceConnection(this.deviceConnection);
        PowerMock.mockStatic(Utils.class);
    }

    @Test
    public void testDoFilterDeviceConnectedWithMacWithoutSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = PowerMock.createMock(ServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.deviceConnection.findById(mac)).andReturn(device);
        chain.doFilter(request, response);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithMacWithSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = PowerMock.createMock(ServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac + "/someAdditionalData";
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.deviceConnection.findById(mac)).andReturn(device);
        chain.doFilter(request, response);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithHaidWithoutSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = PowerMock.createMock(ServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String haid = "43299c50-794d-11e3-981f-0800200c9a66";
        String uri = "/device/" + haid;
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.deviceConnection.findById(haid)).andReturn(device);
        chain.doFilter(request, response);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithHaidWithSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = PowerMock.createMock(ServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String haid = "43299c50-794d-11e3-981f-0800200c9a66";
        String uri = "/device/" + haid + "/someAdditionalData";
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.deviceConnection.findById(haid)).andReturn(device);
        chain.doFilter(request, response);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceAnotherNodeConnected() throws Exception {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = PowerMock.createMock(ServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        EasyMock.expect(this.deviceConnection.findById(mac)).andReturn(null);
        String deviceHost = "deviceHost";
        EasyMock.expect(this.deviceConnection.getServerUrl(mac)).andReturn(deviceHost);
        Response restResponse = PowerMock.createMock(Response.class);
        PowerMock.expectNew(Response.class, deviceHost).andReturn(restResponse);
        response.setContentType("application/json");
        Gson gson = PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, new Object[0]).andReturn(gson);
        String jsonResponse = "jsonResponse";
        EasyMock.expect(gson.toJson(restResponse)).andReturn(jsonResponse);
        PrintWriter writer = PowerMock.createMock(PrintWriter.class);
        EasyMock.expect(response.getWriter()).andReturn(writer);
        writer.println(jsonResponse);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceClusterNotConnected() throws Exception {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(2);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        EasyMock.expect(this.deviceConnection.findById(mac)).andReturn(null);
        EasyMock.expect(this.deviceConnection.getServerUrl(mac)).andReturn(null);
        Response restResponse = PowerMock.createMock(Response.class);
        PowerMock.expectNew(Response.class, new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn(restResponse);
        response.setContentType("application/json");
        Gson gson = PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, new Object[0]).andReturn(gson);
        String jsonResponse = "jsonResponse";
        EasyMock.expect(gson.toJson(restResponse)).andReturn(jsonResponse);
        PrintWriter writer = PowerMock.createMock(PrintWriter.class);
        EasyMock.expect(response.getWriter()).andReturn(writer);
        writer.println(jsonResponse);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterInvalidPath() throws Exception {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:000";
        String uri = "/devic/" + mac;
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(3);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(false);
        response.sendError(404);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterBlankUri() throws Exception {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String uri = "";
        EasyMock.expect(request.getRequestURI()).andReturn(uri).times(3);
        EasyMock.expect(Utils.isBlank(uri)).andReturn(true);
        response.sendError(404);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterServerUrlRequest() throws Exception {
        HttpServletRequest request = PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac + "/serverUrl";
        EasyMock.expect(request.getRequestURI()).andReturn(uri);
        chain.doFilter(request, response);
        PowerMock.replayAll(new Object[0]);
        this.restFilter.doFilter(request, response, chain);
        PowerMock.verifyAll();
    }
}

