/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver;

import com.vestiacom.gdserver.Settings;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServer {
    private static Logger logger = Logger.getLogger(WebServer.class);
    private Settings settings = null;
    private Server server = null;

    public WebServer(Settings settings) {
        this.settings = settings;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
        this.server = new Server();
        Integer httpPort = this.settings.getInteger("WebServer.listenPort");
        Integer httpsPort = this.settings.getInteger("WebServer.sslListenPort");
        Integer backlog = this.settings.getInteger("WebServer.backlog", 1024);
        if (httpPort == null && httpsPort == null) {
            throw new IllegalStateException("Either httpPort or httpsPort should be defined");
        }
        if (httpPort != null) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(httpPort);
            connector.setAcceptQueueSize(backlog);
            connector.setMaxIdleTime(30000);
            this.server.addConnector(connector);
            logger.info("Listening http on " + httpPort);
        }
        if (httpsPort != null) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            sslConnector.setPort(httpsPort);
            sslConnector.setAcceptQueueSize(backlog);
            sslConnector.setMaxIdleTime(30000);
            SslContextFactory cf = sslConnector.getSslContextFactory();
            String keyStorePath = this.settings.getString("WebServer.keyStorePath");
            if (keyStorePath == null) {
                throw new IllegalArgumentException("keyStorePath is null");
            }
            cf.setKeyStorePath(keyStorePath);
            String keyStorePassword = this.settings.getString("WebServer.keyStorePassword");
            if (keyStorePassword == null) {
                throw new IllegalArgumentException("keyStorePassword is null");
            }
            cf.setKeyStorePassword(keyStorePassword);
            String keyManagerPassword = this.settings.getString("WebServer.keyManagerPassword");
            if (keyManagerPassword == null) {
                throw new IllegalArgumentException("keyManagerPassword is null");
            }
            cf.setKeyManagerPassword(keyManagerPassword);
            this.server.addConnector(sslConnector);
            logger.info("Listening https on " + httpsPort);
        }
        WebAppContext context = new WebAppContext();
        context.setDescriptor("web.xml");
        context.setResourceBase(".");
        context.setContextPath("/");
        context.setParentLoaderPriority(true);
        this.server.setHandler(context);
        this.server.start();
        this.server.join();
    }

    public boolean isStarted() {
        return this.server != null;
    }

    public void stop() throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("!started");
        }
        this.server.stop();
        this.server.join();
        this.server = null;
    }
}

