/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.provider;

import java.util.HashSet;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.shim.provider.HeaderProvider;
import org.xmlpull.v1.XmlPullParser;

public abstract class AbstractHttpOverXmppProvider
implements IQProvider {
    private static final String ELEMENT_HEADERS = "headers";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_DATA = "data";
    private static final String ELEMENT_TEXT = "text";
    private static final String ELEMENT_BASE_64 = "base64";
    private static final String ELEMENT_CHUNKED_BASE_64 = "chunkedBase64";
    private static final String ELEMENT_XML = "xml";
    static final String ELEMENT_IBB = "ibb";
    static final String ELEMENT_SIPUB = "sipub";
    static final String ELEMENT_JINGLE = "jingle";
    private static final String ATTRIBUTE_STREAM_ID = "streamId";
    private static final String ATTRIBUTE_SID = "sid";
    static final String ATTRIBUTE_VERSION = "version";

    protected void parseHeadersAndData(XmlPullParser parser, String elementName, AbstractHttpOverXmpp.AbstractBody body) throws Exception {
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals(ELEMENT_HEADERS)) {
                    HeadersExtension headersExtension = this.parseHeaders(parser);
                    body.setHeaders(headersExtension);
                    continue;
                }
                if (parser.getName().endsWith(ELEMENT_DATA)) {
                    AbstractHttpOverXmpp.Data data = this.parseData(parser);
                    body.setData(data);
                    continue;
                }
                throw new IllegalArgumentException("unexpected tag:" + parser.getName() + "'");
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
    }

    private HeadersExtension parseHeaders(XmlPullParser parser) throws Exception {
        HeaderProvider provider = new HeaderProvider();
        HashSet<Header> set = new HashSet<Header>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals(ELEMENT_HEADER)) continue;
                Header header = (Header)provider.parseExtension(parser);
                set.add(header);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(ELEMENT_HEADERS)) continue;
            done = true;
        }
        return new HeadersExtension(set);
    }

    private AbstractHttpOverXmpp.Data parseData(XmlPullParser parser) throws Exception {
        AbstractHttpOverXmpp.DataChild child = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals(ELEMENT_TEXT)) {
                    child = this.parseText(parser);
                    continue;
                }
                if (parser.getName().equals(ELEMENT_BASE_64)) {
                    child = this.parseBase64(parser);
                    continue;
                }
                if (parser.getName().equals(ELEMENT_CHUNKED_BASE_64)) {
                    child = this.parseChunkedBase64(parser);
                    continue;
                }
                if (parser.getName().equals(ELEMENT_XML)) {
                    child = this.parseXml(parser);
                    continue;
                }
                if (parser.getName().equals(ELEMENT_IBB)) {
                    child = this.parseIbb(parser);
                    continue;
                }
                if (parser.getName().equals(ELEMENT_SIPUB)) {
                    throw new UnsupportedOperationException("sipub is not supported yet");
                }
                if (parser.getName().equals(ELEMENT_JINGLE)) {
                    throw new UnsupportedOperationException("jingle is not supported yet");
                }
                throw new IllegalArgumentException("unsupported child tag: " + parser.getName());
            }
            if (eventType != 3 || !parser.getName().equals(ELEMENT_DATA)) continue;
            done = true;
        }
        AbstractHttpOverXmpp.Data data = new AbstractHttpOverXmpp.Data(child);
        return data;
    }

    private AbstractHttpOverXmpp.Text parseText(XmlPullParser parser) throws Exception {
        String text = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3) {
                if (parser.getName().equals(ELEMENT_TEXT)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + parser.getName());
            }
            if (eventType == 4) {
                text = parser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + eventType);
        }
        return new AbstractHttpOverXmpp.Text(text);
    }

    private AbstractHttpOverXmpp.Xml parseXml(XmlPullParser parser) throws Exception {
        StringBuilder builder = new StringBuilder();
        boolean done = false;
        boolean startClosed = true;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3 && parser.getName().equals(ELEMENT_XML)) {
                done = true;
                continue;
            }
            if (eventType == 2) {
                if (!startClosed) {
                    builder.append('>');
                }
                builder.append('<');
                builder.append(parser.getName());
                this.appendXmlAttributes(parser, builder);
                startClosed = false;
                continue;
            }
            if (eventType == 3) {
                if (startClosed) {
                    builder.append("</");
                    builder.append(parser.getName());
                    builder.append('>');
                    continue;
                }
                builder.append("/>");
                startClosed = true;
                continue;
            }
            if (eventType == 4) {
                if (!startClosed) {
                    builder.append('>');
                    startClosed = true;
                }
                builder.append(StringUtils.escapeForXML((String)parser.getText()));
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + eventType);
        }
        return new AbstractHttpOverXmpp.Xml(builder.toString());
    }

    private void appendXmlAttributes(XmlPullParser parser, StringBuilder builder) throws Exception {
        int count = parser.getAttributeCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                builder.append(' ');
                builder.append(parser.getAttributeName(i));
                builder.append("=\"");
                builder.append(StringUtils.escapeForXML((String)parser.getAttributeValue(i)));
                builder.append('\"');
            }
        }
    }

    private AbstractHttpOverXmpp.Base64 parseBase64(XmlPullParser parser) throws Exception {
        String text = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3) {
                if (parser.getName().equals(ELEMENT_BASE_64)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + parser.getName());
            }
            if (eventType == 4) {
                text = parser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + eventType);
        }
        return new AbstractHttpOverXmpp.Base64(text);
    }

    private AbstractHttpOverXmpp.ChunkedBase64 parseChunkedBase64(XmlPullParser parser) throws Exception {
        String streamId = parser.getAttributeValue("", ATTRIBUTE_STREAM_ID);
        AbstractHttpOverXmpp.ChunkedBase64 child = new AbstractHttpOverXmpp.ChunkedBase64(streamId);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3) {
                if (parser.getName().equals(ELEMENT_CHUNKED_BASE_64)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + parser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + eventType);
        }
        return child;
    }

    private AbstractHttpOverXmpp.Ibb parseIbb(XmlPullParser parser) throws Exception {
        String sid = parser.getAttributeValue("", ATTRIBUTE_SID);
        AbstractHttpOverXmpp.Ibb child = new AbstractHttpOverXmpp.Ibb(sid);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3) {
                if (parser.getName().equals(ELEMENT_IBB)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + parser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + eventType);
        }
        return child;
    }
}

