/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.packet;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.hoxt.packet.HttpMethod;

public class HttpOverXmppReq
extends AbstractHttpOverXmpp {
    private Req req;

    public String getChildElementXML() {
        return this.req.toXML();
    }

    public Req getReq() {
        return this.req;
    }

    public void setReq(Req req) {
        this.req = req;
    }

    public static class Req
    extends AbstractHttpOverXmpp.AbstractBody {
        private HttpMethod method;
        private String resource;
        private int maxChunkSize = 0;
        private boolean sipub = true;
        private boolean ibb = true;
        private boolean jingle = true;

        public Req(HttpMethod method, String resource) {
            this.method = method;
            this.resource = resource;
        }

        @Override
        protected String getStartTag() {
            StringBuilder builder = new StringBuilder();
            builder.append("<req");
            builder.append(" ");
            builder.append("xmlns='").append("urn:xmpp:http").append("'");
            builder.append(" ");
            builder.append("method='").append(this.method.toString()).append("'");
            builder.append(" ");
            builder.append("resource='").append(StringUtils.escapeForXML((String)this.resource)).append("'");
            builder.append(" ");
            builder.append("version='").append(StringUtils.escapeForXML((String)this.version)).append("'");
            if (this.maxChunkSize != 0) {
                builder.append(" ");
                builder.append("maxChunkSize='").append(Integer.toString(this.maxChunkSize)).append("'");
            }
            builder.append(" ");
            builder.append("sipub='").append(Boolean.toString(this.sipub)).append("'");
            builder.append(" ");
            builder.append("ibb='").append(Boolean.toString(this.ibb)).append("'");
            builder.append(" ");
            builder.append("jingle='").append(Boolean.toString(this.jingle)).append("'");
            builder.append(">");
            return builder.toString();
        }

        @Override
        protected String getEndTag() {
            return "</req>";
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public String getResource() {
            return this.resource;
        }

        public int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        public void setMaxChunkSize(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
        }

        public boolean isSipub() {
            return this.sipub;
        }

        public void setSipub(boolean sipub) {
            this.sipub = sipub;
        }

        public boolean isIbb() {
            return this.ibb;
        }

        public void setIbb(boolean ibb) {
            this.ibb = ibb;
        }

        public boolean isJingle() {
            return this.jingle;
        }

        public void setJingle(boolean jingle) {
            this.jingle = jingle;
        }
    }
}

