/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class CarbonManager
extends Manager {
    private static Map<XMPPConnection, CarbonManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private volatile boolean enabled_state = false;

    private CarbonManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        sdm.addFeature("urn:xmpp:carbons:2");
        instances.put(connection, this);
    }

    public static synchronized CarbonManager getInstanceFor(XMPPConnection connection) {
        CarbonManager carbonManager = instances.get(connection);
        if (carbonManager == null) {
            carbonManager = new CarbonManager(connection);
        }
        return carbonManager;
    }

    private IQ carbonsEnabledIQ(final boolean new_state) {
        IQ setIQ = new IQ(){

            public String getChildElementXML() {
                return "<" + (new_state ? "enable" : "disable") + " xmlns='" + "urn:xmpp:carbons:2" + "'/>";
            }
        };
        setIQ.setType(IQ.Type.SET);
        return setIQ;
    }

    public boolean isSupportedByServer() throws XMPPException, SmackException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).supportsFeature(this.connection().getServiceName(), "urn:xmpp:carbons:2");
    }

    public void sendCarbonsEnabled(final boolean new_state) throws SmackException.NotConnectedException {
        IQ setIQ = this.carbonsEnabledIQ(new_state);
        this.connection().addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                IQ result = (IQ)packet;
                if (result.getType() == IQ.Type.RESULT) {
                    CarbonManager.this.enabled_state = new_state;
                }
                CarbonManager.this.connection().removePacketListener((PacketListener)this);
            }
        }, (PacketFilter)new IQReplyFilter(setIQ, this.connection()));
        this.connection().sendPacket((Packet)setIQ);
    }

    public synchronized void setCarbonsEnabled(boolean new_state) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.enabled_state == new_state) {
            return;
        }
        IQ setIQ = this.carbonsEnabledIQ(new_state);
        this.connection().createPacketCollectorAndSend(setIQ).nextResultOrThrow();
        this.enabled_state = new_state;
    }

    public void enableCarbons() throws XMPPException, SmackException {
        this.setCarbonsEnabled(true);
    }

    public void disableCarbons() throws XMPPException, SmackException {
        this.setCarbonsEnabled(false);
    }

    public boolean getCarbonsEnabled() {
        return this.enabled_state;
    }

    public static CarbonExtension getCarbon(Message msg) {
        CarbonExtension cc = (CarbonExtension)msg.getExtension("received", "urn:xmpp:carbons:2");
        if (cc == null) {
            cc = (CarbonExtension)msg.getExtension("sent", "urn:xmpp:carbons:2");
        }
        return cc;
    }

    public static void disableCarbons(Message msg) {
        msg.addExtension((PacketExtension)new CarbonExtension.Private());
    }

    static {
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                CarbonManager.getInstanceFor(connection);
            }
        });
    }
}

