/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.util;

public final class ByteUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= left[i] == right[i];
            --i;
        }
        return result;
    }

    public static boolean equals(byte[][] left, byte[][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= ByteUtils.equals(left[i], right[i]);
            --i;
        }
        return result;
    }

    public static boolean equals(byte[][][] left, byte[][][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            if (left[i].length != right[i].length) {
                return false;
            }
            int j = left[i].length - 1;
            while (j >= 0) {
                result &= ByteUtils.equals(left[i][j], right[i][j]);
                --j;
            }
            --i;
        }
        return result;
    }

    public static int deepHashCode(byte[] array) {
        int result = 1;
        int i = 0;
        while (i < array.length) {
            result = 31 * result + array[i];
            ++i;
        }
        return result;
    }

    public static int deepHashCode(byte[][] array) {
        int result = 1;
        int i = 0;
        while (i < array.length) {
            result = 31 * result + ByteUtils.deepHashCode(array[i]);
            ++i;
        }
        return result;
    }

    public static int deepHashCode(byte[][][] array) {
        int result = 1;
        int i = 0;
        while (i < array.length) {
            result = 31 * result + ByteUtils.deepHashCode(array[i]);
            ++i;
        }
        return result;
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] result = new byte[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static byte[] fromHexString(String s) {
        char[] rawChars = s.toUpperCase().toCharArray();
        int hexChars = 0;
        int i = 0;
        while (i < rawChars.length) {
            if (rawChars[i] >= '0' && rawChars[i] <= '9' || rawChars[i] >= 'A' && rawChars[i] <= 'F') {
                ++hexChars;
            }
            ++i;
        }
        byte[] byteString = new byte[hexChars + 1 >> 1];
        int pos = hexChars & 1;
        int i2 = 0;
        while (i2 < rawChars.length) {
            block8: {
                block7: {
                    block6: {
                        if (rawChars[i2] < '0' || rawChars[i2] > '9') break block6;
                        int n = pos >> 1;
                        byteString[n] = (byte)(byteString[n] << 4);
                        int n2 = pos >> 1;
                        byteString[n2] = (byte)(byteString[n2] | rawChars[i2] - 48);
                        break block7;
                    }
                    if (rawChars[i2] < 'A' || rawChars[i2] > 'F') break block8;
                    int n = pos >> 1;
                    byteString[n] = (byte)(byteString[n] << 4);
                    int n3 = pos >> 1;
                    byteString[n3] = (byte)(byteString[n3] | rawChars[i2] - 65 + 10);
                }
                ++pos;
            }
            ++i2;
        }
        return byteString;
    }

    public static String toHexString(byte[] input) {
        String result = "";
        int i = 0;
        while (i < input.length) {
            result = result + HEX_CHARS[input[i] >>> 4 & 0xF];
            result = result + HEX_CHARS[input[i] & 0xF];
            ++i;
        }
        return result;
    }

    public static String toHexString(byte[] input, String prefix, String seperator) {
        String result = new String(prefix);
        int i = 0;
        while (i < input.length) {
            result = result + HEX_CHARS[input[i] >>> 4 & 0xF];
            result = result + HEX_CHARS[input[i] & 0xF];
            if (i < input.length - 1) {
                result = result + seperator;
            }
            ++i;
        }
        return result;
    }

    public static String toBinaryString(byte[] input) {
        String result = "";
        int i = 0;
        while (i < input.length) {
            byte e = input[i];
            int ii = 0;
            while (ii < 8) {
                int b = e >>> ii & 1;
                result = result + b;
                ++ii;
            }
            if (i != input.length - 1) {
                result = result + " ";
            }
            ++i;
        }
        return result;
    }

    public static byte[] xor(byte[] x1, byte[] x2) {
        byte[] out = new byte[x1.length];
        int i = x1.length - 1;
        while (i >= 0) {
            out[i] = (byte)(x1[i] ^ x2[i]);
            --i;
        }
        return out;
    }

    public static byte[] concatenate(byte[] x1, byte[] x2) {
        byte[] result = new byte[x1.length + x2.length];
        System.arraycopy(x1, 0, result, 0, x1.length);
        System.arraycopy(x2, 0, result, x1.length, x2.length);
        return result;
    }

    public static byte[] concatenate(byte[][] array) {
        int rowLength = array[0].length;
        byte[] result = new byte[array.length * rowLength];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            System.arraycopy(array[i], 0, result, index, rowLength);
            index += rowLength;
            ++i;
        }
        return result;
    }

    public static byte[][] split(byte[] input, int index) throws ArrayIndexOutOfBoundsException {
        if (index > input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] result = new byte[][]{new byte[index], new byte[input.length - index]};
        System.arraycopy(input, 0, result[0], 0, index);
        System.arraycopy(input, index, result[1], 0, input.length - index);
        return result;
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static byte[] subArray(byte[] input, int start) {
        return ByteUtils.subArray(input, start, input.length);
    }

    public static char[] toCharArray(byte[] input) {
        char[] result = new char[input.length];
        int i = 0;
        while (i < input.length) {
            result[i] = (char)input[i];
            ++i;
        }
        return result;
    }
}

