/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.beanlib.CollectionPropertyName;
import net.sf.beanlib.ProtectedSetterMethodCollector;
import net.sf.beanlib.api.BeanMethodCollector;
import net.sf.beanlib.api.DetailedBeanPopulatable;
import net.sf.beanlib.hibernate.HibernateBeanReplicator;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.hibernate3.Hibernate3BeanReplicator;
import net.sf.beanlib.hibernate3.Hibernate3DtoPopulator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate3DtoCopier {
    private String applicationPackagePrefix = "#";

    private Hibernate3DtoCopier() {
    }

    protected Hibernate3BeanReplicator createHibernateBeanReplicator() {
        return new Hibernate3BeanReplicator();
    }

    protected Hibernate3DtoCopier init(String applicationPackagePrefix, Class applicationSampleClass) {
        String thisPackageName;
        this.applicationPackagePrefix = applicationPackagePrefix;
        if (applicationSampleClass != null && !(thisPackageName = ClassUtils.getPackageName((Class)applicationSampleClass)).startsWith(applicationPackagePrefix)) {
            throw new IllegalStateException("The specified application package prefix " + applicationPackagePrefix + " is not consistent with the given sample application class " + applicationSampleClass);
        }
        return this;
    }

    public <T> T hibernate2dtoFully(T entityBean) {
        return entityBean == null ? null : (T)this.createHibernateBeanReplicator().initBeanPopulatable(new Hibernate3DtoPopulator().init(this)).copy(entityBean);
    }

    public List hibernate2dtoFully(Collection hibernateBeans) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList list = new ArrayList(hibernateBeans.size());
        HibernateBeanReplicator replicator = this.createHibernateBeanReplicator().initBeanPopulatable(new Hibernate3DtoPopulator().init(this));
        for (Object obj : hibernateBeans) {
            list.add(replicator.deepCopy(obj));
        }
        return list;
    }

    public <T> T hibernate2dto(T entityBean) {
        return (T)this.hibernate2dto(entityBean.getClass(), entityBean);
    }

    public <E, T> E hibernate2dto(Class<E> targetEntityType, T entityBean) {
        if (entityBean == null) {
            return null;
        }
        return this.copy(targetEntityType, entityBean, ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    public <T> T hibernate2dto(T entityBean, Class[] interestedEntityTypes, CollectionPropertyName[] collectionPropertyNames) {
        return (T)this.hibernate2dto(entityBean.getClass(), entityBean, interestedEntityTypes, collectionPropertyNames);
    }

    public <E, T> E hibernate2dto(Class<E> targetEntityType, T entityBean, Class[] interestedEntityTypes, CollectionPropertyName[] collectionPropertyNames) {
        if (entityBean == null) {
            return null;
        }
        return this.copy(targetEntityType, entityBean, interestedEntityTypes, collectionPropertyNames);
    }

    public List hibernate2dto(Collection hibernateBeans) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(hibernateBeans.size());
        for (Object entityBean : hibernateBeans) {
            Object to = this.copy(entityBean, ArrayUtils.EMPTY_CLASS_ARRAY);
            list.add(to);
        }
        return list;
    }

    public <E> List<E> hibernate2dto(Class<E> targetEntityType, Collection hibernateBeans, Class[] interestedEntityTypes, CollectionPropertyName[] collectionPropertyNameArray) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList<E> list = new ArrayList<E>(hibernateBeans.size());
        for (Object entityBean : hibernateBeans) {
            E to = this.copy(targetEntityType, entityBean, interestedEntityTypes, collectionPropertyNameArray);
            list.add(to);
        }
        return list;
    }

    private Object copy(Object from, Class[] entityBeanClassArray) {
        return this.copy(from.getClass(), from, entityBeanClassArray, CollectionPropertyName.EMPTY_ARRAY);
    }

    private <E> E copy(Class<E> targetEntityType, Object from, Class[] entityBeanClassArray) {
        return this.copy(targetEntityType, from, entityBeanClassArray, CollectionPropertyName.EMPTY_ARRAY);
    }

    private <E> E copy(Class<E> targetEntityType, Object from, Class[] entityBeanClassArray, CollectionPropertyName[] collectionPropertyNameArray) {
        Hibernate3BeanReplicator replicator = this.createHibernateBeanReplicator();
        Set<Class> entityBeanClassSet = null;
        if (entityBeanClassArray != null) {
            entityBeanClassSet = entityBeanClassArray.length == 0 ? Collections.emptySet() : new HashSet<Class>(Arrays.asList(entityBeanClassArray));
            replicator.initEntityBeanClassSet(entityBeanClassSet);
        }
        Set<CollectionPropertyName> collectionPropertyNameSet = null;
        if (collectionPropertyNameArray != null) {
            collectionPropertyNameSet = collectionPropertyNameArray.length == 0 ? Collections.emptySet() : new HashSet<CollectionPropertyName>(Arrays.asList(collectionPropertyNameArray));
            replicator.initCollectionPropertyNameSet(collectionPropertyNameSet);
        }
        Hibernate3DtoPopulator beanPopulatable = new Hibernate3DtoPopulator(entityBeanClassSet, collectionPropertyNameSet).init(this);
        HibernateBeanReplicator beanReplicator = this.createHibernateBeanReplicator().initBeanPopulatable(beanPopulatable).initCollectionPropertyNameSet(collectionPropertyNameSet).initDetailedBeanPopulatable(DetailedBeanPopulatable.ALWAYS_POPULATE).initEntityBeanClassSet(entityBeanClassSet).initSetterMethodCollector((BeanMethodCollector)ProtectedSetterMethodCollector.inst);
        return (E)beanReplicator.copy(from, UnEnhancer.unenhance(targetEntityType));
    }

    public boolean isApplicationClass(Class c) {
        if (c == null) {
            return false;
        }
        String pn = ClassUtils.getPackageName((Class)c);
        return pn.startsWith(this.applicationPackagePrefix);
    }

    public static class Factory {
        public static Hibernate3DtoCopier getInstance(String applicationPackagePrefix, Class applicationSampleClass) {
            return new Hibernate3DtoCopier().init(applicationPackagePrefix, applicationSampleClass);
        }

        public static Hibernate3DtoCopier getInstance(String applicationPackagePrefix) {
            return new Hibernate3DtoCopier().init(applicationPackagePrefix, null);
        }
    }
}

