/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.beanlib.BeanPopulator;
import net.sf.beanlib.ProtectedSetterMethodCollector;
import net.sf.beanlib.api.BeanMethodCollector;
import net.sf.beanlib.api.BeanMethodFinder;
import net.sf.beanlib.api.BeanPopulatable;
import net.sf.beanlib.api.BeanSourceHandler;
import net.sf.beanlib.api.DetailedBeanPopulatable;
import net.sf.beanlib.api.Transformable;
import net.sf.beanlib.hibernate.BeanlibHibernateException;
import net.sf.beanlib.hibernate.CustomHibernateBeanTransformable;
import net.sf.beanlib.hibernate.HibernateBeanTransformable;
import net.sf.beanlib.hibernate.HibernateBeanTransformableSpi;
import net.sf.beanlib.utils.BlobUtils;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateBeanTransformer
implements HibernateBeanTransformableSpi {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<Object, Object> clonedMap = new IdentityHashMap<Object, Object>();
    private DetailedBeanPopulatable detailedBeanPopulatable;
    private BeanPopulatable beanPopulatable;
    private BeanSourceHandler beanSourceHandler;
    private BeanMethodFinder readerMethodFinder;
    private BeanMethodCollector setterMethodCollector = ProtectedSetterMethodCollector.inst;
    private CustomHibernateBeanTransformable customTransformer = CustomHibernateBeanTransformable.NO_OP;
    private boolean debug;

    @Override
    public abstract void hibernateInitialize(Object var1);

    @Override
    public abstract Blob hibernateCreateBlob(byte[] var1);

    @Override
    public final void reset() {
        this.clonedMap = new IdentityHashMap<Object, Object>();
    }

    public final <T> T transform(Object from, Class<T> toClass) {
        try {
            if (this.customTransformer.isTransformable(from, toClass, this)) {
                return (T)this.customTransformer.transform(from, toClass);
            }
            return this.replicate(from, toClass);
        }
        catch (InstantiationException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (SQLException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (IOException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (SecurityException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibHibernateException(e);
        }
    }

    private Object replicate(Object from) throws SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException, NoSuchMethodException {
        if (from == null) {
            return null;
        }
        return this.replicate(from, from.getClass());
    }

    private <T> T replicate(Object from, Class<T> toClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException, SecurityException, NoSuchMethodException {
        if (from == null) {
            return null;
        }
        if (toClass.isPrimitive()) {
            return (T)from;
        }
        Class<?> fromClass = from.getClass();
        if (from instanceof Collection) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            return (T)this.replicateCollection((Collection)from);
        }
        if (from instanceof Map) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            return (T)this.replicateMap((Map)from);
        }
        if (from instanceof Timestamp) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            Timestamp ts = (Timestamp)from;
            return (T)new Timestamp(ts.getTime());
        }
        if (from instanceof Date) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            Date date = (Date)from;
            return (T)new Date(date.getTime());
        }
        Object to = this.clonedMap.get(from);
        if (to != null) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            return (T)to;
        }
        if (fromClass.isArray()) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            return (T)this.replicateArray(from);
        }
        String fromPackageName = ClassUtils.getPackageName(from.getClass());
        if (fromPackageName.startsWith("java.")) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            return (T)from;
        }
        if (fromPackageName.startsWith("net.sf.cglib.")) {
            return null;
        }
        if (from instanceof Blob) {
            if (!toClass.isAssignableFrom(fromClass)) {
                return null;
            }
            Blob fromBlob = (Blob)from;
            to = this.replicateBlob(fromBlob);
            this.clonedMap.put(from, to);
            return (T)to;
        }
        to = this.replicateApplicationObject(from, toClass);
        return (T)to;
    }

    private <T> T replicateApplicationObject(Object from, Class<T> toClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        T to = this.createToInstance(this.chooseClass(from.getClass(), toClass));
        this.clonedMap.put(from, to);
        this.populate(from, to);
        return to;
    }

    private <T> Class<T> chooseClass(Class<?> fromClass, Class<T> toClass) {
        return toClass.isAssignableFrom(fromClass) ? fromClass : toClass;
    }

    private Object replicateArray(Object from) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException, SecurityException, NoSuchMethodException {
        Class<?> fromClass = from.getClass();
        Class<?> fromComponentType = fromClass.getComponentType();
        if (fromComponentType.isPrimitive()) {
            int len = Array.getLength(from);
            Object to = Array.newInstance(fromComponentType, len);
            System.arraycopy(from, 0, to, 0, len);
            this.clonedMap.put(from, to);
            return to;
        }
        int len = Array.getLength(from);
        Object to = Array.newInstance(fromComponentType, len);
        this.clonedMap.put(from, to);
        Object[] fromArray = (Object[])from;
        Object[] toArray = (Object[])to;
        for (int i = fromArray.length - 1; i >= 0; --i) {
            Object toElement;
            Object fromElement = fromArray[i];
            toArray[i] = toElement = this.replicate(fromElement);
        }
        return toArray;
    }

    private Collection<?> replicateCollection(Collection<?> from) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException, SecurityException, NoSuchMethodException {
        Collection<Object> toCollection = this.getToCollectionCloned(from);
        if (toCollection == null) {
            toCollection = this.createToCollection(from);
            this.clonedMap.put(from, toCollection);
            Collection<?> fromCollection = from;
            this.hibernateInitialize(fromCollection);
            for (Object fromMember : fromCollection) {
                Object toMember = this.replicate(fromMember);
                toCollection.add(toMember);
            }
        }
        return toCollection;
    }

    private Collection<Object> getToCollectionCloned(Collection<?> from) {
        return (Collection)this.clonedMap.get(from);
    }

    private Map<?, ?> replicateMap(Map<?, ?> from) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException, SecurityException, NoSuchMethodException {
        Map<Object, Object> toMap = this.getToMapCloned(from);
        if (toMap != null) {
            return toMap.size() == 0 ? null : toMap;
        }
        toMap = this.createToMap(from);
        this.clonedMap.put(from, toMap);
        Map<?, ?> fromMap = from;
        this.hibernateInitialize(fromMap);
        for (Map.Entry<?, ?> fromEntry : fromMap.entrySet()) {
            Object fromKey = fromEntry.getKey();
            Object fromValue = fromEntry.getValue();
            Object toKey = this.replicate(fromKey);
            Object toValue = this.replicate(fromValue);
            toMap.put(toKey, toValue);
        }
        return toMap.size() == 0 ? null : toMap;
    }

    private Map<Object, Object> getToMapCloned(Map<?, ?> from) {
        return (Map)this.clonedMap.get(from);
    }

    private void populate(Object fromMember, Object toMember) {
        new BeanPopulator(fromMember, toMember).initBeanPopulatable(this.beanPopulatable).initBeanSourceHandler(this.beanSourceHandler).initDebug(this.debug).initDetailedBeanPopulatable(this.detailedBeanPopulatable).initReaderMethodFinder(this.readerMethodFinder).initSetterMethodCollector(this.setterMethodCollector).initTransformer((Transformable)this).populate();
    }

    private Blob replicateBlob(Blob fromBlob) {
        byte[] byteArray = BlobUtils.inst.toByteArray(fromBlob);
        return this.hibernateCreateBlob(byteArray);
    }

    private Comparator<Object> createToComparator(SortedMap fromSortedMap) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        Comparator fromComparator = fromSortedMap.comparator();
        Comparator toComparator = fromComparator == null ? null : this.replicateApplicationObject(fromComparator, Comparator.class);
        return toComparator;
    }

    private Comparator createToComparator(SortedSet fromSortedSet) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        Comparator fromComparator = fromSortedSet.comparator();
        Comparator toComparator = fromComparator == null ? null : this.replicateApplicationObject(fromComparator, Comparator.class);
        return toComparator;
    }

    private Collection<Object> createToCollection(Collection<?> from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        Class<?> fromClass = from.getClass();
        if (this.isJavaPackage(fromClass)) {
            SortedSet fromSortedSet;
            Comparator toComparator;
            if (from instanceof SortedSet && (toComparator = this.createToComparator(fromSortedSet = (SortedSet)from)) != null) {
                return this.createToSortedSetWithComparator(fromSortedSet, toComparator);
            }
            return this.createToInstanceAsCollection(from);
        }
        if (from instanceof SortedSet) {
            SortedSet fromSortedSet = (SortedSet)from;
            Comparator toComparator = this.createToComparator(fromSortedSet);
            return new TreeSet<Object>(toComparator);
        }
        if (from instanceof Set) {
            return new HashSet<Object>();
        }
        if (from instanceof List) {
            return new ArrayList<Object>(from.size());
        }
        this.log.warn((Object)("Don't know what collection object:" + fromClass + ", so assume List."));
        return new ArrayList<Object>(from.size());
    }

    private Collection<Object> createToInstanceAsCollection(Collection<?> from) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        return (Collection)this.createToInstance(from);
    }

    private SortedMap<Object, Object> createToSortedMapWithComparator(SortedMap from, Comparator comparator) throws NoSuchMethodException, SecurityException {
        return (SortedMap)this.createToInstanceWithComparator(from, comparator);
    }

    private SortedSet<Object> createToSortedSetWithComparator(SortedSet from, Comparator comparator) throws NoSuchMethodException, SecurityException {
        return (SortedSet)this.createToInstanceWithComparator(from, comparator);
    }

    private Map<Object, Object> createToMap(Map<?, ?> from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        Class<?> fromClass = from.getClass();
        if (this.isJavaPackage(fromClass)) {
            SortedMap fromSortedMap;
            Comparator<Object> toComparator;
            if (from instanceof SortedMap && (toComparator = this.createToComparator(fromSortedMap = (SortedMap)from)) != null) {
                return this.createToSortedMapWithComparator(fromSortedMap, toComparator);
            }
            return this.createToInstanceAsMap(from);
        }
        if (from instanceof SortedMap) {
            SortedMap fromSortedMap = (SortedMap)from;
            Comparator<Object> toComparator = this.createToComparator(fromSortedMap);
            return new TreeMap<Object, Object>(toComparator);
        }
        return new HashMap<Object, Object>();
    }

    private Map<Object, Object> createToInstanceAsMap(Map<?, ?> from) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        return (Map)this.createToInstance(from);
    }

    private boolean isJavaPackage(Class c) {
        Package p = c.getPackage();
        return p != null && p.getName().startsWith("java.");
    }

    private Object createToInstance(Object from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.createToInstance(from.getClass());
    }

    private <T> T createToInstance(Class<T> fromClass) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        Class<T> toClass = fromClass;
        if (Enhancer.isEnhanced(toClass)) {
            toClass = toClass.getSuperclass();
        }
        return (T)this.newInstanceAsPrivileged(toClass);
    }

    private Object createToInstanceWithComparator(Object from, Comparator comparator) throws SecurityException, NoSuchMethodException {
        return this.createToInstanceWithComparator(from.getClass(), comparator);
    }

    private <T> T createToInstanceWithComparator(Class<T> fromClass, Comparator comparator) throws SecurityException, NoSuchMethodException {
        Class<T> toClass = fromClass;
        if (Enhancer.isEnhanced(toClass)) {
            toClass = toClass.getSuperclass();
        }
        return (T)this.newInstanceWithComparatorAsPrivileged(toClass, comparator);
    }

    private Object newInstanceAsPrivileged(Class c) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        final Constructor constructor = c.getDeclaredConstructor(new Class[0]);
        if (Modifier.isPublic(constructor.getModifiers())) {
            return c.newInstance();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
                catch (IllegalAccessException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
                catch (InvocationTargetException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
                catch (InstantiationException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
            }
        });
    }

    private Object newInstanceWithComparatorAsPrivileged(Class c, final Comparator comparator) throws SecurityException, NoSuchMethodException {
        final Constructor constructor = c.getDeclaredConstructor(Comparator.class);
        if (Modifier.isPublic(constructor.getModifiers())) {
            try {
                return constructor.newInstance(comparator);
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"", (Throwable)e);
                throw new BeanlibHibernateException(e);
            }
            catch (InstantiationException e) {
                this.log.error((Object)"", (Throwable)e);
                throw new BeanlibHibernateException(e);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)"", (Throwable)e);
                throw new BeanlibHibernateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                this.log.error((Object)"", t);
                throw new BeanlibHibernateException(t);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(comparator);
                }
                catch (IllegalArgumentException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
                catch (IllegalAccessException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    HibernateBeanTransformer.this.log.error((Object)"", t);
                    throw new BeanlibHibernateException(t);
                }
                catch (InstantiationException e) {
                    HibernateBeanTransformer.this.log.error((Object)"", (Throwable)e);
                    throw new BeanlibHibernateException(e);
                }
            }
        });
    }

    @Override
    public final BeanPopulatable getBeanPopulatable() {
        return this.beanPopulatable;
    }

    @Override
    public final HibernateBeanTransformable initCustomTransformer(CustomHibernateBeanTransformable customTransformer) {
        this.customTransformer = customTransformer;
        return this;
    }

    @Override
    public final HibernateBeanTransformable initBeanPopulatable(BeanPopulatable beanPopulatable) {
        this.beanPopulatable = beanPopulatable;
        return this;
    }

    @Override
    public final BeanSourceHandler getBeanSourceHandler() {
        return this.beanSourceHandler;
    }

    @Override
    public final HibernateBeanTransformable initBeanSourceHandler(BeanSourceHandler beanSourceHandler) {
        this.beanSourceHandler = beanSourceHandler;
        return this;
    }

    @Override
    public final boolean isDebug() {
        return this.debug;
    }

    @Override
    public final HibernateBeanTransformable initDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public final DetailedBeanPopulatable getDetailedBeanPopulatable() {
        return this.detailedBeanPopulatable;
    }

    @Override
    public final HibernateBeanTransformable initDetailedBeanPopulatable(DetailedBeanPopulatable detailedBeanPopulatable) {
        this.detailedBeanPopulatable = detailedBeanPopulatable;
        return this;
    }

    @Override
    public final BeanMethodFinder getReaderMethodFinder() {
        return this.readerMethodFinder;
    }

    @Override
    public final HibernateBeanTransformable initReaderMethodFinder(BeanMethodFinder readerMethodFinder) {
        this.readerMethodFinder = readerMethodFinder;
        return this;
    }

    @Override
    public final BeanMethodCollector getSetterMethodCollector() {
        return this.setterMethodCollector;
    }

    @Override
    public final HibernateBeanTransformable initSetterMethodCollector(BeanMethodCollector setterMethodCollector) {
        this.setterMethodCollector = setterMethodCollector;
        return this;
    }

    @Override
    public Map getClonedMap() {
        return this.clonedMap;
    }

    @Override
    public CustomHibernateBeanTransformable getCustomTransformer() {
        return this.customTransformer;
    }
}

