/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim;

import java.util.List;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;

public class XHTMLManager {
    private static final String namespace = "http://jabber.org/protocol/xhtml-im";

    public static List<String> getBodies(Message message) {
        XHTMLExtension xhtmlExtension = (XHTMLExtension)message.getExtension("html", namespace);
        if (xhtmlExtension != null) {
            return xhtmlExtension.getBodies();
        }
        return null;
    }

    public static void addBody(Message message, String body) {
        XHTMLExtension xhtmlExtension = (XHTMLExtension)message.getExtension("html", namespace);
        if (xhtmlExtension == null) {
            xhtmlExtension = new XHTMLExtension();
            message.addExtension((PacketExtension)xhtmlExtension);
        }
        xhtmlExtension.addBody(body);
    }

    public static boolean isXHTMLMessage(Message message) {
        return message.getExtension("html", namespace) != null;
    }

    public static synchronized void setServiceEnabled(XMPPConnection connection, boolean enabled) {
        if (XHTMLManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor(connection).addFeature(namespace);
        } else {
            ServiceDiscoveryManager.getInstanceFor(connection).removeFeature(namespace);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        return ServiceDiscoveryManager.getInstanceFor(connection).includesFeature(namespace);
    }

    public static boolean isServiceEnabled(XMPPConnection connection, String userID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).supportsFeature(userID, namespace);
    }

    static {
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                XHTMLManager.setServiceEnabled(connection, true);
            }
        });
    }
}

