/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.rsa.RSAOAEPParameterSpec;
import de.flexiprovider.pki.AlgorithmIdentifier;
import java.io.IOException;

public class RSAOAEPParameters
extends AlgorithmParameters {
    private String md;
    static /* synthetic */ Class class$de$flexiprovider$core$rsa$RSAOAEPParameterSpec;

    public void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !(paramSpec instanceof RSAOAEPParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        this.md = ((RSAOAEPParameterSpec)paramSpec).getMD();
    }

    public void init(byte[] encParams) throws IOException {
        ASN1Sequence asn1Params = new ASN1Sequence(3);
        asn1Params.add(new AlgorithmIdentifier());
        asn1Params.add(new AlgorithmIdentifier());
        asn1Params.add(new AlgorithmIdentifier());
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1Params);
        }
        catch (ASN1Exception e) {
            throw new IOException("ASN1Exception: " + e.getMessage());
        }
        String mgf = ((AlgorithmIdentifier)((Object)asn1Params.get(1))).getAlgorithmOID().toString();
        if (!mgf.equals("1.2.840.113549.1.1.8")) {
            throw new IOException("unsupported parameters");
        }
        String pSource = ((AlgorithmIdentifier)((Object)asn1Params.get(2))).getAlgorithmOID().toString();
        if (!pSource.equals("1.2.840.113549.1.1.9")) {
            throw new IOException("unsupported parameters");
        }
        this.md = ((AlgorithmIdentifier)((Object)asn1Params.get(0))).getAlgorithmOID().toString();
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (format == null || !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() throws IOException {
        AlgorithmIdentifier pSourceIdentifier;
        AlgorithmIdentifier mgfIdentifier;
        AlgorithmIdentifier mdIdentifier;
        ASN1Sequence asn1Params = new ASN1Sequence(3);
        try {
            mdIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.md), (ASN1Type)new ASN1Null());
            mgfIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.8"), (ASN1Type)mdIdentifier);
            pSourceIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.9"), (ASN1Type)new ASN1OctetString());
        }
        catch (ASN1Exception e) {
            throw new IOException("ASN1Exception: " + e.getMessage());
        }
        asn1Params.add(mdIdentifier);
        asn1Params.add(mgfIdentifier);
        asn1Params.add(pSourceIdentifier);
        return ASN1Tools.derEncode((ASN1Type)asn1Params);
    }

    public byte[] getEncoded(String format) throws IOException {
        if (format == null || !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !paramSpec.isAssignableFrom(class$de$flexiprovider$core$rsa$RSAOAEPParameterSpec == null ? (class$de$flexiprovider$core$rsa$RSAOAEPParameterSpec = RSAOAEPParameters.class$("de.flexiprovider.core.rsa.RSAOAEPParameterSpec")) : class$de$flexiprovider$core$rsa$RSAOAEPParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new RSAOAEPParameterSpec(this.md);
    }

    public String toString() {
        String result = "RSA OAEP parameters:\n";
        result = result + "MD OID     : " + this.md + "\n";
        result = result + "MGF OID    : 1.2.840.113549.1.1.8\n";
        result = result + "PSource OID: 1.2.840.113549.1.1.9\n";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

