/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.core.desede.DESede;
import de.flexiprovider.core.desede.DESedeKeyFactory;
import de.flexiprovider.core.desede.DESedeKeySpec;
import de.flexiprovider.core.kdf.PBKDF1_PKCS12;
import de.flexiprovider.core.kdf.PBKDF1_PKCS12ParameterSpec;
import de.flexiprovider.core.pbe.PBEKey;
import de.flexiprovider.core.pbe.PBEParameterSpec;
import de.flexiprovider.core.pbe.PBES1;

public class PBEWithSHAAnd3_KeyTripleDES_CBC
extends PBES1 {
    public static final String OID = "1.2.840.113549.1.12.1.3";
    private SecretKeyFactory desKeyFactory;

    public PBEWithSHAAnd3_KeyTripleDES_CBC() {
        this.cipher = new DESede.DESede_CBC();
        try {
            this.cipher.setPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException nspe) {
            throw new RuntimeException("internal error");
        }
        this.desKeyFactory = new DESedeKeyFactory();
        this.kdf = new PBKDF1_PKCS12.SHA1();
    }

    public String getName() {
        return "PbeWithSHAAnd3_KeyTripleDES_CBC";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PBEKey) {
            return 112;
        }
        throw new InvalidKeyException("Unsupported key.");
    }

    public void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey desKey;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        byte[] salt = pbeParamSpec.getSalt();
        int iterationCount = pbeParamSpec.getIterationCount();
        PBKDF1_PKCS12ParameterSpec kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 1);
        this.kdf.init(pbeKey, kdfParams);
        byte[] desBytes = this.kdf.deriveKey(24);
        DESedeKeySpec desKeySpec = new DESedeKeySpec(desBytes);
        try {
            desKey = this.desKeyFactory.generateSecret(desKeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 2);
        this.kdf.init(pbeKey, kdfParams);
        byte[] ivBytes = this.kdf.deriveKey(8);
        ModeParameterSpec modeParams = new ModeParameterSpec(ivBytes);
        this.cipher.initEncrypt(desKey, modeParams, null, random);
    }

    public void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey desKey;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        byte[] salt = pbeParamSpec.getSalt();
        int iterationCount = pbeParamSpec.getIterationCount();
        PBKDF1_PKCS12ParameterSpec kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 1);
        this.kdf.init(pbeKey, kdfParams);
        byte[] desBytes = this.kdf.deriveKey(24);
        DESedeKeySpec desKeySpec = new DESedeKeySpec(desBytes);
        try {
            desKey = this.desKeyFactory.generateSecret(desKeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 2);
        this.kdf.init(pbeKey, kdfParams);
        byte[] ivBytes = this.kdf.deriveKey(8);
        ModeParameterSpec modeParams = new ModeParameterSpec(ivBytes);
        this.cipher.initDecrypt(desKey, modeParams, null);
    }
}

