/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.core.desede.DESede;
import de.flexiprovider.core.desede.DESedeKeyFactory;
import de.flexiprovider.core.desede.DESedeKeySpec;
import de.flexiprovider.core.kdf.PBKDF1;
import de.flexiprovider.core.pbe.PBEKey;
import de.flexiprovider.core.pbe.PBEParameterSpec;
import de.flexiprovider.core.pbe.PBES1;

public class PBEWithSHA1AndDES_CBC
extends PBES1 {
    public static final String OID = "1.2.840.113549.1.5.10";
    private SecretKeyFactory desKeyFactory;

    public PBEWithSHA1AndDES_CBC() {
        this.cipher = new DESede.DESede_CBC();
        try {
            this.cipher.setPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException nspe) {
            throw new RuntimeException("PKCS #5 padding not found");
        }
        this.desKeyFactory = new DESedeKeyFactory();
        this.kdf = new PBKDF1.SHA1();
    }

    public String getName() {
        return "PbeWithSHA1AndDES_CBC";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PBEKey) {
            return 56;
        }
        throw new InvalidKeyException("Unsupported key.");
    }

    public void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey desKey;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        this.kdf.init(pbeKey, pbeParamSpec);
        byte[] keyBytes = this.kdf.deriveKey(16);
        byte[] desBytes = new byte[24];
        System.arraycopy(keyBytes, 0, desBytes, 0, 8);
        System.arraycopy(keyBytes, 0, desBytes, 8, 8);
        System.arraycopy(keyBytes, 0, desBytes, 16, 8);
        DESedeKeySpec desKeySpec = new DESedeKeySpec(desBytes);
        try {
            desKey = this.desKeyFactory.generateSecret(desKeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        ModeParameterSpec modeParams = new ModeParameterSpec(keyBytes, 8, 8);
        this.cipher.initEncrypt(desKey, modeParams, null, random);
    }

    public void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey desKey;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        this.kdf.init(pbeKey, pbeParamSpec);
        byte[] keyBytes = this.kdf.deriveKey(16);
        byte[] desBytes = new byte[24];
        System.arraycopy(keyBytes, 0, desBytes, 0, 8);
        System.arraycopy(keyBytes, 0, desBytes, 8, 8);
        System.arraycopy(keyBytes, 0, desBytes, 16, 8);
        DESedeKeySpec desKeySpec = new DESedeKeySpec(desBytes);
        try {
            desKey = this.desKeyFactory.generateSecret(desKeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        ModeParameterSpec modeParams = new ModeParameterSpec(keyBytes, 8, 8);
        this.cipher.initDecrypt(desKey, modeParams, null);
    }
}

