/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.pbe.PBEParameterSpec;
import java.io.IOException;
import java.util.ArrayList;

public class PBEParameters
extends de.flexiprovider.core.pbe.interfaces.PBEParameters {
    private byte[] salt;
    private int iterationCount;
    static /* synthetic */ Class class$de$flexiprovider$core$pbe$PBEParameterSpec;

    public void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)paramSpec;
        this.salt = pbeParamSpec.getSalt();
        this.iterationCount = pbeParamSpec.getIterationCount();
    }

    public void init(byte[] enc) throws IOException {
        try {
            PBES1ASN1Parameters asn1params = new PBES1ASN1Parameters();
            ASN1Tools.derDecode(enc, (ASN1Type)asn1params);
            this.salt = asn1params.getSalt();
            this.iterationCount = asn1params.getIterationCount();
        }
        catch (ASN1Exception ae) {
            throw new IOException("ASN1Exception: " + ae.getMessage());
        }
    }

    public void init(byte[] enc, String format) throws IOException {
        if (format != null) {
            throw new IOException("Decoding format '" + format + "' not supported.");
        }
        this.init(enc);
    }

    public byte[] getEncoded() throws IOException {
        PBES1ASN1Parameters asn1pbeParams = new PBES1ASN1Parameters(this.salt, this.iterationCount);
        try {
            return ASN1Tools.derEncode((ASN1Type)asn1pbeParams);
        }
        catch (RuntimeException re) {
            throw new IOException(re.getMessage());
        }
    }

    public byte[] getEncoded(String format) throws IOException {
        if (format != null) {
            throw new IOException("Encoding format '" + format + "' not supported.");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(class$de$flexiprovider$core$pbe$PBEParameterSpec == null ? (class$de$flexiprovider$core$pbe$PBEParameterSpec = PBEParameters.class$("de.flexiprovider.core.pbe.PBEParameterSpec")) : class$de$flexiprovider$core$pbe$PBEParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new PBEParameterSpec(this.salt, this.iterationCount);
    }

    public String toString() {
        String result = "";
        result = result + "Salt           : " + ByteUtils.toHexString(this.salt);
        result = result + "iteration count: " + this.iterationCount;
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PBES1ASN1Parameters
    extends ASN1Sequence {
        private ASN1OctetString salt;
        private ASN1Integer iterationCount;

        public PBES1ASN1Parameters() {
            super(2);
            this.salt = new ASN1OctetString();
            this.iterationCount = new ASN1Integer();
            ((ArrayList)((Object)this)).add(this.salt);
            ((ArrayList)((Object)this)).add(this.iterationCount);
        }

        public PBES1ASN1Parameters(byte[] salt, int iterationCount) {
            super(2);
            this.salt = new ASN1OctetString(salt);
            this.iterationCount = new ASN1Integer(iterationCount);
            ((ArrayList)((Object)this)).add(this.salt);
            ((ArrayList)((Object)this)).add(this.iterationCount);
        }

        public int getIterationCount() {
            return ASN1Tools.getFlexiBigInt(this.iterationCount).intValue();
        }

        public byte[] getSalt() {
            return this.salt.getByteArray();
        }
    }
}

