/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.BigEndianConversions;

public final class SHA1
extends MessageDigest {
    public static final String ALG_NAME = "SHA1";
    public static final String ALG_NAME2 = "SHA";
    public static final String OID = "1.3.14.3.2.26";
    private byte[] buffer;
    private long count;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int[] w = new int[80];
    private static final int const1 = 1518500249;
    private static final int const2 = 1859775393;
    private static final int const3 = -1894007588;
    private static final int const4 = -899497514;
    private static final int SHA1_DIGEST_LENGTH = 20;

    public SHA1() {
        this.buffer = new byte[64];
        this.reset();
    }

    private synchronized void processBlock() {
        this.w[0] = BigEndianConversions.OS2IP(this.buffer, 0);
        this.w[1] = BigEndianConversions.OS2IP(this.buffer, 4);
        this.w[2] = BigEndianConversions.OS2IP(this.buffer, 8);
        this.w[3] = BigEndianConversions.OS2IP(this.buffer, 12);
        this.w[4] = BigEndianConversions.OS2IP(this.buffer, 16);
        this.w[5] = BigEndianConversions.OS2IP(this.buffer, 20);
        this.w[6] = BigEndianConversions.OS2IP(this.buffer, 24);
        this.w[7] = BigEndianConversions.OS2IP(this.buffer, 28);
        this.w[8] = BigEndianConversions.OS2IP(this.buffer, 32);
        this.w[9] = BigEndianConversions.OS2IP(this.buffer, 36);
        this.w[10] = BigEndianConversions.OS2IP(this.buffer, 40);
        this.w[11] = BigEndianConversions.OS2IP(this.buffer, 44);
        this.w[12] = BigEndianConversions.OS2IP(this.buffer, 48);
        this.w[13] = BigEndianConversions.OS2IP(this.buffer, 52);
        this.w[14] = BigEndianConversions.OS2IP(this.buffer, 56);
        this.w[15] = BigEndianConversions.OS2IP(this.buffer, 60);
        int i = 16;
        while (i < 80) {
            int register = this.w[i - 3] ^ this.w[i - 8] ^ this.w[i - 14] ^ this.w[i - 16];
            this.w[i] = register << 1 | register >>> 31;
            ++i;
        }
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[0];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[1];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[2];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[3];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[4];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[5];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[6];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[7];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[8];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[9];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[10];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[11];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[12];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[13];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[14];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[15];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[16];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[17];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[18];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[19];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[20];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[21];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[22];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[23];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[24];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[25];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[26];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[27];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[28];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[29];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[30];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[31];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[32];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[33];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[34];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[35];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[36];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[37];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[38];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[39];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[40];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[41];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[42];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[43];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[44];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[45];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[46];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[47];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[48];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[49];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[50];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[51];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[52];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[53];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[54];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[55];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[56];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[57];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[58];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[59];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[60];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[61];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[62];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[63];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[64];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[65];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[66];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[67];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[68];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[69];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[70];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[71];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[72];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[73];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[74];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[75];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[76];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[77];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[78];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[79];
        c = c << 30 | c >>> 2;
        this.h0 += a;
        this.h1 += b;
        this.h2 += c;
        this.h3 += d;
        this.h4 += e;
    }

    public synchronized byte[] digest() {
        this.pad();
        byte[] digestValue = new byte[20];
        BigEndianConversions.I2OSP(this.h0, digestValue, 0);
        BigEndianConversions.I2OSP(this.h1, digestValue, 4);
        BigEndianConversions.I2OSP(this.h2, digestValue, 8);
        BigEndianConversions.I2OSP(this.h3, digestValue, 12);
        BigEndianConversions.I2OSP(this.h4, digestValue, 16);
        this.reset();
        return digestValue;
    }

    public int getDigestLength() {
        return 20;
    }

    public void reset() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
        this.count = 0L;
    }

    public synchronized void update(byte[] input, int offset, int len) {
        int bufOffset = (int)this.count & 0x3F;
        while (len > 0) {
            int copyLen = 64 - bufOffset;
            copyLen = len > copyLen ? copyLen : len;
            System.arraycopy(input, offset, this.buffer, bufOffset, copyLen);
            len -= copyLen;
            offset += copyLen;
            this.count += (long)copyLen;
            bufOffset = bufOffset + copyLen & 0x3F;
            if (bufOffset != 0) continue;
            this.processBlock();
        }
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count & 0x3F] = input;
        if ((int)(this.count & 0x3FL) == 63) {
            this.processBlock();
        }
        ++this.count;
    }

    private void pad() {
        int i;
        long bitLength = this.count << 3;
        this.buffer[(int)this.count & 0x3F] = -128;
        ++this.count;
        if ((int)(this.count & 0x3FL) > 56) {
            i = (int)this.count & 0x3F;
            while (i < 64) {
                this.buffer[i] = 0;
                ++this.count;
                ++i;
            }
            this.processBlock();
        } else if ((int)(this.count & 0x3FL) == 0) {
            this.processBlock();
        }
        i = (int)this.count & 0x3F;
        while (i < 56) {
            this.buffer[i] = 0;
            ++i;
        }
        BigEndianConversions.I2OSP(bitLength, this.buffer, 56);
        this.processBlock();
    }
}

