/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mars;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.mars.MARSKey;
import de.flexiprovider.core.mars.MARSKeyGenParameterSpec;

public class MARSKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        MARSKeyGenParameterSpec marsParams;
        if (params == null) {
            marsParams = new MARSKeyGenParameterSpec();
        } else if (params instanceof MARSKeyGenParameterSpec) {
            marsParams = (MARSKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = marsParams.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        MARSKeyGenParameterSpec params = new MARSKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        MARSKeyGenParameterSpec defaultParams = new MARSKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize >> 3];
        this.random.nextBytes(keyBytes);
        return new MARSKey(keyBytes);
    }
}

