/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.PBKDF1_PKCS12ParameterSpec;

public abstract class PBKDF1_PKCS12
extends KeyDerivation {
    private MessageDigest md;
    private int v;
    private byte[] secret;
    private byte[] salt;
    private int iterationCount;
    private byte id;

    protected PBKDF1_PKCS12(MessageDigest md, int v) {
        this.md = md;
        this.v = v;
    }

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        this.secret = ByteUtils.clone(secret);
        if (!(params instanceof PBKDF1_PKCS12ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBKDF1_PKCS12ParameterSpec kdfParams = (PBKDF1_PKCS12ParameterSpec)params;
        this.salt = kdfParams.getSalt();
        this.iterationCount = kdfParams.getIterationCount();
        this.id = kdfParams.getID();
    }

    public byte[] deriveKey(int keySize) {
        byte[] mA;
        if (keySize < 0) {
            return null;
        }
        byte[] mD = new byte[64];
        int i = 0;
        while (i < mD.length) {
            mD[i] = this.id;
            ++i;
        }
        byte[] mP = this.augment(this.secret);
        byte[] mS = this.augment(this.salt);
        byte[] mI = ByteUtils.concatenate(mS, mP);
        byte[] outCut = new byte[keySize];
        int k = 1;
        do {
            this.md.update(mD);
            this.md.update(mI);
            mA = this.md.digest();
            int i2 = 1;
            while (i2 < this.iterationCount) {
                this.md.update(mA);
                mA = this.md.digest();
                ++i2;
            }
            if (keySize < mA.length) {
                System.arraycopy(mA, 0, outCut, 0, keySize);
                break;
            }
            if (keySize < k * mA.length || keySize == k * mA.length) {
                int rem = mA.length - (k * mA.length - keySize);
                System.arraycopy(mA, 0, outCut, (k - 1) * mA.length, rem);
                break;
            }
            System.arraycopy(mA, 0, outCut, (k - 1) * mA.length, mA.length);
            byte[] mB = this.augment(mA);
            FlexiBigInt b = new FlexiBigInt(mB);
            byte[] ij = new byte[64];
            byte[] modByte = new byte[65];
            byte[] one = new byte[]{1};
            System.arraycopy(one, 0, modByte, 0, 1);
            FlexiBigInt modulo = new FlexiBigInt(modByte);
            FlexiBigInt tmp = null;
            int j = 0;
            while (j < mI.length / 64) {
                System.arraycopy(mI, j << 6, ij, 0, 64);
                FlexiBigInt ivint = new FlexiBigInt(ij);
                tmp = b.add(ivint).add(FlexiBigInt.ONE).mod(modulo);
                byte[] tmp1 = tmp.toByteArray();
                int l = 0;
                while (l < 64) {
                    mI[(j << 6) + l] = tmp1.length + l >= 64 ? tmp1[tmp1.length + l - 64] : (byte)0;
                    ++l;
                }
                ++j;
            }
        } while ((++k - 1) * mA.length < keySize);
        return outCut;
    }

    private byte[] augment(byte[] in) {
        int n = in.length;
        int tmp = (n + this.v - 1) / this.v;
        int amount = this.v * tmp;
        int iter = amount / n;
        int rem = amount % n;
        byte[] result = new byte[amount];
        int i = 0;
        while (i < iter) {
            System.arraycopy(in, 0, result, i * n, n);
            ++i;
        }
        if (rem != 0) {
            System.arraycopy(in, 0, result, iter * n, rem);
        }
        return result;
    }

    public static final class SHA1
    extends PBKDF1_PKCS12 {
        public SHA1() {
            super(new de.flexiprovider.core.md.SHA1(), 64);
        }
    }

    public static final class MD5
    extends PBKDF1_PKCS12 {
        public MD5() {
            super(new de.flexiprovider.core.md.MD5(), 64);
        }
    }
}

