/*
 * Decompiled with CFR 0.152.
 */
package lombok.netbeans.agent;

import java.lang.instrument.Instrumentation;
import lombok.core.Agent;
import lombok.patcher.Hook;
import lombok.patcher.MethodTarget;
import lombok.patcher.ScriptManager;
import lombok.patcher.StackRequest;
import lombok.patcher.scripts.ScriptBuilder;

public class NetbeansPatcher
extends Agent {
    @Override
    public void runAgent(String agentArgs, Instrumentation instrumentation, boolean injected) throws Exception {
        NetbeansPatcher.registerPatchScripts(instrumentation, injected);
    }

    private static void registerPatchScripts(Instrumentation instrumentation, boolean reloadExistingClasses) {
        ScriptManager sm = new ScriptManager();
        sm.registerTransformer(instrumentation);
        NetbeansPatcher.patchNetbeansClassLoader(sm);
        NetbeansPatcher.patchNetbeansJavac(sm);
        NetbeansPatcher.patchNetbeansMissingPositionAwareness(sm);
        if (reloadExistingClasses) {
            sm.reloadClasses(instrumentation);
        }
    }

    private static void patchNetbeansClassLoader(ScriptManager sm) {
        sm.addScript(ScriptBuilder.exitEarly().transplant().request(StackRequest.PARAM1, StackRequest.PARAM2).target(new MethodTarget("org.netbeans.StandardModule$OneModuleClassLoader", "<init>")).decisionMethod(new Hook("lombok.netbeans.agent.PatchFixes", "addSelfToClassLoader", "void", "org.netbeans.Module", "java.util.List")).build());
        sm.addScript(ScriptBuilder.exitEarly().transplant().request(StackRequest.THIS, StackRequest.PARAM1).target(new MethodTarget("org.netbeans.ProxyClassLoader", "getResource")).decisionMethod(new Hook("lombok.netbeans.agent.PatchFixes", "getResource_decision", "boolean", "java.lang.ClassLoader", "java.lang.String")).valueMethod(new Hook("lombok.netbeans.agent.PatchFixes", "getResource_value", "java.net.URL", "java.lang.ClassLoader", "java.lang.String")).build());
        sm.addScript(ScriptBuilder.exitEarly().transplant().request(StackRequest.THIS, StackRequest.PARAM1).target(new MethodTarget("org.netbeans.ProxyClassLoader", "getResources")).decisionMethod(new Hook("lombok.netbeans.agent.PatchFixes", "getResources_decision", "boolean", "java.lang.ClassLoader", "java.lang.String")).valueMethod(new Hook("lombok.netbeans.agent.PatchFixes", "getResources_value", "java.util.Enumeration", "java.lang.ClassLoader", "java.lang.String")).build());
        sm.addScript(ScriptBuilder.exitEarly().transplant().target(new MethodTarget("org.netbeans.ProxyClassLoader", "loadClass")).request(StackRequest.THIS, StackRequest.PARAM1).decisionMethod(new Hook("lombok.netbeans.agent.PatchFixes", "loadClass_decision", "boolean", "java.lang.ClassLoader", "java.lang.String")).valueMethod(new Hook("lombok.netbeans.agent.PatchFixes", "loadClass_value", "java.lang.Class", "java.lang.ClassLoader", "java.lang.String")).build());
    }

    private static void patchNetbeansJavac(ScriptManager sm) {
        sm.addScript(ScriptBuilder.wrapReturnValue().request(StackRequest.THIS, StackRequest.PARAM1).transplant().target(new MethodTarget("com.sun.tools.javac.api.JavacTaskImpl", "setTaskListener")).wrapMethod(new Hook("lombok.netbeans.agent.PatchFixes", "fixContentOnSetTaskListener", "void", "com.sun.tools.javac.api.JavacTaskImpl", "com.sun.source.util.TaskListener")).build());
        sm.addScript(ScriptBuilder.wrapReturnValue().request(StackRequest.RETURN_VALUE, StackRequest.PARAM1).transplant().target(new MethodTarget("org.netbeans.modules.java.source.parsing.JavacParser", "createJavacTask", "com.sun.tools.javac.api.JavacTaskImpl", "org.netbeans.api.java.source.ClasspathInfo", "javax.tools.DiagnosticListener", "java.lang.String", "boolean", "com.sun.tools.javac.api.ClassNamesForFileOraculum", "com.sun.tools.javac.util.CancelService")).wrapMethod(new Hook("lombok.netbeans.agent.PatchFixes", "addTaskListenerWhenCallingJavac", "void", "com.sun.tools.javac.api.JavacTaskImpl", "org.netbeans.api.java.source.ClasspathInfo")).build());
    }

    private static void patchNetbeansMissingPositionAwareness(ScriptManager sm) {
        sm.addScript(ScriptBuilder.replaceMethodCall().target(new MethodTarget("org.netbeans.modules.java.editor.overridden.ComputeAnnotations", "createAnnotations")).methodToReplace(new Hook("com.sun.source.util.Trees", "getTree", "com.sun.source.tree.Tree", "javax.lang.model.element.Element")).replacementMethod(new Hook("lombok.netbeans.agent.PatchFixes", "returnNullForGeneratedNode", "com.sun.source.tree.Tree", "com.sun.source.util.Trees", "javax.lang.model.element.Element", "java.lang.Object")).requestExtra(StackRequest.PARAM1).transplant().build());
        sm.addScript(ScriptBuilder.replaceMethodCall().target(new MethodTarget("org.netbeans.modules.java.source.parsing.FindMethodRegionsVisitor", "visitMethod")).methodToReplace(new Hook("com.sun.source.util.SourcePositions", "getEndPosition", "long", "com.sun.source.tree.CompilationUnitTree", "com.sun.source.tree.Tree")).replacementMethod(new Hook("lombok.netbeans.agent.PatchFixes", "returnMinus1ForGeneratedNode", "long", "com.sun.source.util.SourcePositions", "com.sun.source.tree.CompilationUnitTree", "com.sun.source.tree.Tree")).transplant().build());
        sm.addScript(ScriptBuilder.wrapMethodCall().target(new MethodTarget("org.netbeans.modules.java.source.save.CasualDiff", "filterHidden")).methodToWrap(new Hook("java.lang.Iterable", "iterator", "java.util.Iterator", new String[0])).wrapMethod(new Hook("lombok.netbeans.agent.PatchFixes", "filterGenerated", "java.util.Iterator", "java.util.Iterator")).transplant().build());
    }
}

