/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.parameters;

import codec.asn1.ASN1ObjectIdentifier;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.exceptions.NoSuchBasisException;
import de.flexiprovider.common.exceptions.PolynomialIsNotIrreducibleException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurve;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.finitefields.GF2Polynomial;
import de.flexiprovider.common.math.finitefields.GF2nElement;
import de.flexiprovider.common.math.finitefields.GF2nONBElement;
import de.flexiprovider.common.math.finitefields.GF2nONBField;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialElement;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialField;
import de.flexiprovider.common.math.finitefields.GFPElement;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.common.util.StringUtils;

public abstract class CurveParams
implements AlgorithmParameterSpec {
    private ASN1ObjectIdentifier oid;
    FlexiBigInt q;
    EllipticCurve E;
    Point g;
    private FlexiBigInt r;
    private int k;

    protected CurveParams(String r, String k) {
        String s = StringUtils.filterSpaces(r);
        this.r = new FlexiBigInt(s, 16);
        s = StringUtils.filterSpaces(k);
        this.k = Integer.valueOf(s, 16);
    }

    protected CurveParams(String oid, String r, String k) {
        this.oid = new ASN1ObjectIdentifier(oid);
        String s = StringUtils.filterSpaces(r);
        this.r = new FlexiBigInt(s, 16);
        s = StringUtils.filterSpaces(k);
        this.k = Integer.valueOf(s, 16);
    }

    protected CurveParams(Point g, FlexiBigInt r, int k) {
        this.g = g;
        this.E = g.getE();
        this.q = this.E.getQ();
        this.r = r;
        this.k = k;
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public FlexiBigInt getQ() {
        return this.q;
    }

    public EllipticCurve getE() {
        return this.E;
    }

    public Point getG() {
        return (Point)this.g.clone();
    }

    public FlexiBigInt getR() {
        return this.r;
    }

    public int getK() {
        return this.k;
    }

    public int hashCode() {
        int oidHashCode = 0;
        int qHashCode = 0;
        int eHashCode = 0;
        int gHashCode = 0;
        int rHashCode = 0;
        int kHashCode = this.k;
        if (this.oid != null) {
            oidHashCode = this.oid.hashCode();
        }
        if (this.q != null) {
            qHashCode = this.q.hashCode();
        }
        if (this.E != null) {
            eHashCode = this.E.hashCode();
        }
        if (this.g != null) {
            gHashCode = this.g.hashCode();
        }
        if (this.r != null) {
            rHashCode = this.r.hashCode();
        }
        return oidHashCode + qHashCode + eHashCode + gHashCode + rHashCode + kHashCode;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CurveParams)) {
            return false;
        }
        CurveParams otherParams = (CurveParams)other;
        return this.oid.equals((Object)otherParams.oid) && this.q.equals(otherParams.q) && this.E.equals(otherParams.E) && this.g.equals(otherParams.g) && this.r.equals(otherParams.r) && this.k == otherParams.k;
    }

    public static class CurveParamsGF2nPentanomial
    extends CurveParamsGF2n {
        private int pc1;
        private int pc2;
        private int pc3;

        public CurveParamsGF2nPentanomial(String a, String b, String g, String r, String n, String k, String pc1, String pc2, String pc3) {
            super(r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.pc1 = Integer.valueOf(pc1);
            this.pc2 = Integer.valueOf(pc2);
            this.pc3 = Integer.valueOf(pc3);
            int[] polBytes = new int[this.n + 31 >> 5];
            polBytes[0] = 1;
            int n2 = this.pc1 >> 5;
            polBytes[n2] = polBytes[n2] | 1 << (this.pc1 & 0x1F);
            int n3 = this.pc2 >> 5;
            polBytes[n3] = polBytes[n3] | 1 << (this.pc2 & 0x1F);
            int n4 = this.pc3 >> 5;
            polBytes[n4] = polBytes[n4] | 1 << (this.pc3 & 0x1F);
            int n5 = this.n >> 5;
            polBytes[n5] = polBytes[n5] | 1 << (this.n & 0x1F);
            GF2Polynomial fieldPoly = new GF2Polynomial(this.n + 1, polBytes);
            GF2nPolynomialField polyField = null;
            try {
                polyField = new GF2nPolynomialField(this.n, fieldPoly);
            }
            catch (PolynomialIsNotIrreducibleException pinie) {
                throw new NoSuchBasisException(pinie.getMessage());
            }
            GF2nPolynomialElement mA = new GF2nPolynomialElement(polyField, encA);
            GF2nPolynomialElement mB = new GF2nPolynomialElement(polyField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.n);
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public CurveParamsGF2nPentanomial(PointGF2n g, FlexiBigInt r, int n, int k, int pc1, int pc2, int pc3) {
            super(g, r, n, k);
            this.pc1 = pc1;
            this.pc2 = pc2;
            this.pc3 = pc3;
        }

        protected CurveParamsGF2nPentanomial(String oid, String a, String b, String g, String r, String n, String k, String pc1, String pc2, String pc3) {
            super(oid, r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.pc1 = Integer.valueOf(pc1);
            this.pc2 = Integer.valueOf(pc2);
            this.pc3 = Integer.valueOf(pc3);
            int[] polBytes = new int[this.n + 31 >> 5];
            polBytes[0] = 1;
            int n2 = this.pc1 >> 5;
            polBytes[n2] = polBytes[n2] | 1 << (this.pc1 & 0x1F);
            int n3 = this.pc2 >> 5;
            polBytes[n3] = polBytes[n3] | 1 << (this.pc2 & 0x1F);
            int n4 = this.pc3 >> 5;
            polBytes[n4] = polBytes[n4] | 1 << (this.pc3 & 0x1F);
            int n5 = this.n >> 5;
            polBytes[n5] = polBytes[n5] | 1 << (this.n & 0x1F);
            GF2Polynomial fieldPoly = new GF2Polynomial(this.n + 1, polBytes);
            GF2nPolynomialField polyField = null;
            try {
                polyField = new GF2nPolynomialField(this.n, fieldPoly);
            }
            catch (PolynomialIsNotIrreducibleException pinie) {
                throw new NoSuchBasisException(pinie.getMessage());
            }
            GF2nPolynomialElement mA = new GF2nPolynomialElement(polyField, encA);
            GF2nPolynomialElement mB = new GF2nPolynomialElement(polyField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.n);
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public int getPC1() {
            return this.pc1;
        }

        public int getPC2() {
            return this.pc2;
        }

        public int getPC3() {
            return this.pc3;
        }

        public int hashCode() {
            return super.hashCode() + this.pc1 + this.pc2 + this.pc3;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof CurveParamsGF2nPentanomial)) {
                return false;
            }
            CurveParamsGF2nPentanomial otherParams = (CurveParamsGF2nPentanomial)other;
            return super.equals(other) && this.pc1 == otherParams.pc1 && this.pc2 == otherParams.pc2 && this.pc3 == otherParams.pc3;
        }
    }

    public static class CurveParamsGF2nTrinomial
    extends CurveParamsGF2n {
        private int tc;

        public CurveParamsGF2nTrinomial(String a, String b, String g, String r, String n, String k, String tc) {
            super(r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.tc = Integer.valueOf(tc);
            int[] polBytes = new int[this.n + 31 >> 5];
            polBytes[0] = 1;
            int n2 = this.tc >> 5;
            polBytes[n2] = polBytes[n2] | 1 << (this.tc & 0x1F);
            int n3 = this.n >> 5;
            polBytes[n3] = polBytes[n3] | 1 << (this.n & 0x1F);
            GF2Polynomial fieldPoly = new GF2Polynomial(this.n + 1, polBytes);
            GF2nPolynomialField polyField = null;
            try {
                polyField = new GF2nPolynomialField(this.n, fieldPoly);
            }
            catch (PolynomialIsNotIrreducibleException pinie) {
                throw new NoSuchBasisException(pinie.getMessage());
            }
            GF2nPolynomialElement mA = new GF2nPolynomialElement(polyField, encA);
            GF2nPolynomialElement mB = new GF2nPolynomialElement(polyField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.n);
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public CurveParamsGF2nTrinomial(PointGF2n g, FlexiBigInt r, int n, int k, int tc) {
            super(g, r, n, k);
            this.tc = tc;
        }

        protected CurveParamsGF2nTrinomial(String oid, String a, String b, String g, String r, String n, String k, String tc) {
            super(oid, r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.tc = Integer.valueOf(tc);
            int[] polBytes = new int[this.n + 31 >> 5];
            polBytes[0] = 1;
            int n2 = this.tc >> 5;
            polBytes[n2] = polBytes[n2] | 1 << (this.tc & 0x1F);
            int n3 = this.n >> 5;
            polBytes[n3] = polBytes[n3] | 1 << (this.n & 0x1F);
            GF2Polynomial fieldPoly = new GF2Polynomial(this.n + 1, polBytes);
            GF2nPolynomialField polyField = null;
            try {
                polyField = new GF2nPolynomialField(this.n, fieldPoly);
            }
            catch (PolynomialIsNotIrreducibleException pinie) {
                throw new NoSuchBasisException(pinie.getMessage());
            }
            GF2nPolynomialElement mA = new GF2nPolynomialElement(polyField, encA);
            GF2nPolynomialElement mB = new GF2nPolynomialElement(polyField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.n);
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public int getTC() {
            return this.tc;
        }

        public int hashCode() {
            return super.hashCode() + this.tc;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof CurveParamsGF2nTrinomial)) {
                return false;
            }
            CurveParamsGF2nTrinomial otherParams = (CurveParamsGF2nTrinomial)other;
            return super.equals(other) && this.tc == otherParams.tc;
        }
    }

    public static class CurveParamsGF2nONB
    extends CurveParamsGF2n {
        public CurveParamsGF2nONB(String a, String b, String g, String r, String n, String k) {
            super(r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            GF2nONBField onbField = new GF2nONBField(this.getN());
            GF2nONBElement mA = new GF2nONBElement(onbField, encA);
            GF2nONBElement mB = new GF2nONBElement(onbField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.getN());
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public CurveParamsGF2nONB(PointGF2n g, FlexiBigInt r, int n, int k) {
            super(g, r, n, k);
        }

        protected CurveParamsGF2nONB(String oid, String a, String b, String g, String r, String n, String k) {
            super(oid, r, n, k);
            String s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            GF2nONBField onbField = new GF2nONBField(this.getN());
            GF2nONBElement mA = new GF2nONBElement(onbField, encA);
            GF2nONBElement mB = new GF2nONBElement(onbField, encB);
            this.E = new EllipticCurveGF2n((GF2nElement)mA, (GF2nElement)mB, this.getN());
            this.g = new PointGF2n(encG, (EllipticCurveGF2n)this.E);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof CurveParamsGF2nONB)) {
                return false;
            }
            return super.equals(other);
        }
    }

    public static abstract class CurveParamsGF2n
    extends CurveParams {
        protected int n;

        protected CurveParamsGF2n(String r, String n, String k) {
            super(r, k);
            String s = StringUtils.filterSpaces(n);
            this.n = Integer.valueOf(s);
            this.q = FlexiBigInt.ONE.shiftLeft(this.n);
        }

        protected CurveParamsGF2n(String oid, String r, String n, String k) {
            super(oid, r, k);
            String s = StringUtils.filterSpaces(n);
            this.n = Integer.valueOf(s);
            this.q = FlexiBigInt.ONE.shiftLeft(this.n);
        }

        protected CurveParamsGF2n(PointGF2n g, FlexiBigInt r, int n, int k) {
            super(g, r, k);
            this.n = n;
        }

        public int getN() {
            return this.n;
        }

        public int hashCode() {
            return super.hashCode() + this.n;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof CurveParamsGF2n)) {
                return false;
            }
            CurveParamsGF2n otherParams = (CurveParamsGF2n)other;
            return super.equals(other) && this.n == otherParams.n;
        }
    }

    public static class CurveParamsGFP
    extends CurveParams {
        public CurveParamsGFP(String a, String b, String p, String g, String r, String k) {
            super(r, k);
            String s = StringUtils.filterSpaces(p);
            this.q = new FlexiBigInt(s, 16);
            s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            GFPElement mA = new GFPElement(encA, this.q);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            GFPElement mB = new GFPElement(encB, this.q);
            this.E = new EllipticCurveGFP(mA, mB, this.q);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.g = new PointGFP(encG, (EllipticCurveGFP)this.E);
        }

        public CurveParamsGFP(PointGFP g, FlexiBigInt r, int k) {
            super(g, r, k);
        }

        protected CurveParamsGFP(String oid, String a, String b, String p, String g, String r, String k) {
            super(oid, r, k);
            String s = StringUtils.filterSpaces(p);
            this.q = new FlexiBigInt(s, 16);
            s = StringUtils.filterSpaces(a);
            byte[] encA = ByteUtils.fromHexString(s);
            GFPElement mA = new GFPElement(encA, this.q);
            s = StringUtils.filterSpaces(b);
            byte[] encB = ByteUtils.fromHexString(s);
            GFPElement mB = new GFPElement(encB, this.q);
            this.E = new EllipticCurveGFP(mA, mB, this.q);
            s = StringUtils.filterSpaces(g);
            byte[] encG = ByteUtils.fromHexString(s);
            this.g = new PointGFP(encG, (EllipticCurveGFP)this.E);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof CurveParamsGFP)) {
                return false;
            }
            return super.equals(other);
        }
    }
}

