/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.ellipticcurves.ScalarMult;
import de.flexiprovider.common.math.finitefields.GFPElement;
import de.flexiprovider.common.util.SeedGenerator;

public class ECPRNG
extends SecureRandom {
    private static final String p = "965627713414686037773998887356363665495489701319";
    private static final String r = "965627713414686037773998839797242751054848709919";
    private static final String a = "965627713414686037773998887356363665495489701316";
    private static final String b = "69258789294063637963571905734367242074831358211";
    private static final String gx = "180154915808782548921909613234120456530839054533";
    private static final String gy = "322027385971935282160204922182313022993137363211";
    private static final String gamma = "412034918207550707882137137021287579344082387488";
    private static final String rtw = "965627713414686037773998934915484579936130692721";
    private static final String atw = "965627713414686037773998887356363665495489701316";
    private static final String btw = "896368924120622399810426981621996423420658343108";
    private static final String gxtw = "366500700833382456097277943560492718018620012876";
    private static final String gytw = "386244879790635939190694479506736774122111430939";
    private SeedGenerator seedGenerator = new SeedGenerator();
    private boolean mIsSeeded = false;
    private byte mCurrentByte;
    private int mSeedLength;
    private FlexiBigInt mP = new FlexiBigInt("965627713414686037773998887356363665495489701319");
    private FlexiBigInt mP_minus_1_half;
    private FlexiBigInt mGamma;
    private FlexiBigInt mGammaInverse;
    private EllipticCurveGFP mE;
    private EllipticCurveGFP mE_tw;
    private PointGFP mG;
    private PointGFP[] mGArray;
    private FlexiBigInt mR = new FlexiBigInt("965627713414686037773998839797242751054848709919");
    private FlexiBigInt mR_minus_1_half;
    private int bitLengthR;
    private PointGFP mG_tw;
    private PointGFP[] mG_twArray;
    private FlexiBigInt mR_tw;
    private FlexiBigInt mR_tw_minus_1_half;
    private int bitLengthR_tw;
    private PointGFP mPoint;
    private FlexiBigInt mX;
    private FlexiBigInt mY;
    private FlexiBigInt mS;
    private FlexiBigInt mS_minus_mR;
    private FlexiBigInt tmp;
    private byte mLocalByte;
    private byte mBitmask;

    public ECPRNG() throws InvalidPointException {
        this.mE = new EllipticCurveGFP(new GFPElement(new FlexiBigInt("965627713414686037773998887356363665495489701316"), this.mP), new GFPElement(new FlexiBigInt(b), this.mP), this.mP);
        this.mG = new PointGFP(new GFPElement(new FlexiBigInt(gx), this.mP), new GFPElement(new FlexiBigInt(gy), this.mP), this.mE);
        this.mGamma = new FlexiBigInt(gamma);
        this.mR_tw = new FlexiBigInt(rtw);
        this.mE_tw = new EllipticCurveGFP(new GFPElement(new FlexiBigInt("965627713414686037773998887356363665495489701316"), this.mP), new GFPElement(new FlexiBigInt(btw), this.mP), this.mP);
        this.mG_tw = new PointGFP(new GFPElement(new FlexiBigInt(gxtw), this.mP), new GFPElement(new FlexiBigInt(gytw), this.mP), this.mE_tw);
        this.mGammaInverse = this.mGamma.modInverse(this.mP);
        this.bitLengthR = this.mR.bitLength();
        this.bitLengthR_tw = this.mR_tw.bitLength();
        this.mP_minus_1_half = this.mP.subtract(FlexiBigInt.ONE);
        this.mP_minus_1_half = this.mP_minus_1_half.shiftRight(1);
        this.mR_minus_1_half = this.mR.subtract(FlexiBigInt.ONE);
        this.mR_minus_1_half = this.mR_minus_1_half.shiftRight(1);
        this.mR_tw_minus_1_half = this.mR_tw.subtract(FlexiBigInt.ONE);
        this.mR_tw_minus_1_half = this.mR_tw_minus_1_half.shiftRight(1);
        this.mSeedLength = this.bitLengthR + 1 >> 3;
        this.mPoint = new PointGFP(this.mG);
        this.mGArray = new PointGFP[this.bitLengthR];
        int kk = 0;
        while (kk < this.bitLengthR) {
            this.mGArray[kk] = new PointGFP(this.mPoint);
            this.mPoint.multiplyThisBy2();
            ++kk;
        }
        this.mPoint = new PointGFP(this.mG_tw);
        this.mG_twArray = new PointGFP[this.bitLengthR_tw];
        int kk2 = 0;
        while (kk2 < this.bitLengthR_tw) {
            this.mG_twArray[kk2] = new PointGFP(this.mPoint);
            this.mPoint.multiplyThisBy2();
            ++kk2;
        }
    }

    public byte[] generateSeed(int numBytes) {
        if (numBytes <= 0) {
            return new byte[0];
        }
        return this.seedGenerator.generateSeed(numBytes);
    }

    public void setSeed(byte[] seed) {
        this.initializeS(seed);
        this.mIsSeeded = true;
    }

    public void nextBytes(byte[] randomBytes) {
        int length = randomBytes.length;
        if (length == 0) {
            return;
        }
        if (!this.mIsSeeded) {
            this.initializeS(this.generateSeed(this.mSeedLength));
        }
        int i = 0;
        while (i < length) {
            randomBytes[i] = this.phi();
            ++i;
        }
        this.mIsSeeded = false;
    }

    private void initializeS(byte[] seed) {
        this.mS = new FlexiBigInt(seed);
        this.tmp = new FlexiBigInt(this.mP.toString());
        this.tmp.shiftLeft(1);
        this.tmp = this.tmp.add(FlexiBigInt.ONE);
        this.tmp = this.tmp.add(FlexiBigInt.ONE);
        if (this.mS.compareTo(FlexiBigInt.ZERO) == -1) {
            this.mS = this.mS.negate();
        }
        if (this.mS.compareTo(this.tmp) != -1) {
            this.mS = this.mS.remainder(this.tmp);
        }
    }

    private byte computeB(FlexiBigInt s, FlexiBigInt r, FlexiBigInt r_minus_1_half) {
        this.tmp = new FlexiBigInt(s.toString());
        this.mLocalByte = 0;
        this.mBitmask = 1;
        int i = 0;
        while (i < 8) {
            if (this.tmp.compareTo(r_minus_1_half) == 1) {
                this.mLocalByte = (byte)(this.mLocalByte | this.mBitmask);
            }
            this.tmp = this.tmp.shiftLeft(1);
            this.tmp = this.tmp.remainder(r);
            this.mBitmask = (byte)(this.mBitmask << 1);
            ++i;
        }
        return this.mLocalByte;
    }

    private byte phi() {
        if (this.mS.equals(FlexiBigInt.ZERO)) {
            this.mCurrentByte = 0;
            this.mS = this.mP.shiftLeft(1);
            return this.mCurrentByte;
        }
        if (this.mS.compareTo(this.mR) == -1) {
            this.mCurrentByte = this.computeB(this.mS, this.mR, this.mR_minus_1_half);
            this.mPoint = (PointGFP)ScalarMult.eval_SquareMultiply(ScalarMult.determineNaf(this.mS, 4), this.mGArray);
            this.mX = this.mPoint.getXAffin().toFlexiBigInt();
            this.mY = this.mPoint.getYAffin().toFlexiBigInt();
            this.mS = this.mX.shiftLeft(1);
            if (this.mY.compareTo(this.mP_minus_1_half) == 1) {
                this.mS = this.mS.add(FlexiBigInt.ONE);
            }
            return this.mCurrentByte;
        }
        if (this.mS.equals(this.mR)) {
            this.mCurrentByte = 0;
            this.mS = this.mP.shiftLeft(1);
            this.mS.add(FlexiBigInt.ONE);
            return this.mCurrentByte;
        }
        this.mS_minus_mR = this.mS.subtract(this.mR);
        this.mCurrentByte = this.computeB(this.mS_minus_mR, this.mR_tw, this.mR_tw_minus_1_half);
        this.mPoint = (PointGFP)ScalarMult.eval_SquareMultiply(ScalarMult.determineNaf(this.mS_minus_mR, 4), this.mG_twArray);
        this.mX = this.mPoint.getXAffin().toFlexiBigInt();
        this.mY = this.mPoint.getYAffin().toFlexiBigInt();
        this.mS = this.mX.multiply(this.mGammaInverse);
        this.mS = this.mS.remainder(this.mP);
        this.mS = this.mS.shiftLeft(1);
        if (this.mY.compareTo(this.mP_minus_1_half) == 1) {
            this.mS = this.mS.add(FlexiBigInt.ONE);
        }
        return this.mCurrentByte;
    }
}

