/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;

public abstract class Mode {
    private BlockCipher blockCipher;
    protected byte[] iv;
    protected int blockSize;

    final void setBlockCipher(BlockCipher blockCipher) {
        this.blockCipher = blockCipher;
    }

    protected abstract void initEncrypt(SecretKey var1, ModeParameterSpec var2, AlgorithmParameterSpec var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void initDecrypt(SecretKey var1, ModeParameterSpec var2, AlgorithmParameterSpec var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void nextChunkEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void nextChunkDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void reset();

    protected final void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.blockCipher.initCipherEncrypt(key, cipherParams);
    }

    protected final void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.blockCipher.initCipherDecrypt(key, cipherParams);
    }

    protected final int getCipherBlockSize() {
        return this.blockCipher.getCipherBlockSize();
    }

    protected final void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.blockCipher.singleBlockEncrypt(input, inOff, output, outOff);
    }

    protected final void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.blockCipher.singleBlockDecrypt(input, inOff, output, outOff);
    }
}

