/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import lombok.javac.CommentInfo;
import lombok.javac.Javac;
import lombok.javac.JavacTreeMaker;

public class PrettyCommentsPrinter
extends JCTree.Visitor {
    private static final JavacTreeMaker.TreeTag PARENS = JavacTreeMaker.TreeTag.treeTag("PARENS");
    private static final JavacTreeMaker.TreeTag IMPORT = JavacTreeMaker.TreeTag.treeTag("IMPORT");
    private static final JavacTreeMaker.TreeTag VARDEF = JavacTreeMaker.TreeTag.treeTag("VARDEF");
    private static final JavacTreeMaker.TreeTag SELECT = JavacTreeMaker.TreeTag.treeTag("SELECT");
    private static final Map<JavacTreeMaker.TreeTag, String> OPERATORS;
    private List<CommentInfo> comments;
    private final JCTree.JCCompilationUnit cu;
    private boolean onNewLine = true;
    private boolean aligned = false;
    private boolean inParams = false;
    private boolean needsSpace = false;
    private boolean needsNewLine = false;
    private boolean needsAlign = false;
    Writer out;
    int lmargin = 0;
    Name enclClassName;
    Map<JCTree, String> docComments = null;
    DocCommentTable docTable = null;
    String lineSep = System.getProperty("line.separator");
    int prec;

    public PrettyCommentsPrinter(Writer out, JCTree.JCCompilationUnit cu, List<CommentInfo> comments) {
        this.out = out;
        this.comments = comments;
        this.cu = cu;
    }

    private int endPos(JCTree tree) {
        return Javac.getEndPosition(tree, this.cu);
    }

    private void consumeComments(int until) throws IOException {
        this.consumeComments(until, null);
    }

    private void consumeComments(int until, JCTree tree) throws IOException {
        boolean prevNewLine = this.onNewLine;
        boolean found = false;
        CommentInfo head = (CommentInfo)this.comments.head;
        while (this.comments.nonEmpty() && head.pos < until) {
            this.printComment(head);
            this.comments = this.comments.tail;
            head = (CommentInfo)this.comments.head;
        }
        if (!this.onNewLine && prevNewLine) {
            this.println();
        }
    }

    private void consumeTrailingComments(int from) throws IOException {
        boolean prevNewLine = this.onNewLine;
        CommentInfo head = (CommentInfo)this.comments.head;
        boolean stop = false;
        while (this.comments.nonEmpty() && head.prevEndPos == from && !stop && head.start != CommentInfo.StartConnection.ON_NEXT_LINE && head.start != CommentInfo.StartConnection.START_OF_LINE) {
            from = head.endPos;
            this.printComment(head);
            stop = head.end == CommentInfo.EndConnection.ON_NEXT_LINE;
            this.comments = this.comments.tail;
            head = (CommentInfo)this.comments.head;
        }
        if (!this.onNewLine && prevNewLine) {
            this.println();
        }
    }

    private void printComment(CommentInfo comment) throws IOException {
        this.prepareComment(comment.start);
        this.print(comment.content);
        switch (comment.end) {
            case ON_NEXT_LINE: {
                if (this.aligned) break;
                this.needsNewLine = true;
                this.needsAlign = true;
                break;
            }
            case AFTER_COMMENT: {
                this.needsSpace = true;
                break;
            }
        }
    }

    private void prepareComment(CommentInfo.StartConnection start) throws IOException {
        switch (start) {
            case DIRECT_AFTER_PREVIOUS: {
                this.needsSpace = false;
                break;
            }
            case AFTER_PREVIOUS: {
                this.needsSpace = true;
                break;
            }
            case START_OF_LINE: {
                this.needsNewLine = true;
                this.needsAlign = false;
                break;
            }
            case ON_NEXT_LINE: {
                if (this.aligned) break;
                this.needsNewLine = true;
                this.needsAlign = true;
            }
        }
    }

    String getJavadocFor(JCTree node) {
        if (this.docComments != null) {
            return this.docComments.get(node);
        }
        if (this.docTable != null) {
            return this.docTable.getCommentText(node);
        }
        return null;
    }

    void align() throws IOException {
        this.onNewLine = false;
        this.aligned = true;
        this.needsAlign = false;
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.write("\t");
        }
    }

    void indent() {
        ++this.lmargin;
    }

    void undent() {
        --this.lmargin;
    }

    void open(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write("(");
        }
    }

    void close(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write(")");
        }
    }

    public void print(Object s) throws IOException {
        boolean align = this.needsAlign;
        if (this.needsNewLine && !this.onNewLine) {
            this.println();
        }
        if (align && !this.aligned) {
            this.align();
        }
        if (this.needsSpace && !this.onNewLine && !this.aligned) {
            this.out.write(32);
        }
        this.needsSpace = false;
        this.out.write(Convert.escapeUnicode(s.toString()));
        this.onNewLine = false;
        this.aligned = false;
    }

    public void println() throws IOException {
        this.onNewLine = true;
        this.aligned = false;
        this.needsNewLine = false;
        this.out.write(this.lineSep);
    }

    public void printExpr(JCTree tree, int prec) throws IOException {
        int prevPrec = this.prec;
        try {
            this.prec = prec;
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                this.consumeComments(tree.pos, tree);
                tree.accept(this);
                int endPos = this.endPos(tree);
                this.consumeTrailingComments(endPos);
            }
        }
        catch (UncheckedIOException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        finally {
            this.prec = prevPrec;
        }
    }

    public void printExpr(JCTree tree) throws IOException {
        this.printExpr(tree, 0);
    }

    public void printStat(JCTree tree) throws IOException {
        if (!this.isEmptyStat(tree)) {
            this.printExpr(tree, -1);
        }
    }

    public void printEmptyStat() throws IOException {
        this.print(";");
    }

    public boolean isEmptyStat(JCTree tree) {
        if (!(tree instanceof JCTree.JCBlock)) {
            return false;
        }
        JCTree.JCBlock block = (JCTree.JCBlock)tree;
        return -1 == block.pos && block.stats.isEmpty();
    }

    public <T extends JCTree> void printExprs(List<T> trees, String sep) throws IOException {
        if (trees.nonEmpty()) {
            this.printExpr((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    public <T extends JCTree> void printExprs(List<T> trees) throws IOException {
        this.printExprs(trees, ", ");
    }

    public void printStats(List<? extends JCTree> trees) throws IOException {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.align();
            this.printStat((JCTree)l.head);
            this.println();
            l = l.tail;
        }
    }

    public void printFlags(long flags) throws IOException {
        if ((flags & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(flags));
        if ((flags & 0xFFFL) != 0L) {
            this.print(" ");
        }
        if ((flags & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printAnnotations(List<JCTree.JCAnnotation> trees) throws IOException {
        List<JCTree.JCAnnotation> l = trees;
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            if (this.inParams) {
                this.print(" ");
            } else {
                this.println();
                this.align();
            }
            l = l.tail;
        }
    }

    public void printDocComment(JCTree tree) throws IOException {
        String dc = this.getJavadocFor(tree);
        if (dc == null) {
            return;
        }
        this.print("/**");
        this.println();
        int pos = 0;
        int endpos = PrettyCommentsPrinter.lineEndPos(dc, pos);
        boolean atStart = true;
        while (pos < dc.length()) {
            String line = dc.substring(pos, endpos);
            if (line.trim().isEmpty() && atStart) {
                atStart = false;
                continue;
            }
            atStart = false;
            this.align();
            this.print(" *");
            if (pos < dc.length() && dc.charAt(pos) > ' ') {
                this.print(" ");
            }
            this.print(dc.substring(pos, endpos));
            this.println();
            pos = endpos + 1;
            endpos = PrettyCommentsPrinter.lineEndPos(dc, pos);
        }
        this.align();
        this.print(" */");
        this.println();
        this.align();
    }

    static int lineEndPos(String s, int start) {
        int pos = s.indexOf(10, start);
        if (pos < 0) {
            pos = s.length();
        }
        return pos;
    }

    public void printTypeParameters(List<JCTree.JCTypeParameter> trees) throws IOException {
        if (trees.nonEmpty()) {
            this.print("<");
            this.printExprs(trees);
            this.print(">");
        }
    }

    public void printBlock(List<? extends JCTree> stats, JCTree container) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(stats);
        this.consumeComments(this.endPos(container));
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumBody(List<JCTree> stats) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        boolean first = true;
        List<JCTree> l = stats;
        while (l.nonEmpty()) {
            if (this.isEnumerator((JCTree)l.head)) {
                if (!first) {
                    this.print(",");
                    this.println();
                }
                this.align();
                this.printStat((JCTree)l.head);
                first = false;
            }
            l = l.tail;
        }
        this.print(";");
        this.println();
        int x = 0;
        List<JCTree> l2 = stats;
        while (l2.nonEmpty()) {
            ++x;
            if (!this.isEnumerator((JCTree)l2.head)) {
                this.align();
                this.printStat((JCTree)l2.head);
                this.println();
            }
            l2 = l2.tail;
        }
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumMember(JCTree.JCVariableDecl tree) throws IOException {
        this.printAnnotations(tree.mods.annotations);
        this.print(tree.name);
        if (tree.init instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass constructor = (JCTree.JCNewClass)tree.init;
            if (constructor.args != null && constructor.args.nonEmpty()) {
                this.print("(");
                this.printExprs(constructor.args);
                this.print(")");
            }
            if (constructor.def != null && constructor.def.defs != null) {
                this.print(" ");
                this.printBlock(constructor.def.defs, constructor.def);
            }
        }
    }

    boolean isEnumerator(JCTree t) {
        return VARDEF.equals(JavacTreeMaker.TreeTag.treeTag(t)) && (((JCTree.JCVariableDecl)t).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(JCTree.JCCompilationUnit tree, JCTree.JCClassDecl cdef) throws IOException {
        Object dc = Javac.getDocComments(tree);
        if (dc instanceof Map) {
            this.docComments = (Map)dc;
        } else if (dc instanceof DocCommentTable) {
            this.docTable = (DocCommentTable)dc;
        }
        this.printDocComment(tree);
        if (tree.pid != null) {
            this.consumeComments(tree.pos, tree);
            this.print("package ");
            this.printExpr(tree.pid);
            this.print(";");
            this.println();
        }
        boolean firstImport = true;
        List<JCTree> l = tree.defs;
        while (l.nonEmpty() && (cdef == null || IMPORT.equals(JavacTreeMaker.TreeTag.treeTag((JCTree)l.head)))) {
            if (IMPORT.equals(JavacTreeMaker.TreeTag.treeTag((JCTree)l.head))) {
                JCTree.JCImport imp = (JCTree.JCImport)l.head;
                Name name = TreeInfo.name(imp.qualid);
                if (name == name.table.fromChars(new char[]{'*'}, 0, 1) || cdef == null || this.isUsed(TreeInfo.symbol(imp.qualid), cdef)) {
                    if (firstImport) {
                        firstImport = false;
                        this.println();
                    }
                    this.printStat(imp);
                }
            } else {
                this.printStat((JCTree)l.head);
            }
            l = l.tail;
        }
        if (cdef != null) {
            this.printStat(cdef);
            this.println();
        }
    }

    boolean isUsed(final Symbol t, JCTree cdef) {
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && !this.result) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (tree.sym == t) {
                    this.result = true;
                }
            }
        }
        UsedVisitor v = new UsedVisitor();
        v.scan(cdef);
        return v.result;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        try {
            this.printUnit(tree, null);
            this.consumeComments(Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        try {
            this.print("import ");
            if (tree.staticImport) {
                this.print("static ");
            }
            this.printExpr(tree.qualid);
            this.print(";");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        try {
            this.consumeComments(tree.pos, tree);
            this.println();
            this.align();
            this.printDocComment(tree);
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags & 0xFFFFFFFFFFFFFDFFL);
            Name enclClassNamePrev = this.enclClassName;
            this.enclClassName = tree.name;
            if ((tree.mods.flags & 0x200L) != 0L) {
                this.print("interface " + tree.name);
                this.printTypeParameters(tree.typarams);
                if (tree.implementing.nonEmpty()) {
                    this.print(" extends ");
                    this.printExprs(tree.implementing);
                }
            } else {
                if ((tree.mods.flags & 0x4000L) != 0L) {
                    this.print("enum " + tree.name);
                } else {
                    this.print("class " + tree.name);
                }
                this.printTypeParameters(tree.typarams);
                if (Javac.getExtendsClause(tree) != null) {
                    this.print(" extends ");
                    this.printExpr(Javac.getExtendsClause(tree));
                }
                if (tree.implementing.nonEmpty()) {
                    this.print(" implements ");
                    this.printExprs(tree.implementing);
                }
            }
            this.print(" ");
            if ((tree.mods.flags & 0x200L) != 0L) {
                this.removeImplicitModifiersForInterfaceMembers(tree.defs);
            }
            if ((tree.mods.flags & 0x4000L) != 0L) {
                this.printEnumBody(tree.defs);
            } else {
                this.printBlock(tree.defs, tree);
            }
            this.enclClassName = enclClassNamePrev;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void removeImplicitModifiersForInterfaceMembers(List<JCTree> defs) {
        for (JCTree def : defs) {
            if (def instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)def).mods.flags &= 0xFFFFFFFFFFFFFFE6L;
            }
            if (def instanceof JCTree.JCMethodDecl) {
                ((JCTree.JCMethodDecl)def).mods.flags &= 0xFFFFFFFFFFFFFBFEL;
            }
            if (!(def instanceof JCTree.JCClassDecl)) continue;
            ((JCTree.JCClassDecl)def).mods.flags &= 0xFFFFFFFFFFFFFFF6L;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        try {
            boolean isGeneratedConstructor;
            boolean isConstructor;
            boolean bl = isConstructor = tree.name == tree.name.table.fromChars("<init>".toCharArray(), 0, 6);
            if (isConstructor && this.enclClassName == null) {
                return;
            }
            boolean bl2 = isGeneratedConstructor = isConstructor && (tree.mods.flags & 0x1000000000L) != 0L;
            if (isGeneratedConstructor) {
                return;
            }
            this.println();
            this.align();
            this.printDocComment(tree);
            this.printExpr(tree.mods);
            this.printTypeParameters(tree.typarams);
            if (tree.typarams != null && tree.typarams.length() > 0) {
                this.print(" ");
            }
            if (tree.name == tree.name.table.fromChars("<init>".toCharArray(), 0, 6)) {
                this.print(this.enclClassName != null ? this.enclClassName : tree.name);
            } else {
                this.printExpr(tree.restype);
                this.print(" " + tree.name);
            }
            this.print("(");
            this.inParams = true;
            this.printExprs(tree.params);
            this.inParams = false;
            this.print(")");
            if (tree.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(tree.thrown);
            }
            if (tree.defaultValue != null) {
                this.print(" default ");
                this.print(tree.defaultValue);
            }
            if (tree.body != null) {
                this.print(" ");
                this.printBlock(tree.body.stats, tree.body);
            } else {
                this.print(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        try {
            if (this.getJavadocFor(tree) != null) {
                this.println();
                this.align();
            }
            this.printDocComment(tree);
            if ((tree.mods.flags & 0x4000L) != 0L) {
                this.printEnumMember(tree);
            } else {
                this.printExpr(tree.mods);
                if ((tree.mods.flags & 0x400000000L) != 0L) {
                    this.printExpr(((JCTree.JCArrayTypeTree)tree.vartype).elemtype);
                    this.print("... " + tree.name);
                } else {
                    this.printExpr(tree.vartype);
                    this.print(" " + tree.name);
                }
                if (tree.init != null) {
                    this.print(" = ");
                    this.printExpr(tree.init);
                }
                if (this.prec == -1) {
                    this.print(";");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
        try {
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        try {
            this.consumeComments(tree.pos);
            this.printFlags(tree.flags);
            this.printBlock(tree.stats, tree);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        try {
            this.print("do ");
            this.printStat(tree.body);
            this.align();
            this.print(" while ");
            if (PARENS.equals(JavacTreeMaker.TreeTag.treeTag(tree.cond))) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        try {
            this.print("while ");
            if (PARENS.equals(JavacTreeMaker.TreeTag.treeTag(tree.cond))) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        try {
            this.print("for (");
            if (tree.init.nonEmpty()) {
                if (VARDEF.equals(JavacTreeMaker.TreeTag.treeTag((JCTree)tree.init.head))) {
                    this.printExpr((JCTree)tree.init.head);
                    List l = tree.init.tail;
                    while (l.nonEmpty()) {
                        JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)l.head;
                        this.print(", " + vdef.name + " = ");
                        this.printExpr(vdef.init);
                        l = l.tail;
                    }
                } else {
                    this.printExprs(tree.init);
                }
            }
            this.print("; ");
            if (tree.cond != null) {
                this.printExpr(tree.cond);
            }
            this.print("; ");
            this.printExprs(tree.step);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        try {
            this.print("for (");
            this.printExpr(tree.var);
            this.print(" : ");
            this.printExpr(tree.expr);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        try {
            this.print(tree.label + ": ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        try {
            this.print("switch ");
            if (PARENS.equals(JavacTreeMaker.TreeTag.treeTag(tree.selector))) {
                this.printExpr(tree.selector);
            } else {
                this.print("(");
                this.printExpr(tree.selector);
                this.print(")");
            }
            this.print(" {");
            this.println();
            this.printStats(tree.cases);
            this.align();
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        try {
            if (tree.pat == null) {
                this.print("default");
            } else {
                this.print("case ");
                this.printExpr(tree.pat);
            }
            this.print(": ");
            this.println();
            this.indent();
            this.printStats(tree.stats);
            this.undent();
            this.align();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        try {
            this.print("synchronized ");
            if (PARENS.equals(JavacTreeMaker.TreeTag.treeTag(tree.lock))) {
                this.printExpr(tree.lock);
            } else {
                this.print("(");
                this.printExpr(tree.lock);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        try {
            this.print("try ");
            List resources = null;
            try {
                Field f = JCTree.JCTry.class.getField("resources");
                resources = (List)f.get(tree);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (resources != null && resources.nonEmpty()) {
                boolean first = true;
                this.print("(");
                for (Object var0 : resources) {
                    JCTree var = (JCTree)var0;
                    if (!first) {
                        this.println();
                        this.indent();
                    }
                    this.printStat(var);
                    first = false;
                }
                this.print(") ");
            }
            this.printStat(tree.body);
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                this.printStat((JCTree)l.head);
                l = l.tail;
            }
            if (tree.finalizer != null) {
                this.print(" finally ");
                this.printStat(tree.finalizer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        try {
            this.print(" catch (");
            this.printExpr(tree.param);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        try {
            this.open(this.prec, 3);
            this.printExpr(tree.cond, 3);
            this.print(" ? ");
            this.printExpr(tree.truepart, 3);
            this.print(" : ");
            this.printExpr(tree.falsepart, 3);
            this.close(this.prec, 3);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        try {
            this.print("if ");
            if (PARENS.equals(JavacTreeMaker.TreeTag.treeTag(tree.cond))) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.thenpart);
            if (tree.elsepart != null) {
                this.print(" else ");
                this.printStat(tree.elsepart);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isNoArgsSuperCall(JCTree.JCExpression expr) {
        if (!(expr instanceof JCTree.JCMethodInvocation)) {
            return false;
        }
        JCTree.JCMethodInvocation tree = (JCTree.JCMethodInvocation)expr;
        if (!tree.typeargs.isEmpty() || !tree.args.isEmpty()) {
            return false;
        }
        if (!(tree.meth instanceof JCTree.JCIdent)) {
            return false;
        }
        return ((JCTree.JCIdent)tree.meth).name.toString().equals("super");
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        if (this.isNoArgsSuperCall(tree.expr)) {
            return;
        }
        try {
            this.printExpr(tree.expr);
            if (this.prec == -1) {
                this.print(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        try {
            this.print("break");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        try {
            this.print("continue");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        try {
            this.print("return");
            if (tree.expr != null) {
                this.print(" ");
                this.printExpr(tree.expr);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        try {
            this.print("throw ");
            this.printExpr(tree.expr);
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        try {
            this.print("assert ");
            this.printExpr(tree.cond);
            if (tree.detail != null) {
                this.print(" : ");
                this.printExpr(tree.detail);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        try {
            if (!tree.typeargs.isEmpty()) {
                if (SELECT.equals(JavacTreeMaker.TreeTag.treeTag(tree.meth))) {
                    JCTree.JCFieldAccess left = (JCTree.JCFieldAccess)tree.meth;
                    this.printExpr(left.selected);
                    this.print(".<");
                    this.printExprs(tree.typeargs);
                    this.print(">" + left.name);
                } else {
                    this.print("<");
                    this.printExprs(tree.typeargs);
                    this.print(">");
                    this.printExpr(tree.meth);
                }
            } else {
                this.printExpr(tree.meth);
            }
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        try {
            if (tree.encl != null) {
                this.printExpr(tree.encl);
                this.print(".");
            }
            this.print("new ");
            if (!tree.typeargs.isEmpty()) {
                this.print("<");
                this.printExprs(tree.typeargs);
                this.print(">");
            }
            this.printExpr(tree.clazz);
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
            if (tree.def != null) {
                Name enclClassNamePrev = this.enclClassName;
                Name name = tree.def.name != null ? tree.def.name : (this.enclClassName = tree.type != null && tree.type.tsym.name != tree.type.tsym.name.table.fromChars(new char[0], 0, 0) ? tree.type.tsym.name : null);
                if ((tree.def.mods.flags & 0x4000L) != 0L) {
                    this.print("/*enum*/");
                }
                this.printBlock(tree.def.defs, tree.def);
                this.enclClassName = enclClassNamePrev;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        try {
            if (tree.elemtype != null) {
                this.print("new ");
                JCTree.JCExpression elem = tree.elemtype;
                if (elem instanceof JCTree.JCArrayTypeTree) {
                    this.printBaseElementType((JCTree.JCArrayTypeTree)elem);
                } else {
                    this.printExpr(elem);
                }
                List<JCTree.JCExpression> l = tree.dims;
                while (l.nonEmpty()) {
                    this.print("[");
                    this.printExpr((JCTree)l.head);
                    this.print("]");
                    l = l.tail;
                }
                if (elem instanceof JCTree.JCArrayTypeTree) {
                    this.printBrackets((JCTree.JCArrayTypeTree)elem);
                }
            }
            if (tree.elems != null) {
                if (tree.elemtype != null) {
                    this.print("[]");
                }
                this.print("{");
                this.printExprs(tree.elems);
                this.print("}");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        try {
            this.print("(");
            this.printExpr(tree.expr);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        try {
            this.open(this.prec, 1);
            this.printExpr(tree.lhs, 2);
            this.print(" = ");
            this.printExpr(tree.rhs, 1);
            this.close(this.prec, 1);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String operatorName(JavacTreeMaker.TreeTag tag) {
        String result = OPERATORS.get(tag);
        if (result == null) {
            throw new Error();
        }
        return result;
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        try {
            this.open(this.prec, 2);
            this.printExpr(tree.lhs, 3);
            this.print(" = ");
            this.printExpr(tree.rhs, 2);
            this.close(this.prec, 2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        try {
            int ownprec = this.isOwnPrec(tree);
            String opname = this.operatorName(JavacTreeMaker.TreeTag.treeTag(tree));
            this.open(this.prec, ownprec);
            if (this.isPrefixUnary(tree)) {
                this.print(opname);
                this.printExpr(tree.arg, ownprec);
            } else {
                this.printExpr(tree.arg, ownprec);
                this.print(opname);
            }
            this.close(this.prec, ownprec);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int isOwnPrec(JCTree.JCExpression tree) {
        return JavacTreeMaker.TreeTag.treeTag(tree).getOperatorPrecedenceLevel();
    }

    private boolean isPrefixUnary(JCTree.JCUnary tree) {
        return JavacTreeMaker.TreeTag.treeTag(tree).isPrefixUnaryOp();
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        try {
            int ownprec = this.isOwnPrec(tree);
            String opname = this.operatorName(JavacTreeMaker.TreeTag.treeTag(tree));
            this.open(this.prec, ownprec);
            this.printExpr(tree.lhs, ownprec);
            this.print(" " + opname + " ");
            this.printExpr(tree.rhs, ownprec + 1);
            this.close(this.prec, ownprec);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        try {
            this.open(this.prec, 14);
            this.print("(");
            this.printExpr(tree.clazz);
            this.print(")");
            this.printExpr(tree.expr, 14);
            this.close(this.prec, 14);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        try {
            this.open(this.prec, 10);
            this.printExpr(tree.expr, 10);
            this.print(" instanceof ");
            this.printExpr(tree.clazz, 11);
            this.close(this.prec, 10);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        try {
            this.printExpr(tree.indexed, 15);
            this.print("[");
            this.printExpr(tree.index);
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        try {
            this.printExpr(tree.selected, 15);
            this.print("." + tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        try {
            this.print(tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        JavacTreeMaker.TypeTag typeTag = JavacTreeMaker.TypeTag.typeTag(tree);
        try {
            if (Javac.CTC_INT.equals(typeTag)) {
                this.print(tree.value.toString());
            } else if (Javac.CTC_LONG.equals(typeTag)) {
                this.print(tree.value + "L");
            } else if (Javac.CTC_FLOAT.equals(typeTag)) {
                this.print(tree.value + "F");
            } else if (Javac.CTC_DOUBLE.equals(typeTag)) {
                this.print(tree.value.toString());
            } else if (Javac.CTC_CHAR.equals(typeTag)) {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)tree.value).intValue())) + "'");
            } else if (Javac.CTC_BOOLEAN.equals(typeTag)) {
                this.print(((Number)tree.value).intValue() == 1 ? "true" : "false");
            } else if (Javac.CTC_BOT.equals(typeTag)) {
                this.print("null");
            } else {
                this.print("\"" + Convert.quote(tree.value.toString()) + "\"");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        JavacTreeMaker.TypeTag typetag = JavacTreeMaker.TypeTag.typeTag(tree);
        try {
            if (Javac.CTC_BYTE.equals(typetag)) {
                this.print("byte");
            } else if (Javac.CTC_CHAR.equals(typetag)) {
                this.print("char");
            } else if (Javac.CTC_SHORT.equals(typetag)) {
                this.print("short");
            } else if (Javac.CTC_INT.equals(typetag)) {
                this.print("int");
            } else if (Javac.CTC_LONG.equals(typetag)) {
                this.print("long");
            } else if (Javac.CTC_FLOAT.equals(typetag)) {
                this.print("float");
            } else if (Javac.CTC_DOUBLE.equals(typetag)) {
                this.print("double");
            } else if (Javac.CTC_BOOLEAN.equals(typetag)) {
                this.print("boolean");
            } else if (Javac.CTC_VOID.equals(typetag)) {
                this.print("void");
            } else {
                this.print("error");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        try {
            this.printBaseElementType(tree);
            this.printBrackets(tree);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void printBaseElementType(JCTree.JCArrayTypeTree tree) throws IOException {
        JCTree elem = tree.elemtype;
        while (elem instanceof JCTree.JCWildcard) {
            elem = ((JCTree.JCWildcard)elem).inner;
        }
        if (elem instanceof JCTree.JCArrayTypeTree) {
            this.printBaseElementType((JCTree.JCArrayTypeTree)elem);
        } else {
            this.printExpr(elem);
        }
    }

    private void printBrackets(JCTree.JCArrayTypeTree tree) throws IOException {
        while (true) {
            JCTree.JCExpression elem = tree.elemtype;
            this.print("[]");
            if (!(elem instanceof JCTree.JCArrayTypeTree)) break;
            tree = (JCTree.JCArrayTypeTree)elem;
        }
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        try {
            this.printExpr(tree.clazz);
            this.print("<");
            this.printExprs(tree.arguments);
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        try {
            this.print(tree.name);
            if (tree.bounds.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.bounds, " & ");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        try {
            Object kind = tree.getClass().getField("kind").get(tree);
            this.print(kind);
            if (kind != null && kind.getClass().getSimpleName().equals("TypeBoundKind")) {
                kind = kind.getClass().getField("kind").get(kind);
            }
            if (tree.getKind() != Tree.Kind.UNBOUNDED_WILDCARD) {
                this.printExpr(tree.inner);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
        try {
            this.print(String.valueOf((Object)tree.kind));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        try {
            this.print("(ERROR)");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        try {
            this.print("(let " + tree.defs + " in " + tree.expr + ")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers mods) {
        try {
            this.printAnnotations(mods.annotations);
            this.printFlags(mods.flags);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        try {
            this.print("@");
            this.printExpr(tree.annotationType);
            if (tree.args.nonEmpty()) {
                JCTree.JCExpression lhs;
                this.print("(");
                if (tree.args.length() == 1 && tree.args.get(0) instanceof JCTree.JCAssign && (lhs = ((JCTree.JCAssign)tree.args.get((int)0)).lhs) instanceof JCTree.JCIdent && ((JCTree.JCIdent)lhs).name.toString().equals("value")) {
                    tree.args = List.of(((JCTree.JCAssign)tree.args.get((int)0)).rhs);
                }
                this.printExprs(tree.args);
                this.print(")");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTree(JCTree tree) {
        try {
            if ("JCTypeUnion".equals(tree.getClass().getSimpleName())) {
                this.print(tree.toString());
                return;
            }
            this.print("(UNKNOWN: " + tree + ")");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        HashMap<JavacTreeMaker.TreeTag, String> map = new HashMap<JavacTreeMaker.TreeTag, String>();
        map.put(JavacTreeMaker.TreeTag.treeTag("POS"), "+");
        map.put(JavacTreeMaker.TreeTag.treeTag("NEG"), "-");
        map.put(JavacTreeMaker.TreeTag.treeTag("NOT"), "!");
        map.put(JavacTreeMaker.TreeTag.treeTag("COMPL"), "~");
        map.put(JavacTreeMaker.TreeTag.treeTag("PREINC"), "++");
        map.put(JavacTreeMaker.TreeTag.treeTag("PREDEC"), "--");
        map.put(JavacTreeMaker.TreeTag.treeTag("POSTINC"), "++");
        map.put(JavacTreeMaker.TreeTag.treeTag("POSTDEC"), "--");
        map.put(JavacTreeMaker.TreeTag.treeTag("NULLCHK"), "<*nullchk*>");
        map.put(JavacTreeMaker.TreeTag.treeTag("OR"), "||");
        map.put(JavacTreeMaker.TreeTag.treeTag("AND"), "&&");
        map.put(JavacTreeMaker.TreeTag.treeTag("EQ"), "==");
        map.put(JavacTreeMaker.TreeTag.treeTag("NE"), "!=");
        map.put(JavacTreeMaker.TreeTag.treeTag("LT"), "<");
        map.put(JavacTreeMaker.TreeTag.treeTag("GT"), ">");
        map.put(JavacTreeMaker.TreeTag.treeTag("LE"), "<=");
        map.put(JavacTreeMaker.TreeTag.treeTag("GE"), ">=");
        map.put(JavacTreeMaker.TreeTag.treeTag("BITOR"), "|");
        map.put(JavacTreeMaker.TreeTag.treeTag("BITXOR"), "^");
        map.put(JavacTreeMaker.TreeTag.treeTag("BITAND"), "&");
        map.put(JavacTreeMaker.TreeTag.treeTag("SL"), "<<");
        map.put(JavacTreeMaker.TreeTag.treeTag("SR"), ">>");
        map.put(JavacTreeMaker.TreeTag.treeTag("USR"), ">>>");
        map.put(JavacTreeMaker.TreeTag.treeTag("PLUS"), "+");
        map.put(JavacTreeMaker.TreeTag.treeTag("MINUS"), "-");
        map.put(JavacTreeMaker.TreeTag.treeTag("MUL"), "*");
        map.put(JavacTreeMaker.TreeTag.treeTag("DIV"), "/");
        map.put(JavacTreeMaker.TreeTag.treeTag("MOD"), "%");
        OPERATORS = map;
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException e) {
            super(e.getMessage(), e);
        }
    }
}

