/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContextException;
import org.springframework.security.config.authentication.CachingUserDetailsService;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDetailsServiceInjectionBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableListableBeanFactory beanFactory;
    private final String x509ProviderId;
    private final String rememberMeServicesId;
    private final String openIDProviderId;

    public UserDetailsServiceInjectionBeanPostProcessor(String x509ProviderId, String rememberMeServicesId, String openIDProviderId) {
        this.x509ProviderId = x509ProviderId;
        this.rememberMeServicesId = rememberMeServicesId;
        this.openIDProviderId = openIDProviderId;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (beanName == null) {
            return bean;
        }
        if (beanName.equals(this.x509ProviderId)) {
            this.injectUserDetailsServiceIntoX509Provider((PreAuthenticatedAuthenticationProvider)bean);
        } else if (beanName.equals(this.rememberMeServicesId)) {
            this.injectUserDetailsServiceIntoRememberMeServices(bean);
        } else if (beanName.equals(this.openIDProviderId)) {
            this.injectUserDetailsServiceIntoOpenIDProvider(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void injectUserDetailsServiceIntoRememberMeServices(Object rms) {
        if (!(rms instanceof AbstractRememberMeServices)) {
            this.logger.info((Object)"RememberMeServices is not an instance of AbstractRememberMeServices. UserDetailsService will not be automatically injected.");
            return;
        }
        AbstractRememberMeServices services = (AbstractRememberMeServices)rms;
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(this.rememberMeServicesId);
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("userDetailsService");
        if (pv == null) {
            services.setUserDetailsService(this.getUserDetailsService());
        } else {
            UserDetailsService cachingUserService = this.getCachingUserService(pv.getValue());
            if (cachingUserService != null) {
                services.setUserDetailsService(cachingUserService);
            }
        }
    }

    private void injectUserDetailsServiceIntoX509Provider(PreAuthenticatedAuthenticationProvider provider) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(this.x509ProviderId);
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("preAuthenticatedUserDetailsService");
        UserDetailsByNameServiceWrapper wrapper = new UserDetailsByNameServiceWrapper();
        if (pv == null) {
            wrapper.setUserDetailsService(this.getUserDetailsService());
            provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)wrapper);
        } else {
            RootBeanDefinition preAuthUserService = (RootBeanDefinition)pv.getValue();
            Object userService = preAuthUserService.getPropertyValues().getPropertyValue("userDetailsService").getValue();
            UserDetailsService cachingUserService = this.getCachingUserService(userService);
            if (cachingUserService != null) {
                wrapper.setUserDetailsService(cachingUserService);
                provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)wrapper);
            }
        }
    }

    private void injectUserDetailsServiceIntoOpenIDProvider(Object bean) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(this.openIDProviderId);
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("userDetailsService");
        if (pv == null) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
            beanWrapper.setPropertyValue("userDetailsService", (Object)this.getUserDetailsService());
        }
    }

    UserDetailsService getUserDetailsService() {
        Map<String, ?> beans = this.getBeansOfType(CachingUserDetailsService.class);
        if (beans.size() == 0) {
            beans = this.getBeansOfType(UserDetailsService.class);
        }
        if (beans.size() == 0) {
            throw new ApplicationContextException("No UserDetailsService registered.");
        }
        if (beans.size() > 1) {
            throw new ApplicationContextException("More than one UserDetailsService registered. Please use a specific Id reference in <remember-me/> <openid-login/> or <x509 /> elements.");
        }
        return (UserDetailsService)beans.values().toArray()[0];
    }

    private UserDetailsService getCachingUserService(Object userServiceRef) {
        Assert.isInstanceOf(RuntimeBeanReference.class, (Object)userServiceRef, (String)"userDetailsService property value must be a RuntimeBeanReference");
        String id = ((RuntimeBeanReference)userServiceRef).getBeanName();
        String cachingId = id + ".caching";
        if (this.beanFactory.containsBeanDefinition(cachingId)) {
            return (UserDetailsService)this.beanFactory.getBean(cachingId);
        }
        return null;
    }

    private Map<String, ?> getBeansOfType(Class<?> type) {
        Map beans = this.beanFactory.getBeansOfType(type);
        BeanFactory parent = this.beanFactory.getParentBeanFactory();
        while (parent != null && beans.size() == 0) {
            if (parent instanceof ListableBeanFactory) {
                beans = ((ListableBeanFactory)parent).getBeansOfType(type);
            }
            if (!(parent instanceof HierarchicalBeanFactory)) break;
            parent = ((HierarchicalBeanFactory)parent).getParentBeanFactory();
        }
        return beans;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

