/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.Rectangle;

public class ShearFilter
extends TransformFilter {
    private double xangle = 0.0;
    private double yangle = 0.0;
    private double shx = 0.0;
    private double shy = 0.0;
    private double xoffset = 0.0;
    private double yoffset = 0.0;
    private boolean resize = true;

    public void setResize(boolean bl) {
        this.resize = bl;
    }

    public boolean isResize() {
        return this.resize;
    }

    public void setXAngle(double d) {
        this.xangle = d;
        this.initialize();
    }

    public double getXAngle() {
        return this.xangle;
    }

    public void setYAngle(double d) {
        this.yangle = d;
        this.initialize();
    }

    public double getYAngle() {
        return this.yangle;
    }

    private void initialize() {
        this.shx = Math.sin(this.xangle);
        this.shy = Math.sin(this.yangle);
    }

    protected void transformSpace(Rectangle rectangle) {
        double d = Math.tan(this.xangle);
        this.xoffset = (double)(-rectangle.height) * d;
        if (d < 0.0) {
            d = -d;
        }
        rectangle.width = (int)((double)rectangle.height * d + (double)rectangle.width + 0.999999);
        d = Math.tan(this.yangle);
        this.yoffset = (double)(-rectangle.width) * d;
        if (d < 0.0) {
            d = -d;
        }
        rectangle.height = (int)((double)rectangle.width * d + (double)rectangle.height + 0.999999);
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        dArray[0] = (double)n + this.xoffset + (double)n2 * this.shx;
        dArray[1] = (double)n2 + this.yoffset + (double)n * this.shy;
    }

    public String toString() {
        return "Distort/Shear...";
    }
}

